/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.cipher.android;

import android.database.SQLException;
import android.support.annotation.NonNull;
import com.j256.ormlite.cipher.android.AndroidDatabaseConnection;
import com.j256.ormlite.cipher.db.SqliteAndroidDatabaseType;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.BaseConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseConnectionProxyFactory;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteOpenHelper;

public class AndroidConnectionSource
extends BaseConnectionSource
implements ConnectionSource {
    private static final Logger logger = LoggerFactory.getLogger(AndroidConnectionSource.class);
    private final SQLiteOpenHelper helper;
    private final SQLiteDatabase sqliteDatabase;
    private final String password;
    private DatabaseConnection connection = null;
    private volatile boolean isOpen = true;
    private final DatabaseType databaseType = new SqliteAndroidDatabaseType();
    private static DatabaseConnectionProxyFactory connectionProxyFactory;
    private boolean cancelQueriesEnabled = false;

    public AndroidConnectionSource(SQLiteOpenHelper helper, @NonNull String password) {
        this.helper = helper;
        this.sqliteDatabase = null;
        this.password = password;
    }

    public AndroidConnectionSource(SQLiteDatabase sqliteDatabase, @NonNull String password) {
        this.helper = null;
        this.sqliteDatabase = sqliteDatabase;
        this.password = password;
    }

    public DatabaseConnection getReadOnlyConnection(String tableName) throws java.sql.SQLException {
        return this.getReadWriteConnection(tableName);
    }

    public DatabaseConnection getReadWriteConnection(String tableName) throws java.sql.SQLException {
        DatabaseConnection conn = this.getSavedConnection();
        if (conn != null) {
            return conn;
        }
        if (this.connection == null) {
            SQLiteDatabase db;
            if (this.sqliteDatabase == null) {
                try {
                    db = this.helper.getWritableDatabase(this.password);
                }
                catch (SQLException e) {
                    throw SqlExceptionUtil.create((String)("Getting a writable database from helper " + this.helper + " failed"), (Throwable)e);
                }
            } else {
                db = this.sqliteDatabase;
            }
            this.connection = new AndroidDatabaseConnection(db, true, this.cancelQueriesEnabled);
            if (connectionProxyFactory != null) {
                this.connection = connectionProxyFactory.createProxy(this.connection);
            }
            logger.trace("created connection {} for db {}, helper {}", (Object)this.connection, (Object)db, (Object)this.helper);
        } else {
            logger.trace("{}: returning read-write connection {}, helper {}", (Object)this, (Object)this.connection, (Object)this.helper);
        }
        return this.connection;
    }

    public void releaseConnection(DatabaseConnection connection) {
    }

    public boolean saveSpecialConnection(DatabaseConnection connection) throws java.sql.SQLException {
        return this.saveSpecial(connection);
    }

    public void clearSpecialConnection(DatabaseConnection connection) {
        this.clearSpecial(connection, logger);
    }

    public void close() {
        this.isOpen = false;
    }

    public void closeQuietly() {
        this.close();
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public boolean isOpen(String tableName) {
        return this.isOpen;
    }

    public boolean isSingleConnection(String tableName) {
        return true;
    }

    public static void setDatabaseConnectionProxyFactory(DatabaseConnectionProxyFactory connectionProxyFactory) {
        AndroidConnectionSource.connectionProxyFactory = connectionProxyFactory;
    }

    public boolean isCancelQueriesEnabled() {
        return this.cancelQueriesEnabled;
    }

    public void setCancelQueriesEnabled(boolean cancelQueriesEnabled) {
        this.cancelQueriesEnabled = cancelQueriesEnabled;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "@" + Integer.toHexString(super.hashCode());
    }
}

