/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.cipher.android;

import android.os.Build;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.DatabaseFieldConfig;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.ArrayList;

public class DatabaseTableConfigUtil {
    public static final String DISABLE_ANNOTATION_HACK_SYSTEM_PROPERTY = "ormlite.annotation.hack.disable";
    private static Class<?> annotationFactoryClazz;
    private static Field elementsField;
    private static Class<?> annotationMemberClazz;
    private static Field nameField;
    private static Field valueField;
    private static int workedC;
    private static final int[] configFieldNums;
    private static final int COLUMN_NAME = 1;
    private static final int DATA_TYPE = 2;
    private static final int DEFAULT_VALUE = 3;
    private static final int WIDTH = 4;
    private static final int CAN_BE_NULL = 5;
    private static final int ID = 6;
    private static final int GENERATED_ID = 7;
    private static final int GENERATED_ID_SEQUENCE = 8;
    private static final int FOREIGN = 9;
    private static final int USE_GET_SET = 10;
    private static final int UNKNOWN_ENUM_NAME = 11;
    private static final int THROW_IF_NULL = 12;
    private static final int PERSISTED = 13;
    private static final int FORMAT = 14;
    private static final int UNIQUE = 15;
    private static final int UNIQUE_COMBO = 16;
    private static final int INDEX = 17;
    private static final int UNIQUE_INDEX = 18;
    private static final int INDEX_NAME = 19;
    private static final int UNIQUE_INDEX_NAME = 20;
    private static final int FOREIGN_AUTO_REFRESH = 21;
    private static final int MAX_FOREIGN_AUTO_REFRESH_LEVEL = 22;
    private static final int PERSISTER_CLASS = 23;
    private static final int ALLOW_GENERATED_ID_INSERT = 24;
    private static final int COLUMN_DEFINITON = 25;
    private static final int FOREIGN_AUTO_CREATE = 26;
    private static final int VERSION = 27;
    private static final int FOREIGN_COLUMN_NAME = 28;
    private static final int READ_ONLY = 29;

    public static <T> DatabaseTableConfig<T> fromClass(ConnectionSource connectionSource, Class<T> clazz) throws SQLException {
        DatabaseType databaseType = connectionSource.getDatabaseType();
        String tableName = DatabaseTableConfig.extractTableName(clazz);
        ArrayList<DatabaseFieldConfig> fieldConfigs = new ArrayList<DatabaseFieldConfig>();
        for (Class<T> classWalk = clazz; classWalk != null; classWalk = classWalk.getSuperclass()) {
            for (Field field : classWalk.getDeclaredFields()) {
                DatabaseFieldConfig config = DatabaseTableConfigUtil.configFromField(databaseType, tableName, field);
                if (config == null || !config.isPersisted()) continue;
                fieldConfigs.add(config);
            }
        }
        if (fieldConfigs.size() == 0) {
            return null;
        }
        return new DatabaseTableConfig(clazz, tableName, fieldConfigs);
    }

    public static int getWorkedC() {
        return workedC;
    }

    private static int[] lookupClasses() {
        Field fieldField;
        Class<?> annotationMemberArrayClazz;
        try {
            annotationFactoryClazz = Class.forName("org.apache.harmony.lang.annotation.AnnotationFactory");
            annotationMemberClazz = Class.forName("org.apache.harmony.lang.annotation.AnnotationMember");
            annotationMemberArrayClazz = Class.forName("[Lorg.apache.harmony.lang.annotation.AnnotationMember;");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            elementsField = annotationFactoryClazz.getDeclaredField("elements");
            elementsField.setAccessible(true);
            nameField = annotationMemberClazz.getDeclaredField("name");
            nameField.setAccessible(true);
            valueField = annotationMemberClazz.getDeclaredField("value");
            valueField.setAccessible(true);
            fieldField = DatabaseFieldSample.class.getDeclaredField("field");
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        DatabaseField databaseField = fieldField.getAnnotation(DatabaseField.class);
        InvocationHandler proxy = Proxy.getInvocationHandler(databaseField);
        if (proxy.getClass() != annotationFactoryClazz) {
            return null;
        }
        try {
            Object elements = elementsField.get(proxy);
            if (elements == null || elements.getClass() != annotationMemberArrayClazz) {
                return null;
            }
            Object[] elementArray = (Object[])elements;
            int[] configNums = new int[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                String name = (String)nameField.get(elementArray[i]);
                configNums[i] = DatabaseTableConfigUtil.configFieldNameToNum(name);
            }
            return configNums;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private static int configFieldNameToNum(String configName) {
        if (configName.equals("columnName")) {
            return 1;
        }
        if (configName.equals("dataType")) {
            return 2;
        }
        if (configName.equals("defaultValue")) {
            return 3;
        }
        if (configName.equals("width")) {
            return 4;
        }
        if (configName.equals("canBeNull")) {
            return 5;
        }
        if (configName.equals("id")) {
            return 6;
        }
        if (configName.equals("generatedId")) {
            return 7;
        }
        if (configName.equals("generatedIdSequence")) {
            return 8;
        }
        if (configName.equals("foreign")) {
            return 9;
        }
        if (configName.equals("useGetSet")) {
            return 10;
        }
        if (configName.equals("unknownEnumName")) {
            return 11;
        }
        if (configName.equals("throwIfNull")) {
            return 12;
        }
        if (configName.equals("persisted")) {
            return 13;
        }
        if (configName.equals("format")) {
            return 14;
        }
        if (configName.equals("unique")) {
            return 15;
        }
        if (configName.equals("uniqueCombo")) {
            return 16;
        }
        if (configName.equals("index")) {
            return 17;
        }
        if (configName.equals("uniqueIndex")) {
            return 18;
        }
        if (configName.equals("indexName")) {
            return 19;
        }
        if (configName.equals("uniqueIndexName")) {
            return 20;
        }
        if (configName.equals("foreignAutoRefresh")) {
            return 21;
        }
        if (configName.equals("maxForeignAutoRefreshLevel")) {
            return 22;
        }
        if (configName.equals("persisterClass")) {
            return 23;
        }
        if (configName.equals("allowGeneratedIdInsert")) {
            return 24;
        }
        if (configName.equals("columnDefinition")) {
            return 25;
        }
        if (configName.equals("foreignAutoCreate")) {
            return 26;
        }
        if (configName.equals("version")) {
            return 27;
        }
        if (configName.equals("foreignColumnName")) {
            return 28;
        }
        if (configName.equals("readOnly")) {
            return 29;
        }
        throw new IllegalStateException("Could not find support for DatabaseField " + configName);
    }

    private static DatabaseFieldConfig configFromField(DatabaseType databaseType, String tableName, Field field) throws SQLException {
        if (configFieldNums == null) {
            return DatabaseFieldConfig.fromField((DatabaseType)databaseType, (String)tableName, (Field)field);
        }
        DatabaseField databaseField = field.getAnnotation(DatabaseField.class);
        DatabaseFieldConfig config = null;
        try {
            if (databaseField != null) {
                config = DatabaseTableConfigUtil.buildConfig(databaseField, tableName, field);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (config == null) {
            return DatabaseFieldConfig.fromField((DatabaseType)databaseType, (String)tableName, (Field)field);
        }
        ++workedC;
        return config;
    }

    private static DatabaseFieldConfig buildConfig(DatabaseField databaseField, String tableName, Field field) throws Exception {
        InvocationHandler proxy = Proxy.getInvocationHandler(databaseField);
        if (proxy.getClass() != annotationFactoryClazz) {
            return null;
        }
        Object elementsObject = elementsField.get(proxy);
        if (elementsObject == null) {
            return null;
        }
        DatabaseFieldConfig config = new DatabaseFieldConfig(field.getName());
        Object[] objs = (Object[])elementsObject;
        for (int i = 0; i < configFieldNums.length; ++i) {
            Object value = valueField.get(objs[i]);
            if (value == null) continue;
            DatabaseTableConfigUtil.assignConfigField(configFieldNums[i], config, field, value);
        }
        return config;
    }

    private static void assignConfigField(int configNum, DatabaseFieldConfig config, Field field, Object value) {
        switch (configNum) {
            case 1: {
                config.setColumnName(DatabaseTableConfigUtil.valueIfNotBlank((String)value));
                break;
            }
            case 2: {
                config.setDataType((DataType)value);
                break;
            }
            case 3: {
                String defaultValue = (String)value;
                if (defaultValue == null || defaultValue.equals("__ormlite__ no default value string was specified")) break;
                config.setDefaultValue(defaultValue);
                break;
            }
            case 4: {
                config.setWidth(((Integer)value).intValue());
                break;
            }
            case 5: {
                config.setCanBeNull(((Boolean)value).booleanValue());
                break;
            }
            case 6: {
                config.setId(((Boolean)value).booleanValue());
                break;
            }
            case 7: {
                config.setGeneratedId(((Boolean)value).booleanValue());
                break;
            }
            case 8: {
                config.setGeneratedIdSequence(DatabaseTableConfigUtil.valueIfNotBlank((String)value));
                break;
            }
            case 9: {
                config.setForeign(((Boolean)value).booleanValue());
                break;
            }
            case 10: {
                config.setUseGetSet(((Boolean)value).booleanValue());
                break;
            }
            case 11: {
                config.setUnknownEnumValue(DatabaseFieldConfig.findMatchingEnumVal((Field)field, (String)((String)value)));
                break;
            }
            case 12: {
                config.setThrowIfNull(((Boolean)value).booleanValue());
                break;
            }
            case 13: {
                config.setPersisted(((Boolean)value).booleanValue());
                break;
            }
            case 14: {
                config.setFormat(DatabaseTableConfigUtil.valueIfNotBlank((String)value));
                break;
            }
            case 15: {
                config.setUnique(((Boolean)value).booleanValue());
                break;
            }
            case 16: {
                config.setUniqueCombo(((Boolean)value).booleanValue());
                break;
            }
            case 17: {
                config.setIndex(((Boolean)value).booleanValue());
                break;
            }
            case 18: {
                config.setUniqueIndex(((Boolean)value).booleanValue());
                break;
            }
            case 19: {
                config.setIndexName(DatabaseTableConfigUtil.valueIfNotBlank((String)value));
                break;
            }
            case 20: {
                config.setUniqueIndexName(DatabaseTableConfigUtil.valueIfNotBlank((String)value));
                break;
            }
            case 21: {
                config.setForeignAutoRefresh(((Boolean)value).booleanValue());
                break;
            }
            case 22: {
                config.setMaxForeignAutoRefreshLevel(((Integer)value).intValue());
                break;
            }
            case 23: {
                Class clazz = (Class)value;
                config.setPersisterClass(clazz);
                break;
            }
            case 24: {
                config.setAllowGeneratedIdInsert(((Boolean)value).booleanValue());
                break;
            }
            case 25: {
                config.setColumnDefinition(DatabaseTableConfigUtil.valueIfNotBlank((String)value));
                break;
            }
            case 26: {
                config.setForeignAutoCreate(((Boolean)value).booleanValue());
                break;
            }
            case 27: {
                config.setVersion(((Boolean)value).booleanValue());
                break;
            }
            case 28: {
                config.setForeignColumnName(DatabaseTableConfigUtil.valueIfNotBlank((String)value));
                break;
            }
            case 29: {
                config.setReadOnly(((Boolean)value).booleanValue());
                break;
            }
            default: {
                throw new IllegalStateException("Could not find support for DatabaseField number " + configNum);
            }
        }
    }

    private static String valueIfNotBlank(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    static {
        workedC = 0;
        configFieldNums = (int[])(Build.VERSION.SDK_INT < 14 && System.getProperty(DISABLE_ANNOTATION_HACK_SYSTEM_PROPERTY) == null ? DatabaseTableConfigUtil.lookupClasses() : null);
    }

    private static class DatabaseFieldSample {
        @DatabaseField
        String field;

        private DatabaseFieldSample() {
        }
    }
}

