/*
 * Decompiled with CFR 0.152.
 */
package com.izikode.izilib.veinview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RawRes;
import android.util.AttributeSet;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.izikode.izilib.veinview.R;
import com.izikode.izilib.veinview.VeinViewClient;
import com.izikode.izilib.veinview.VeinViewInjections;
import com.izikode.izilib.veinview.VeinViewInjector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class VeinView
extends WebView {
    private String injectCSS;
    private String injectJS;
    private VeinViewInjector injector;

    public VeinView(Context context) {
        super(context);
        this.init();
    }

    public VeinView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public VeinView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @Deprecated
    public void setWebViewClient(WebViewClient client) {
        super.setWebViewClient(client);
    }

    public void setVeinViewClient(@NonNull VeinViewClient client) {
        client.setInjector(this.injector);
        super.setWebViewClient((WebViewClient)client);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void init() {
        this.injectCSS = this.resource(R.raw.inject_css);
        this.injectJS = this.resource(R.raw.inject_js);
        this.injector = new VeinViewInjector(new VeinViewInjections(){

            @Override
            public void css(@NonNull String code) {
                VeinView.this.injectCSS(code);
            }

            @Override
            public void css(int codeResource) {
                VeinView.this.injectCSS(codeResource);
            }

            @Override
            public void js(@NonNull String code) {
                VeinView.this.injectJS(code);
            }

            @Override
            public void js(int codeResource) {
                VeinView.this.injectJS(codeResource);
            }
        });
        this.getSettings().setJavaScriptEnabled(true);
    }

    private void injectCSS(@NonNull String css) {
        this.run(String.format(this.injectCSS, css.trim()));
    }

    private void injectCSS(@RawRes int cssResource) {
        this.injectCSS(this.resource(cssResource));
    }

    private void injectJS(@NonNull String js) {
        this.run(String.format(this.injectJS, js.trim()));
    }

    private void injectJS(@RawRes int jsResource) {
        this.injectJS(this.resource(jsResource));
    }

    private void run(@NonNull String javascript) {
        String code = String.format("javascript:(function() { %1$s })()", javascript);
        this.loadUrl(code);
    }

    private String resource(@RawRes int resource) {
        InputStream raw2 = this.getResources().openRawResource(resource);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int chunk = raw2.read();
            while (chunk != -1) {
                out.write(chunk);
                chunk = raw2.read();
            }
            raw2.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toString();
    }
}

