/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.plugin;

import com.apache.api.manager.ProxyManager;
import com.apache.api.vo.ParamsVo;
import com.apache.api.vo.ResultEntity;
import com.apache.cache.service.impl.LoadCacheFactory;
import com.apache.database.constant.SpringContextLoader;
import com.apache.database.datasource.ConnctionData;
import com.apache.database.datasource.DynamicDataSource;
import com.apache.database.datasource.DynamicDataSourceHolder;
import com.apache.database.db.IDao;
import com.apache.database.model.MethodParam;
import com.apache.exception.BusinessException;
import com.apache.ius.able.ScheduledExecutor;
import com.apache.ius.able.SelectDatasourceCall;
import com.apache.rpc.common.LoadRpcService;
import com.apache.rpc.entity.InterfaceRegister;
import com.apache.rpc.entity.RpcDatasource;
import com.apache.tools.ConfigUtil;
import com.apache.tools.DataMap;
import com.apache.tools.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilPlugin {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    ProxyManager iusProxyManager = (ProxyManager)SpringContextLoader.getBean((String)"iusProxyManager");
    private IDao iusPubDao = (IDao)SpringContextLoader.getBean((String)"iusPubDao");
    private static UtilPlugin instance;

    public static UtilPlugin getInstance() {
        if (null == instance) {
            instance = new UtilPlugin();
        }
        return instance;
    }

    public List<DataMap> getListByParams(String datasource, String searchObjName, Map<String, Object> whereMap) throws BusinessException {
        List<Object> list = new ArrayList<DataMap>();
        ParamsVo vo = new ParamsVo();
        if (whereMap != null && whereMap.size() > 0) {
            vo.setParams(whereMap);
        }
        vo.setKey("iusTransaction");
        vo.setParams("resultType", (Object)"objInfo");
        vo.setParams("resultObjType", (Object)"list");
        vo.setParams("sqlKeyId", (Object)"");
        vo.setParams("modelTypes", (Object)searchObjName);
        vo.setParams("datasource", (Object)datasource);
        this.log.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + vo.getParams());
        ResultEntity res = (ResultEntity)this.iusProxyManager.doInvoke(vo);
        if (res.getEntity() != null) {
            list = (List)res.getEntity();
        }
        return list;
    }

    public Object selectBySql(String sql, int pageIndex, int pageSize) {
        this.log.info("\u6267\u884c\u81ea\u5b9a\u4e49SQL\uff1a" + sql);
        this.log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1apageIndex=" + pageIndex + ",pageSize=" + pageSize);
        MethodParam params = new MethodParam("ByObjInfo", "", "", "com.apache.ius.sql.DymicMapper");
        params.setParams("dyncSql", sql);
        params.setResultCache(false);
        DynamicDataSourceHolder.putDataSource((String)DynamicDataSource.getInstance().getDefaultDataSourceKey());
        if (pageSize > 0 && pageIndex > 0) {
            params.setPageIndex(pageIndex);
            params.setPageSize(pageSize);
            return this.iusPubDao.pageSelect(params);
        }
        return this.iusPubDao.select(params);
    }

    public ResultEntity saveByParams(String datasource, String saveObjName, Map<String, Object> paramsMap) throws BusinessException {
        ParamsVo vo = new ParamsVo();
        if (paramsMap != null && paramsMap.size() > 0) {
            vo.setParams(paramsMap);
        }
        vo.setKey("iusTransaction");
        vo.setParams("resultType", (Object)"processSql");
        vo.setParams("sqlKeyId", (Object)"");
        vo.setParams("modelTypes", (Object)saveObjName);
        vo.setParams("datasource", (Object)datasource);
        this.log.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + vo.getParams());
        ResultEntity res = (ResultEntity)this.iusProxyManager.saveInvoke(vo);
        return res;
    }

    public long countByParams(String datasource, String searchObjName, Map<String, Object> whereMap) throws BusinessException {
        ParamsVo vo = new ParamsVo();
        if (whereMap != null && whereMap.size() > 0) {
            vo.setParams(whereMap);
        }
        vo.setKey("iusTransaction");
        vo.setParams("resultType", (Object)"objInfo");
        vo.setParams("resultObjType", (Object)"count");
        vo.setParams("sqlKeyId", (Object)"");
        vo.setParams("modelTypes", (Object)searchObjName);
        vo.setParams("datasource", (Object)datasource);
        this.log.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + vo.getParams());
        ResultEntity res = (ResultEntity)this.iusProxyManager.doInvoke(vo);
        if (res.getEntity() != null) {
            return Long.parseLong(String.valueOf(res.getEntity()));
        }
        return 0L;
    }

    public ResultEntity selectInfoForDatasource(String datasource, String modelTypes, String resultObjType, Map<String, Object> whereMap) {
        whereMap.put("datasource", datasource);
        whereMap.put("modelTypes", modelTypes);
        whereMap.put("resultObjType", resultObjType);
        whereMap.put("resultType", "objInfo");
        if (null == whereMap.get("sqlKeyId")) {
            whereMap.put("sqlKeyId", "sqlKeyId");
        }
        whereMap.put("sysPass", ConfigUtil.getInstance().interfacePass());
        this.log.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + whereMap);
        InterfaceRegister register = new InterfaceRegister();
        register.setAddress("127.0.0.1");
        register.setCallType("socket");
        return LoadRpcService.service().doServiceClient(this.getBeanId(datasource), "dymicSql", whereMap, register);
    }

    public ResultEntity saveInfoForDatasource(String datasource, String saveObjName, Map<String, Object> paramsMap) throws BusinessException {
        paramsMap.put("datasource", datasource);
        paramsMap.put("modelTypes", saveObjName);
        paramsMap.put("resultType", "processSql");
        paramsMap.put("sqlKeyId", "");
        paramsMap.put("sysPass", ConfigUtil.getInstance().interfacePass());
        this.log.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + paramsMap);
        InterfaceRegister register = new InterfaceRegister();
        register.setAddress("127.0.0.1");
        register.setCallType("socket");
        return LoadRpcService.service().doServiceClient(this.getBeanId(datasource), "dymicSql", paramsMap, register);
    }

    public Object selectObjectForDatasource(String sql, String datasource) {
        if (StrUtil.isNotNull((String)(datasource = StrUtil.doNull((String)datasource, (String)DynamicDataSource.getInstance().getDefaultDataSourceKey()))) && !datasource.startsWith("slave") && LoadCacheFactory.getInstance().getCacheManager("").checkCacheObject("rpc_datasource_slave" + datasource)) {
            datasource = "slave" + datasource;
        }
        this.log.info("\u8de8\u6570\u636e\u6e90[" + datasource + "]\u6267\u884c\u81ea\u5b9a\u4e49SQL\uff1a" + sql);
        SelectDatasourceCall call = new SelectDatasourceCall(sql, datasource);
        try {
            Future<Object> future1 = ScheduledExecutor.instance().submitObj(call);
            Object obj = future1.get();
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean saveOrUpdateBySql(String datasource, String sql) {
        Object dbDao = null;
        datasource = StrUtil.doNull((String)datasource, (String)DynamicDataSource.getInstance().getDefaultDataSourceKey());
        if (!DynamicDataSource.getInstance().checkDataSource(datasource)) {
            Object obj = LoadCacheFactory.getInstance().getCacheManager("").getCacheObjectByKey("rpc_datasource_" + datasource);
            if (null == obj) {
                return false;
            }
            RpcDatasource rds = (RpcDatasource)obj;
            if (!DynamicDataSource.getInstance().addDataSource(rds.getSysEname(), rds.getDriverClassName(), rds.getJdbcUrl(), rds.getJdbcUsername(), rds.getJdbcPassword())) {
                return false;
            }
        }
        this.log.info("\u901a\u8fc7\u6570\u636e\u6e90[" + datasource + "]\u6267\u884c\u81ea\u5b9a\u4e49SQL\uff1a" + sql);
        return ConnctionData.getInstance().execute(datasource, sql);
    }

    public Object selectObjectForSqlByPage(String sql, String datasource, int pageIndex, int pageSize) {
        if (StrUtil.isNotNull((String)(datasource = StrUtil.doNull((String)datasource, (String)DynamicDataSource.getInstance().getDefaultDataSourceKey()))) && !datasource.startsWith("slave") && LoadCacheFactory.getInstance().getCacheManager("").checkCacheObject("rpc_datasource_slave" + datasource)) {
            datasource = "slave" + datasource;
        }
        this.log.info("\u901a\u8fc7\u6570\u636e\u6e90[{}]\u6267\u884c\u81ea\u5b9a\u4e49SQL\uff1a{} \u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1apageIndex={},pageSize={}", new Object[]{datasource, sql, pageIndex, pageSize});
        SelectDatasourceCall call = new SelectDatasourceCall(sql, datasource, pageIndex, pageSize);
        try {
            Future<Object> future1 = ScheduledExecutor.instance().submitObj(call);
            Object obj = future1.get();
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isExites(String beanId) {
        if (StrUtil.isNull((String)beanId)) {
            return false;
        }
        String cacheKey = "interfaceRegister_" + beanId;
        return LoadCacheFactory.getInstance().getCacheManager("").checkCacheObject(cacheKey);
    }

    private String getBeanId(String datasourceName) {
        String beanId = "iusService";
        if (StrUtil.isNotNull((String)datasourceName)) {
            if ("cms".equals(datasourceName)) {
                beanId = "websiteService";
            } else {
                beanId = datasourceName + "Service";
                if (!this.isExites(beanId)) {
                    beanId = "iusService";
                }
            }
        }
        return beanId;
    }
}

