/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.plugin;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.apache.api.manager.ProxyManager;
import com.apache.api.vo.ParamsVo;
import com.apache.api.vo.ResultEntity;
import com.apache.cache.service.impl.LoadCacheFactory;
import com.apache.client.IUSRequestParams;
import com.apache.database.constant.SpringContextLoader;
import com.apache.database.datasource.ConnctionData;
import com.apache.database.datasource.DynamicDataSource;
import com.apache.database.datasource.DynamicDataSourceHolder;
import com.apache.database.db.IDao;
import com.apache.database.model.MethodParam;
import com.apache.exception.BusinessException;
import com.apache.ius.able.CacheHelper;
import com.apache.ius.able.ScheduledExecutor;
import com.apache.ius.able.SelectDatasourceCall;
import com.apache.ius.plugin.LogsPlugin;
import com.apache.rpc.common.LoadRpcService;
import com.apache.rpc.entity.InterfaceRegister;
import com.apache.rpc.entity.RpcDatasource;
import com.apache.tools.ConfigUtil;
import com.apache.tools.StrUtil;
import com.apache.uct.common.ToolsUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IusPluginUtil {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ProxyManager iusProxyManager;
    private IDao iusPubDao;
    private LogsPlugin defalutLogsPlugin;
    private static IusPluginUtil instance;

    private IusPluginUtil() {
    }

    public ResultEntity select(String resultType, String searchObjName, Map<String, Object> whereMap) throws BusinessException {
        ParamsVo vo = new ParamsVo();
        if (whereMap != null && whereMap.size() > 0) {
            vo.setParams(whereMap);
        }
        vo.setKey("iusTransaction");
        vo.setParams("resultType", (Object)"objInfo");
        vo.setParams("resultObjType", (Object)resultType);
        vo.setParams("modelTypes", (Object)searchObjName);
        if (!whereMap.containsKey("datasource")) {
            vo.setParams("datasource", (Object)DynamicDataSource.getInstance().getDefaultDataSourceKey());
        }
        this.log.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + vo.getParams());
        ResultEntity res = (ResultEntity)this.iusProxyManager.doInvoke(vo);
        return res;
    }

    public ResultEntity select(String datasource, String resultType, String searchObjName, Map<String, Object> whereMap) throws BusinessException {
        whereMap.put("datasource", datasource);
        whereMap.put("modelTypes", searchObjName);
        whereMap.put("resultObjType", resultType);
        whereMap.put("resultType", "objInfo");
        if (StrUtil.isNull((String)String.valueOf(whereMap.get("sqlKeyId")))) {
            whereMap.put("sqlKeyId", "sqlKeyId");
        }
        whereMap.put("sysPass", ConfigUtil.getInstance().interfacePass());
        this.log.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + whereMap);
        InterfaceRegister register = new InterfaceRegister();
        register.setAddress("127.0.0.1");
        register.setCallType("socket");
        ResultEntity res = LoadRpcService.service().doServiceClient(this.getBeanId(datasource), "dymicSql", whereMap, register);
        return res;
    }

    public ResultEntity sendToIusService(String pageName, String formName, Map<String, Object> paramMap) throws BusinessException {
        ResultEntity entity = new ResultEntity();
        entity.setResult("false");
        entity.setMessage("\u901a\u4fe1\u5931\u8d25");
        this.log.info("\u8bf7\u6c42\u63a5\u53e3\uff1asendToIusService ---> pageName=" + pageName + ",formName=" + formName);
        if (paramMap == null) {
            paramMap = new HashMap<String, Object>();
        }
        paramMap.put("sysPass", ConfigUtil.getInstance().interfacePass());
        paramMap.put("resultType", "objInfo");
        paramMap.put("req_pageName", pageName);
        paramMap.put("req_formName", formName);
        try {
            String req_sysEname = ConfigUtil.getInstance().getLocalByKey("config.properties", "sysEname");
            paramMap.put("req_sysEname", req_sysEname);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String pkey = formName + "_" + pageName;
        Map mapCache = (Map)CacheHelper.getInstance().getIusParamCache(pkey);
        if (ToolsUtil.isEmpty((Object)mapCache)) {
            throw new BusinessException("\u7f13\u5b58\u6570\u636e\u4e2d\u672a\u627e\u5230key->" + pkey);
        }
        String datasource = String.valueOf(mapCache.get("sysName"));
        Map params = IUSRequestParams.analyzeParams((Map)mapCache, paramMap);
        paramMap.putAll(params);
        this.log.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + paramMap);
        InterfaceRegister register = new InterfaceRegister();
        register.setAddress("127.0.0.1");
        register.setCallType("socket");
        entity = LoadRpcService.service().doServiceClient(this.getBeanId(datasource), "dymicSql", paramMap, register);
        this.log.info("\u8fd4\u56de\u7ed3\u679c\uff1a" + JSONObject.fromObject((Object)entity));
        return entity;
    }

    public Object select(String sql, int pageIndex, int pageSize) throws BusinessException {
        this.log.info("\u6267\u884c\u81ea\u5b9a\u4e49SQL\uff1a" + sql);
        this.log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1apageIndex=" + pageIndex + ",pageSize=" + pageSize);
        MethodParam params = new MethodParam("ByObjInfo", "", "", "com.apache.ius.sql.DymicMapper");
        params.setParams("dyncSql", sql);
        params.setResultCache(false);
        DynamicDataSourceHolder.putDataSource((String)DynamicDataSource.getInstance().getDefaultDataSourceKey());
        if (pageSize > 0 && pageIndex > 0) {
            params.setPageIndex(pageIndex);
            params.setPageSize(pageSize);
            return this.iusPubDao.pageSelect(params);
        }
        return this.iusPubDao.select(params);
    }

    public Object selectLinked(String sql, int pageIndex, int pageSize) throws BusinessException {
        this.log.info("\u6267\u884c\u81ea\u5b9a\u4e49SQL\uff1a" + sql);
        this.log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1apageIndex=" + pageIndex + ",pageSize=" + pageSize);
        MethodParam params = new MethodParam("ByLinkedObjInfo", "", "", "com.apache.ius.sql.DymicMapper");
        params.setParams("dyncSql", sql);
        params.setResultCache(false);
        DynamicDataSourceHolder.putDataSource((String)DynamicDataSource.getInstance().getDefaultDataSourceKey());
        if (pageSize > 0 && pageIndex > 0) {
            params.setPageIndex(pageIndex);
            params.setPageSize(pageSize);
            return this.iusPubDao.pageSelect(params);
        }
        return this.iusPubDao.select(params);
    }

    public Object select(String datasource, String sql, int pageIndex, int pageSize) throws BusinessException {
        if (StrUtil.isNotNull((String)(datasource = StrUtil.doNull((String)datasource, (String)DynamicDataSource.getInstance().getDefaultDataSourceKey()))) && !datasource.startsWith("slave") && LoadCacheFactory.getInstance().getCacheManager("").checkCacheObject("rpc_datasource_slave" + datasource)) {
            datasource = "slave" + datasource;
        }
        this.log.info("\u901a\u8fc7\u6570\u636e\u6e90[{}]\u6267\u884c\u81ea\u5b9a\u4e49SQL\uff1a{} \u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1apageIndex={},pageSize={}", new Object[]{datasource, sql, pageIndex, pageSize});
        try {
            if (pageSize > 0 && pageIndex > 0) {
                SelectDatasourceCall call = new SelectDatasourceCall(sql, datasource, pageIndex, pageSize);
                Future<Object> future1 = ScheduledExecutor.instance().submitObj(call);
                Object obj = future1.get();
                return obj;
            }
            return ConnctionData.getInstance().selectListInfo(datasource, sql);
        }
        catch (Exception e) {
            this.log.error("\u6267\u884csql=" + sql + ";\u6267\u884c\u5931\u8d25:" + e.getMessage());
            return null;
        }
    }

    public Object selectLinked(String datasource, String sql, int pageIndex, int pageSize) throws BusinessException {
        if (StrUtil.isNotNull((String)(datasource = StrUtil.doNull((String)datasource, (String)DynamicDataSource.getInstance().getDefaultDataSourceKey()))) && !datasource.startsWith("slave") && LoadCacheFactory.getInstance().getCacheManager("").checkCacheObject("rpc_datasource_slave" + datasource)) {
            datasource = "slave" + datasource;
        }
        this.log.info("\u901a\u8fc7\u6570\u636e\u6e90[{}]\u6267\u884c\u81ea\u5b9a\u4e49SQL\uff1a{} \u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1apageIndex={},pageSize={}", new Object[]{datasource, sql, pageIndex, pageSize});
        try {
            SelectDatasourceCall call = new SelectDatasourceCall(sql, datasource, pageIndex, pageSize, true);
            Future<Object> future1 = ScheduledExecutor.instance().submitObj(call);
            Object obj = future1.get();
            return obj;
        }
        catch (Exception e) {
            this.log.error("\u6267\u884csql=" + sql + ";\u6267\u884c\u5931\u8d25:" + e.getMessage());
            return null;
        }
    }

    public Map selectInfo(String sql) throws BusinessException {
        this.log.info("\u6267\u884c\u81ea\u5b9a\u4e49SQL\uff1a" + sql);
        MethodParam params = new MethodParam("ByObjInfo", "", "", "com.apache.ius.sql.DymicMapper");
        params.setParams("dyncSql", sql);
        params.setResultCache(false);
        DynamicDataSourceHolder.putDataSource((String)DynamicDataSource.getInstance().getDefaultDataSourceKey());
        return (Map)this.iusPubDao.selectSingle(params);
    }

    public Map selectInfo(String datasource, String sql) throws BusinessException {
        this.log.info("\u901a\u8fc7\u6570\u636e\u6e90[" + datasource + "]\u6267\u884c\u81ea\u5b9a\u4e49SQL\uff1a" + sql);
        try {
            Connection con = this.getDataSource(datasource, "select");
            return ConnctionData.getInstance().selectInfo(con, sql);
        }
        catch (SQLException e) {
            this.log.error("\u6267\u884csql=" + sql + ";\u6267\u884c\u5931\u8d25:" + e.getMessage());
            return null;
        }
    }

    public long countInfo(String sql) {
        this.log.info("\u6267\u884c\u81ea\u5b9a\u4e49SQL\uff1a" + sql);
        MethodParam params = new MethodParam("ByObjInfo", "", "", "com.apache.ius.sql.DymicMapper");
        params.setParams("dyncSql", sql);
        params.setResultCache(false);
        DynamicDataSourceHolder.putDataSource((String)DynamicDataSource.getInstance().getDefaultDataSourceKey());
        return this.iusPubDao.count(params);
    }

    public long countInfo(String datasource, String sql) {
        this.log.info("\u901a\u8fc7\u6570\u636e\u6e90[" + datasource + "]\u6267\u884c\u81ea\u5b9a\u4e49SQL\uff1a" + sql);
        try {
            Connection con = this.getDataSource(datasource, "select");
            return ConnctionData.getInstance().selectCount(con, sql);
        }
        catch (SQLException e) {
            this.log.error("\u6267\u884csql=" + sql + ";\u6267\u884c\u5931\u8d25:" + e.getMessage());
            return 0L;
        }
    }

    public ResultEntity saveInvoke(String saveObjName, Map<String, Object> paramsMap, boolean isTransaction) throws BusinessException {
        ParamsVo vo = new ParamsVo();
        if (paramsMap != null && paramsMap.size() > 0) {
            vo.setParams(paramsMap);
        }
        vo.setKey("iusTransaction");
        vo.setParams("resultType", (Object)"processSql");
        vo.setParams("modelTypes", (Object)saveObjName);
        if (!paramsMap.containsKey("datasource")) {
            vo.setParams("datasource", (Object)DynamicDataSource.getInstance().getDefaultDataSourceKey());
        }
        this.log.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + vo.getParams());
        ResultEntity res = null;
        res = isTransaction ? (ResultEntity)this.iusProxyManager.saveInvoke(vo) : (ResultEntity)this.iusProxyManager.doInvoke(vo);
        return res;
    }

    public boolean saveInvoke(String sql) throws BusinessException {
        MethodParam params = new MethodParam("ByDymicSql", "", "", "com.apache.ius.sql.DymicMapper");
        params.setParams("execSql", sql);
        DynamicDataSourceHolder.putDataSource((String)DynamicDataSource.getInstance().getDefaultDataSourceKey());
        return this.iusPubDao.edit(params);
    }

    public boolean saveInvoke(String datasource, String sql) throws BusinessException {
        this.log.info("\u901a\u8fc7\u6570\u636e\u6e90[" + datasource + "]\u6267\u884c\u81ea\u5b9a\u4e49SQL\uff1a" + sql);
        try {
            Connection con = this.getDataSource(datasource, "exe");
            return ConnctionData.getInstance().execute(con, sql);
        }
        catch (SQLException e) {
            this.log.error("\u6267\u884csql=" + sql + ";\u6267\u884c\u5931\u8d25:" + e.getMessage());
            return false;
        }
    }

    public boolean saveBatchInvoke(String datasource, String sql) throws BusinessException {
        this.log.info("\u901a\u8fc7\u6570\u636e\u6e90[" + datasource + "]\u6267\u884c\u81ea\u5b9a\u4e49SQL\uff1a" + sql);
        try {
            Connection con = this.getDataSource(datasource, "exe");
            List<String> sqls = Arrays.asList(sql.split(";"));
            return ConnctionData.getInstance().execute(con, sqls);
        }
        catch (SQLException e) {
            this.log.error("\u6267\u884csql=" + sql + ";\u6267\u884c\u5931\u8d25:" + e.getMessage());
            return false;
        }
    }

    public ResultEntity saveInvoke(String datasource, String saveObjName, Map<String, Object> paramsMap) throws BusinessException {
        paramsMap.put("datasource", datasource);
        paramsMap.put("modelTypes", saveObjName);
        paramsMap.put("resultType", "processSql");
        if (StrUtil.isNull((String)String.valueOf(paramsMap.get("sqlKeyId")))) {
            paramsMap.put("sqlKeyId", "sqlKeyId");
        }
        paramsMap.put("sysPass", ConfigUtil.getInstance().interfacePass());
        this.log.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + paramsMap);
        InterfaceRegister register = new InterfaceRegister();
        register.setAddress("127.0.0.1");
        register.setCallType("socket");
        return LoadRpcService.service().doServiceClient(this.getBeanId(datasource), "dymicSql", paramsMap, register);
    }

    protected void writeLogs(Map<String, String> logParams, Map<String, String> logDetails, String infoId, String objName) {
        Object objPlugin = SpringContextLoader.getBean((String)"customLogsPlugin");
        if (objPlugin == null) {
            objPlugin = this.defalutLogsPlugin;
        }
        String dataDimension = logParams.get("logDataDimension");
        String dataType = logParams.get("logDataType");
        String operateType = logParams.get("logOperateType");
        String logIp = logParams.get("logReqIp");
        String loguser = logParams.get("logOperatorUser");
        ((LogsPlugin)objPlugin).writeLogs(logIp, loguser, objName, dataDimension, dataType, operateType, infoId, "", logDetails);
    }

    public void init() {
        instance = this;
    }

    public static IusPluginUtil getInstance() {
        return instance;
    }

    public void setIusProxyManager(ProxyManager iusProxyManager) {
        this.iusProxyManager = iusProxyManager;
    }

    public void setIusPubDao(IDao iusPubDao) {
        this.iusPubDao = iusPubDao;
    }

    public IDao getIusPubDao() {
        return this.iusPubDao;
    }

    public void setDefalutLogsPlugin(LogsPlugin defalutLogsPlugin) {
        this.defalutLogsPlugin = defalutLogsPlugin;
    }

    private String getBeanId(String datasourceName) {
        String beanId = "iusService";
        if (StrUtil.isNotNull((String)datasourceName)) {
            if ("cms".equals(datasourceName)) {
                beanId = "websiteService";
            } else {
                beanId = datasourceName + "Service";
                if (!this.isExites(beanId)) {
                    beanId = "iusService";
                }
            }
        }
        return beanId;
    }

    private boolean isExites(String beanId) {
        if (StrUtil.isNull((String)beanId)) {
            return false;
        }
        String cacheKey = "interfaceRegister_" + beanId;
        return LoadCacheFactory.getInstance().getCacheManager("").checkCacheObject(cacheKey);
    }

    private Connection getDataSource(String datasource, String exeType) throws SQLException {
        DruidDataSource dbDao = null;
        if ("select".equals(exeType) && StrUtil.isNotNull((String)(datasource = StrUtil.doNull((String)datasource, (String)DynamicDataSource.getInstance().getDefaultDataSourceKey()))) && !datasource.startsWith("slave") && LoadCacheFactory.getInstance().getCacheManager("").checkCacheObject("rpc_datasource_slave" + datasource)) {
            datasource = "slave" + datasource;
        }
        if (!DynamicDataSource.getInstance().checkDataSource(datasource)) {
            Object obj = LoadCacheFactory.getInstance().getCacheManager("").getCacheObjectByKey("rpc_datasource_" + datasource);
            if (null == obj) {
                throw new BusinessException("\u83b7\u53d6\u6570\u636e\u6e90[" + datasource + "]\u5931\u8d25\uff01");
            }
            RpcDatasource rds = (RpcDatasource)obj;
            if (!DynamicDataSource.getInstance().addDataSource(rds.getDataName(), rds.getDriverClassName(), rds.getJdbcUrl(), rds.getJdbcUsername(), rds.getJdbcPassword())) {
                throw new BusinessException("\u8fde\u63a5\u6570\u636e\u6e90[" + datasource + "]\u5931\u8d25\uff01");
            }
        }
        dbDao = DynamicDataSource.getInstance().getDataSource(datasource);
        DruidPooledConnection con = dbDao.getConnection();
        return con;
    }
}

