/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.listener;

import com.apache.cache.service.CacheManager;
import com.apache.cache.service.impl.LoadCacheFactory;
import com.apache.cache.service.impl.redis.JedisSsoUtil;
import com.apache.database.constant.SpringContextLoader;
import com.apache.database.db.IDao;
import com.apache.database.model.MethodParam;
import com.apache.tools.StrUtil;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IusParamsListener
implements ServletContextListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        new Thread(new SetIusParamsCache()).start();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    class SetIusParamsCache
    implements Runnable {
        private IDao iusPubDao;
        private CacheManager cacheManager;

        SetIusParamsCache() {
        }

        @Override
        public void run() {
            boolean mark = true;
            do {
                try {
                    if (null != SpringContextLoader.getContext()) {
                        mark = false;
                        this.setIusParamsCache();
                        continue;
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Exception e) {
                    IusParamsListener.this.log.error("\u521d\u59cb\u5316IUS\u53c2\u6570\u5931\u8d25\uff1a", (Throwable)e);
                    System.exit(0);
                }
            } while (mark);
        }

        private void setIusParamsCache() {
            IusParamsListener.this.log.info("IUS\u63a5\u53e3\u53c2\u6570-\u6570\u636e\u52a0\u8f7d\u7f13\u5b58\uff01");
            long startTime = System.currentTimeMillis();
            String execSql = "select * from sys_param_manager";
            if (StrUtil.isNotNull((String)execSql)) {
                MethodParam params = new MethodParam("ByObjInfo", "", "", "com.apache.ius.sql.DymicMapper");
                params.setParams("dyncSql", execSql);
                List list = this.getIusManager().select(params);
                if (!StrUtil.isEmpty((List)list)) {
                    int count = list.size();
                    for (int i = 0; i < count; ++i) {
                        Map map = (Map)list.get(i);
                        String key = map.get("formName") + "_" + map.get("pageName");
                        this.setIusParamCache(key, map);
                    }
                    IusParamsListener.this.log.info("IUS\u63a5\u53e3\u53c2\u6570-\u5171\u8ba1\u7f13\u5b58\u52a0\u8f7d(" + count + "\u6761)\uff0c\u6267\u884c\u65f6\u95f4=" + (System.currentTimeMillis() - startTime) + "ms");
                } else {
                    IusParamsListener.this.log.error("\u6ca1\u6709\u83b7\u53d6\u5230ParamManager\u4fe1\u606f");
                }
            }
        }

        private void setIusParamCache(String key, Map<String, String> params) {
            if (JedisSsoUtil.getInstance().isRedisCache()) {
                JedisSsoUtil.getInstance().setIusparamcache(key, params);
            } else {
                this.getCache().createCacheObject(key, params);
            }
        }

        private CacheManager getCache() {
            if (null == this.cacheManager) {
                this.cacheManager = LoadCacheFactory.getInstance().getCacheManager("iusparamcache");
            }
            return this.cacheManager;
        }

        private IDao getIusManager() {
            if (null == this.iusPubDao) {
                this.iusPubDao = (IDao)SpringContextLoader.getBean((String)"iusPubDao");
            }
            return this.iusPubDao;
        }
    }
}

