/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.impl;

import com.apache.api.manager.PluginConnector;
import com.apache.api.vo.ParamsVo;
import com.apache.api.vo.ResultEntity;
import com.apache.cache.util.Validator;
import com.apache.database.constant.SpringContextLoader;
import com.apache.database.db.IDao;
import com.apache.database.model.MethodParam;
import com.apache.exception.BusinessException;
import com.apache.ius.CustomMethodFactory;
import com.apache.ius.FelToolsUtil;
import com.apache.ius.IusSqlTools;
import com.apache.ius.impl.CachePluginImpl;
import com.apache.ius.impl.MaxContentPorxyPluginImpl;
import com.apache.ius.plugin.CustomMethodPlugin;
import com.apache.ius.plugin.IusSqlPorxyPlugin;
import com.apache.tools.StrUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class PlateTransactionPluginImpl
implements PluginConnector {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private IDao iusPubDao;
    private IusSqlPorxyPlugin iusSqlPorxyPlugin;
    @Autowired
    @Qualifier(value="iusCachePlugin")
    private CachePluginImpl iusCahcePlugin;
    private String jdbcType = "";

    public Object execute(ParamsVo param) throws Exception {
        String key = String.valueOf(param.getParams("sqlKeyId"));
        MethodParam params = new MethodParam(key, "", "", "com.apache.ius.sql.DymicMapper");
        ResultEntity entity = new ResultEntity();
        entity.setResult("true");
        this.log.info("parameter datasource [" + param.getParamsToStr("datasource") + "]");
        String resultType = String.valueOf(param.getParams("resultType"));
        try {
            String cacheKey;
            if ("processSql".equalsIgnoreCase(resultType)) {
                this.processSql(entity, params, param);
                if ("T".equals(param.getParamsToStr("logIfLogOpen"))) {
                    IusSqlTools.getInstance().writeOperateLogs(param);
                }
            } else if ("objInfo".equals(resultType)) {
                this.selectObjInfo(entity, params, param);
            }
            if (Validator.isNotNull((String)(cacheKey = param.getParamsToStr("resultSetCacheKey")))) {
                this.iusCahcePlugin.writeCahce(param, entity);
            }
        }
        catch (BusinessException e) {
            param.setParams("businessException", (Object)e.getMessage());
            entity.setMessage(e.getMessage());
            entity.setEntity((Object)"F");
        }
        catch (Exception e) {
            param.setParams("businessException", (Object)e.getMessage());
            entity.setMessage("\u7cfb\u7edf\u8fd0\u884c\u5f02\u5e38");
            this.log.error("\u6267\u884c\u5f02\u5e38", (Throwable)e);
            entity.setEntity((Object)"F");
        }
        return entity;
    }

    private void processSql(ResultEntity entity, MethodParam params, ParamsVo paramVo) {
        ResultEntity rsEntity;
        String execSql = "";
        String cateNo = String.valueOf(paramVo.getParams("cateNo"));
        String auditType = String.valueOf(paramVo.getParams("auditType"));
        if (Validator.isNotNull((String)cateNo) || Validator.isNotNull((String)auditType)) {
            FelToolsUtil.getInstance().evl(paramVo);
        }
        if (!Validator.isEmpty((Object)(rsEntity = this.beforeMenthod(entity, paramVo)))) {
            entity = rsEntity;
            return;
        }
        execSql = IusSqlTools.getInstance().cteageNativeSql(paramVo);
        String pluginSql = String.valueOf(paramVo.getParams("plugin_execSql"));
        if (Validator.isNotNull((String)pluginSql)) {
            execSql = execSql + pluginSql;
        }
        if (Validator.isNotNull((String)execSql)) {
            String modelTypes = String.valueOf(paramVo.getParams("modelTypes"));
            String[] str = modelTypes.split(",");
            for (int i = 0; i < str.length; ++i) {
                String sql;
                if (!str[i].startsWith("d_") || !StrUtil.isNotNull((String)(sql = String.valueOf(paramVo.getParams(str[i].substring(2) + "_sql"))))) continue;
                params.setKey("ByObjInfo");
                params.setParams("dyncSql", sql);
                List list = this.iusPubDao.select(params);
                if (null == list || list.size() <= 0) continue;
                this.delContentInfo(list);
            }
            params.setParams("dyncSql", "");
            params.setKey("ByDymicSql");
            params.setParams("execSql", execSql.replace("\\", "\\\\"));
            boolean mark = this.iusPubDao.edit(params);
            entity.setEntity(paramVo.getParams("resultIds"));
            entity.setResult("T");
            entity.setMessage("\u64cd\u4f5c\u6210\u529f");
        } else {
            entity.setMessage("\u7f3a\u5c11\u65b9\u6cd5\u6267\u884c\u53c2\u6570");
        }
    }

    private void selectObjInfo(ResultEntity entity, MethodParam params, ParamsVo paramVo) {
        ResultEntity rsEntity = this.beforeMenthod(entity, paramVo);
        if (!Validator.isEmpty((Object)rsEntity)) {
            entity = rsEntity;
            return;
        }
        params.setParams("datasource", paramVo.getParamsToStr("datasource"));
        String execSql = IusSqlTools.getInstance().dymicNativeSql(paramVo);
        execSql = StrUtil.doNull((String)execSql, (String)paramVo.getParamsToStr("customizeSql"));
        if (StrUtil.isNotNull((String)paramVo.getParamsToStr("customizeSql"))) {
            this.log.info("customizeSql=" + paramVo.getParamsToStr("customizeSql"));
        }
        if (Validator.isNotNull((String)execSql)) {
            String modelTypes = String.valueOf(paramVo.getParams("modelTypes"));
            String[] str = modelTypes.split(",");
            if (modelTypes.startsWith("s_") || modelTypes.startsWith("sl_") || modelTypes.startsWith("sr_") || modelTypes.startsWith("si_") || execSql.startsWith("select ")) {
                params.setKey(paramVo.getParams().containsKey("linkedDataColumn") ? "ByLinkedObjInfo" : "ByObjInfo");
                params.setParams("dyncSql", execSql.replace("\\", "\\\\"));
                Object obj = null;
                params.setResultCache(false);
                String rows = String.valueOf(paramVo.getParams("rows"));
                if (Validator.isNull((String)rows) || "all".equals(rows)) {
                    String val = String.valueOf(paramVo.getParams("resultObjType"));
                    if ("obj".equals(val)) {
                        List list = this.iusPubDao.select(params);
                        Object object = obj = Validator.isEmpty((List)list) ? null : (Object)list.get(0);
                        if (null == obj) {
                            entity.setMessage("\u672a\u83b7\u53d6\u5230\u6570\u636e");
                            return;
                        }
                        if (str.length == 1) {
                            Map result = (Map)obj;
                            String objName = "";
                            if ("T".equalsIgnoreCase(String.valueOf(paramVo.getParams("_resultType")))) {
                                objName = modelTypes.substring(2) + ".";
                                Map nn = (Map)result.get(modelTypes.substring(2));
                                if (nn.containsKey("fsId")) {
                                    this.getBulidContent("", nn);
                                }
                            } else if (result.containsKey("fsId")) {
                                obj = this.getBulidContent(objName, result);
                            }
                        } else {
                            for (int i = 0; i < str.length; ++i) {
                                Map result = (Map)obj;
                                String objName = str[i].substring(2) + ".";
                                if (!result.containsKey(objName + "fsId")) continue;
                                obj = this.getBulidContent(objName, result);
                            }
                        }
                    } else if ("count".equals(val)) {
                        long count = this.iusPubDao.count(params);
                        entity.setEntity((Object)count);
                        entity.setResult("\u67e5\u8be2\u6210\u529f");
                        obj = count;
                    } else {
                        obj = this.iusPubDao.select(params);
                    }
                } else {
                    params.setPageIndex(Integer.valueOf(StrUtil.doNull((String)String.valueOf(paramVo.getParams("page")), (String)"1")).intValue());
                    params.setPageSize(Integer.valueOf(rows).intValue());
                    obj = this.iusPubDao.pageSelect(params);
                }
                if (!Validator.isEmpty((Object)obj)) {
                    entity.setEntity(obj);
                    entity.setResult("\u67e5\u8be2\u6210\u529f");
                } else {
                    entity.setMessage("\u6267\u884c\u5931\u8d25");
                }
            } else {
                for (int i = 0; i < str.length; ++i) {
                    String sql;
                    if (!str[i].startsWith("d_") || !StrUtil.isNotNull((String)(sql = String.valueOf(paramVo.getParams(str[i].substring(2) + "_sql"))))) continue;
                    params.setKey("ByObjInfo");
                    params.setParams("dyncSql", sql);
                    List list = this.iusPubDao.select(params);
                    if (null == list || list.size() <= 0) continue;
                    this.delContentInfo(list);
                }
                params.setParams("dyncSql", "");
                params.setKey("ByDymicSql");
                params.setParams("execSql", execSql);
                boolean resMark = this.iusPubDao.edit(params);
                entity.setEntity(null == paramVo.getParams("resultIds") ? Boolean.valueOf(resMark) : paramVo.getParams("resultIds"));
                entity.setResult("T");
            }
        } else {
            entity.setMessage("\u7f3a\u5c11\u65b9\u6cd5\u6267\u884c\u53c2\u6570");
        }
    }

    private ResultEntity beforeMenthod(ResultEntity entity, ParamsVo paramVo) {
        this.exeCustomPlugin(paramVo, "befor");
        if (Validator.isNotNull((String)String.valueOf(paramVo.getParams("businessSuccese")))) {
            entity.setResult("T");
            entity.setMessage(String.valueOf(paramVo.getParams("businessSuccese")));
            if (!Validator.isEmpty((Object)paramVo.getParams("businessResultEntity"))) {
                entity.setEntity(paramVo.getParams("businessResultEntity"));
            }
            return entity;
        }
        return null;
    }

    private Object getBulidContent(String objName, Map result) {
        String content;
        String key = String.valueOf(result.get(objName + "fsId"));
        if (StrUtil.isNull((String)key)) {
            return "";
        }
        MaxContentPorxyPluginImpl plugin = MaxContentPorxyPluginImpl.getInstance();
        String dbType = "";
        if (!key.startsWith("cache_")) {
            dbType = "file";
        }
        if (StrUtil.isNotNull((String)(content = String.valueOf(plugin.doContent(key, dbType))))) {
            JSONObject jb;
            JSONObject map = jb = JSONObject.fromObject((Object)content);
            for (String k : map.keySet()) {
                if (result.containsKey(objName + k)) continue;
                result.put(objName + k, map.get(k));
            }
        }
        return result;
    }

    private void delContentInfo(List list) {
        MaxContentPorxyPluginImpl plugin = MaxContentPorxyPluginImpl.getInstance();
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            String key = (String)map.get("fsId");
            if (StrUtil.isNull((String)key)) continue;
            String dbType = "";
            if (!key.startsWith("cache_")) {
                dbType = "file";
            }
            plugin.delContent(key, dbType);
        }
    }

    private void exeCustomPlugin(ParamsVo vo, String type) {
        String beforMethodKey;
        Map map = new HashMap();
        String keys = String.valueOf(vo.getParams("sqlKeyId"));
        if (Validator.isNotNull((String)keys)) {
            beforMethodKey = String.valueOf(vo.getParams("beforMethodKey"));
            if (Validator.isNull((String)beforMethodKey)) {
                return;
            }
            vo.setMethodKey("beforMethodKey");
            map = (Map)this.getPlugin().doInvoke(vo);
            vo.setParams("beforMethodKey", (Object)"");
            vo.setParams("sqlKeyId", (Object)"");
        } else if ("befor".equals(type)) {
            beforMethodKey = String.valueOf(vo.getParams("beforMethodKey"));
            if (Validator.isNull((String)beforMethodKey)) {
                return;
            }
            vo.setMethodKey("beforMethodKey");
            CustomMethodPlugin befor = CustomMethodFactory.getInstance().getPluginByKey(beforMethodKey);
            if (!Validator.isEmpty((Object)befor)) {
                map = (Map)befor.beforeInvoke(vo.getParams());
                vo.setParams("beforMethodKey", (Object)"");
            }
        }
        if (!Validator.isEmpty(map)) {
            for (String key : map.keySet()) {
                vo.setParams(key, map.get(key));
            }
        }
    }

    public void setIusPubDao(IDao iusPubDao) {
        this.iusPubDao = iusPubDao;
    }

    private IusSqlPorxyPlugin getPlugin() {
        if (null == this.iusSqlPorxyPlugin) {
            this.iusSqlPorxyPlugin = (IusSqlPorxyPlugin)SpringContextLoader.getBean((String)"iusSqlPorxyPlugin");
        }
        return this.iusSqlPorxyPlugin;
    }
}

