/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.function;

import com.apache.cache.util.Validator;
import com.apache.tools.DateUtils;
import com.apache.tools.StrUtil;
import com.apache.workday.WorkdayUtils;
import com.greenpineyu.fel.function.CommonFunction;
import com.greenpineyu.fel.function.Function;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class FelFunction {
    private static FelFunction instance;

    private FelFunction() {
    }

    public static FelFunction getInstance() {
        if (null == instance) {
            instance = new FelFunction();
        }
        return instance;
    }

    public Function dateCalculate() {
        CommonFunction fun = new CommonFunction(){

            public String getName() {
                return "dateCalculate";
            }

            public String call(Object[] args) {
                String result = FelFunction.this.dateScheduling(String.valueOf(args[0]), String.valueOf(args[1]));
                return result;
            }
        };
        return fun;
    }

    public Function dateValidate() {
        CommonFunction fun = new CommonFunction(){

            public String getName() {
                return "dateValidate";
            }

            public String call(Object[] args) {
                String result = FelFunction.this.dateScheduling(String.valueOf(args[0]), String.valueOf(args[1]));
                return result;
            }
        };
        return fun;
    }

    public String dateScheduling(String ... args) {
        String result = "";
        try {
            switch (DateEnum.getName(String.valueOf(args[0]))) {
                case SumWorkDate: {
                    result = this.sumDate(String.valueOf(args[1]), true);
                    break;
                }
                case SumDate: {
                    result = this.sumDate(String.valueOf(args[1]), false);
                    break;
                }
                case DateCompare: {
                    result = this.dateCompare(String.valueOf(args[1]));
                    break;
                }
                case SetNowDate: {
                    result = DateUtils.Now.fmt_yyyyMMdd();
                    break;
                }
                case SetNowTime: {
                    result = DateUtils.Now.fmt_HHmmss();
                    break;
                }
                case SetNowDateTime: {
                    result = DateUtils.Now.fmt_yyyyMMdd_HHmmss();
                    break;
                }
                case SetLongTime: {
                    result = DateUtils.strToLong((String)DateUtils.Now.fmt_yyyyMMdd_HHmmss(), (DateUtils.FmtStr)DateUtils.FmtStr.yyyyMMdd_HHmmss) + "";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return result;
    }

    private String dateCompare(String str) throws ParseException {
        String msg = "";
        if (Validator.isNotNull((String)str)) {
            String[] strs = new String[2];
            String eq = "";
            if (str.indexOf(">=") != -1) {
                strs = str.split(">=");
                eq = ">=";
            } else if (str.indexOf("<=") != -1) {
                strs = str.split("<=");
                eq = "<=";
            } else if (str.indexOf(">") != -1) {
                strs = str.split(">");
                eq = ">";
            } else if (str.indexOf("<") != -1) {
                strs = str.split("<");
                eq = "<";
            } else if (str.indexOf("=") != -1) {
                strs = str.split("=");
                eq = "==";
            }
            long eTime = DateUtils.strToLong((String)strs[0], (DateUtils.FmtStr)DateUtils.FmtStr.yyyyMMdd);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date now = sdf.parse(DateUtils.Now.fmt_yyyyMMdd());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(now);
            calendar.add(2, Integer.valueOf(strs[1]));
            long cTime = DateUtils.strToLong((String)DateUtils.format((Date)calendar.getTime(), (String)"yyyy-MM-dd"), (DateUtils.FmtStr)DateUtils.FmtStr.yyyyMMdd);
            msg = eTime + eq + cTime;
        }
        return msg;
    }

    private String sumDate(String arguments, boolean isWorkDate) throws NumberFormatException, Exception {
        String msg = "";
        if (Validator.isNotNull((String)arguments)) {
            String[] strs = arguments.split("\\+");
            if (Validator.isNull((String)strs[0])) {
                strs[0] = DateUtils.Now.fmt_yyyyMMdd();
            }
            if (strs[0].length() > 10) {
                strs[0] = strs[0].substring(0, 11);
            }
            if (isWorkDate) {
                msg = WorkdayUtils.getInstance().afterWorkday(strs[0], Integer.valueOf(strs[1]).intValue());
                msg = DateUtils.format((Date)DateUtils.parse((String)msg, (String)"yyyyMMdd"), (String)"yyyy-MM-dd");
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date now = sdf.parse(strs[0]);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(now);
                calendar.add(5, Integer.valueOf(strs[1]));
                msg = DateUtils.format((Date)calendar.getTime(), (String)"yyyy-MM-dd");
            }
        }
        return msg;
    }

    public static void main(String[] args) {
        String result = FelFunction.getInstance().dateScheduling("certEndTime", "2015-11-21>=23");
        System.out.println(result);
        String sql = "sumDate:2015-11-21+23";
        String[] str = sql.split(":");
        result = FelFunction.getInstance().dateScheduling(str[0], "2015-11-21+23");
        System.out.println(result);
    }

    private static enum DateEnum {
        Default(""),
        SumWorkDate("sumWorkDate"),
        SumDate("sumDate"),
        DateCompare("dateCompare"),
        SetNowDate("setNowDate"),
        SetNowTime("setNowTime"),
        SetNowDateTime("setNowDateTime"),
        SetLongTime("setLongTime");

        private String name;

        private DateEnum(String name) {
            this.name = name;
        }

        public static DateEnum getName(String name) {
            if (StrUtil.isNull((String)name)) {
                return Default;
            }
            for (DateEnum c : DateEnum.values()) {
                if (!c.name.equals(name)) continue;
                return c;
            }
            return Default;
        }
    }
}

