/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.controller;

import com.apache.api.vo.AouthSecurity;
import com.apache.cache.util.Validator;
import com.apache.info.util.MessageUtil;
import com.apache.ius.controller.BaseAction;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SendPageAction
extends BaseAction {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private String whiteUrl = "/web/user,/admin,";
    private String customLogin = "";

    @AouthSecurity
    @RequestMapping(value={"/sendPage/**"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView sendPage(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String requestURI = request.getRequestURI();
        this.log.info("requrl -->" + requestURI);
        requestURI = requestURI.replaceAll(request.getContextPath() + "/sendPage/", "");
        String pageUrl = "/WEB-INF/pages/" + requestURI;
        if ("index-ius".equals(requestURI)) {
            pageUrl = requestURI;
        }
        this.log.info("pageUrl-->" + pageUrl);
        Map<String, String> parmMap = this.getParameterMap(request);
        Map defMap = super.getDefaultDataMap(request);
        ModelAndView model = new ModelAndView();
        model.addAllObjects(parmMap);
        model.addAllObjects(defMap);
        model.setViewName(pageUrl);
        return model;
    }

    @RequestMapping(value={"/sendPage/token"}, method={RequestMethod.GET})
    public void token(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uuid = this.setToken(request);
        this.outputJson(uuid, response, request.getParameter("callback"));
    }

    private String setToken(HttpServletRequest request) {
        if (Validator.isNotNull((String)request.getParameter("token"))) {
            HttpSession session = request.getSession(true);
            String uuid = UUID.randomUUID().toString();
            if (null != session) {
                session.setAttribute("formToken", (Object)uuid);
            }
            return uuid;
        }
        return "";
    }

    @RequestMapping(value={"/errorPage"}, method={RequestMethod.GET})
    public String errorPage(HttpServletRequest request, String message) {
        request.setAttribute("ctx", (Object)request.getContextPath());
        if (Validator.isNotNull((String)request.getParameter("Errorcode"))) {
            String error = request.getParameter("Errorcode");
            String[] params = new String[]{};
            message = "invalid-00000001".equals(error) ? MessageUtil.getMessage((String)"invalid-001", (String[])params, (String)"\u4ea7\u54c1\u8bb8\u53ef\u5df2\u8fc7\u671f\uff0c\u8bf7\u8d2d\u4e70license\uff01") : ("invalid-00000002".equals(error) ? MessageUtil.getMessage((String)"invalid-002", (String[])params, (String)"\u65e0\u6548\u7684license\u8bb8\u53ef\uff01") : ("invalid-00000003".equals(error) ? MessageUtil.getMessage((String)"invalid-004", (String[])params, (String)"\u60a8\u6ca1\u6709\u5f53\u524d\u8bf7\u6c42\u5730\u5740\u8bbf\u95ee\u6743\u9650,\u6388\u6743\u540e\u518d\u8fdb\u884c\u64cd\u4f5c!") : MessageUtil.getMessage((String)"invalid-003", (String[])params, (String)"\u4ea7\u54c1\u8fd8\u6ca1\u6709\u88ab\u6388\u6743\u6216License \u8d85\u8fc7\u6709\u6548\u671f\uff01")));
        }
        request.setAttribute("messageError", (Object)message);
        return "/WEB-INF/pages/plateform/error/invalid";
    }

    @ResponseBody
    @RequestMapping(value={"/error"}, method={RequestMethod.GET, RequestMethod.POST})
    public Object error(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("errorCode", "100");
        error.put("messageError", "\u5185\u90e8\u670d\u52a1\u5668\u9519\u8bef,\u6b63\u5728\u5904\u7406");
        Integer status = (Integer)request.getAttribute("javax.servlet.error.status_code");
        if (status == 404) {
            error.put("messageError", "\u8bbf\u95ee\u5730\u5740\u4e0d\u5b58\u5728");
        }
        return "/WEB-INF/pages/plateform/error/invalid";
    }
}

