/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.controller;

import com.apache.api.api.ApiService;
import com.apache.api.vo.AouthSecurity;
import com.apache.api.vo.ParamsVo;
import com.apache.api.vo.ResultEntity;
import com.apache.cache.service.impl.LoadCacheFactory;
import com.apache.cache.service.impl.redis.RedisCoreFactory;
import com.apache.cache.util.Validator;
import com.apache.database.constant.SpringContextLoader;
import com.apache.database.constant.SystemTools;
import com.apache.exception.BusinessException;
import com.apache.ius.able.CacheHelper;
import com.apache.ius.common.CommonUtils;
import com.apache.ius.controller.BaseAction;
import com.apache.ius.plugin.InitCacheDataUtil;
import com.apache.ius.plugin.IusPluginUtil;
import com.apache.rpc.common.LoadRpcService;
import com.apache.rpc.entity.InterfaceRegister;
import com.apache.rpc.entity.RpcDatasource;
import com.apache.tools.DataMap;
import com.apache.tools.StrUtil;
import com.apache.uct.common.ToolsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/iusCache"})
public class IusCacheAction
extends BaseAction {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    @Qualifier(value="infoService")
    private ApiService infoService;

    @AouthSecurity
    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    @ResponseBody
    public Object view(HttpServletRequest request) throws IOException, ServletException {
        Map<String, String> paramMap = this.getParameterMap(request);
        this.log.info("view cache request paramMap->" + paramMap);
        String cacheSpaceName = StrUtil.doNull((String)paramMap.get("cacheSpaceName"), (String)"");
        String cachekey = paramMap.get("cachekey");
        HashMap<String, String> returnData = new HashMap<String, String>();
        if (Validator.isNull((String)cachekey)) {
            returnData.put("flag", "F");
            returnData.put("msg", "\u7f3a\u5c11\u7f13\u5b58\u53c2\u6570");
            return returnData;
        }
        Object obj = LoadCacheFactory.getInstance().getCacheManager(cacheSpaceName).getCacheObjectByKey(cachekey);
        String resultStr = "\u6682\u65e0\u6570\u636e";
        if (obj != null) {
            resultStr = obj instanceof String ? obj.toString() : (obj instanceof List ? JSONArray.fromObject((Object)obj).toString() : JSONObject.fromObject((Object)obj).toString());
        }
        this.log.info("view cache->" + resultStr);
        returnData.put("flag", "T");
        returnData.put("msg", resultStr);
        return returnData;
    }

    @AouthSecurity
    @RequestMapping(value={"/init"}, method={RequestMethod.POST})
    @ResponseBody
    public Object init(HttpServletRequest request) throws IOException, ServletException {
        HashMap<String, String> returnData = new HashMap<String, String>();
        returnData.put("flag", "F");
        Map<String, String> paramMap = this.getParameterMap(request);
        this.log.info("init cache request paramMap->" + paramMap);
        String formName = paramMap.get("formName");
        String pageName = paramMap.get("pageName");
        if (Validator.isNull((String)formName) || Validator.isNull((String)pageName)) {
            returnData.put("msg", "\u7f3a\u5c11\u7f13\u5b58\u53c2\u6570");
            return returnData;
        }
        String cache_key = formName + "_" + pageName;
        Object cache_result = LoadCacheFactory.getInstance().getCacheManager("iusparamcache").getCacheObjectByKey(cache_key);
        if (Validator.isEmpty((Object)cache_result)) {
            returnData.put("msg", "\u672a\u627e\u5230\u63a5\u53e3\u53c2\u6570\u914d\u7f6e\uff1a" + cache_key);
            return returnData;
        }
        Map dMap = (Map)cache_result;
        String searchObjName = String.valueOf(dMap.get("modelTypes"));
        String datasource = String.valueOf(dMap.get("sysName"));
        String sysEname = StrUtil.doNull((String)CommonUtils.getSysEname(), (String)datasource);
        String tableObjName = searchObjName.split(",")[0].split("_")[1];
        if ("sortInfo".equals(tableObjName)) {
            sysEname = paramMap.get("sortInfo.w_sysName");
            ParamsVo psvo = new ParamsVo();
            psvo.setMethodKey("metadataAction");
            psvo.setParams("method", (Object)"initCache");
            psvo.setParams("sysPass", (Object)paramMap.get("sysPass"));
            psvo.setParams("sysName", (Object)sysEname);
            this.log.info("\u7cfb\u7edf[" + sysEname + "]\u4e0b\u6240\u6709[\u6570\u636e\u8868\u4fe1\u606f]\u5230\u7f13\u5b58\u4e2d...start !");
            this.doInfoService(psvo);
        } else {
            HashMap<String, Object> whereMap = new HashMap<String, Object>();
            whereMap.putAll(paramMap);
            whereMap.remove("page");
            whereMap.remove("row");
            whereMap.remove("pageName");
            whereMap.remove("formName");
            whereMap.remove("sysPass");
            whereMap.remove("Client-IP");
            for (String attrKey : paramMap.keySet()) {
                if (attrKey.indexOf(tableObjName) <= -1) continue;
                whereMap.put(attrKey, paramMap.get(attrKey));
            }
            ResultEntity resultEntity = IusPluginUtil.getInstance().select(datasource, "list", searchObjName, whereMap);
            if (Validator.isEmpty((Object)resultEntity.getEntity())) {
                returnData.put("msg", "\u672a\u627e\u5230\u63a5\u53e3\u6570\u636e\uff1a" + whereMap);
                return returnData;
            }
            List dataList = (List)resultEntity.getEntity();
            if ("sysInterfaceRegister".equals(tableObjName)) {
                String beanId = StrUtil.doNull((String)paramMap.get("sysInterfaceRegister.w_beanId"), (String)paramMap.get("sysInterfaceRegister.wi_beanId"));
                String cache_spaceName = "apachecache";
                this.log.info("\u7cfb\u7edf[" + beanId + "]\u4e0b\u6240\u6709[RPC\u63a5\u53e3]\u7f13\u5b58\u52a0\u8f7d...start !");
                if (StrUtil.isNull((String)beanId)) {
                    returnData.put("msg", "beanId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    return returnData;
                }
                String[] beanIdArray = new String[]{beanId};
                if (beanId.indexOf(",") > 0) {
                    beanIdArray = beanId.split(",");
                }
                for (String k : beanIdArray) {
                    this.initInterface(k, dataList, cache_spaceName);
                }
            } else if ("sysRpcDatasource".equals(tableObjName)) {
                String cache_spaceName = "apachecache";
                sysEname = paramMap.get("sysRpcDatasource.w_sysEname");
                this.log.info("\u7cfb\u7edf[" + sysEname + "]\u4e0b\u6240\u6709[\u6570\u636e\u6e90\u63a5\u53e3]\u7f13\u5b58\u52a0\u8f7d...start !");
                if (StrUtil.isNull((String)sysEname)) {
                    this.log.error("initDataSource.\u7f3a\u5c11\u53c2\u6570\uff1asysRpcDatasource.w_sysEname");
                } else {
                    this.initDataSource(sysEname, dataList, cache_spaceName);
                }
            } else if ("sysParamManager".equals(tableObjName)) {
                this.log.info("\u7cfb\u7edf[" + sysEname + "]\u4e0b\u6240\u6709[IUS\u63a5\u53e3\u53c2\u6570]\u7f13\u5b58\u52a0\u8f7d...start !");
                this.initIusParams(dataList);
            } else if ("sysPluginGroup".equals(tableObjName)) {
                this.log.info("\u7cfb\u7edf[" + sysEname + "]\u4e0b\u6240\u6709[\u63d2\u4ef6\u7ec4\u5408]\u7f13\u5b58\u52a0\u8f7d...start !");
                this.initSysPluginGroup(dataList);
            } else if ("sysPluginManager".equals(tableObjName)) {
                this.log.info("\u7cfb\u7edf[" + sysEname + "]\u4e0b\u6240\u6709[\u63d2\u4ef6\u5b9a\u4e49]\u7f13\u5b58\u52a0\u8f7d...start !");
                this.initSysPluginManager(dataList);
            } else if ("sysVersion".equals(tableObjName)) {
                this.log.info("\u7cfb\u7edf[" + sysEname + "]\u4e0b\u6240\u6709[\u63a5\u53e3\u7248\u672c]\u7f13\u5b58\u52a0\u8f7d...start !");
                this.initVersion(dataList);
            } else {
                String sysNameParamName = tableObjName + ".w_sysName";
                if (paramMap.containsKey(sysNameParamName)) {
                    sysEname = paramMap.get(sysNameParamName);
                } else {
                    if (StrUtil.isNull((String)sysEname) && paramMap.containsKey(tableObjName + ".sysName")) {
                        sysEname = paramMap.get(tableObjName + ".sysName");
                    }
                    if (StrUtil.isNull((String)sysEname) && paramMap.containsKey("sysName")) {
                        sysEname = paramMap.get("sysName");
                    }
                    sysEname = "";
                }
                try {
                    InitCacheDataUtil.getInstance().initDataToCacheOther(sysEname, tableObjName, dataList, paramMap);
                }
                catch (BusinessException be) {
                    returnData.put("flag", "F");
                    returnData.put("msg", be.getMessage());
                    return returnData;
                }
            }
        }
        returnData.put("flag", "T");
        returnData.put("msg", "\u7f13\u5b58\u66f4\u65b0\u6210\u529f");
        return returnData;
    }

    public void initIusParams(List dataList) {
        if (Validator.isEmpty((List)dataList)) {
            return;
        }
        if (!ToolsUtil.isEmpty((List)dataList)) {
            int count = dataList.size();
            for (int i = 0; i < dataList.size(); ++i) {
                Map map = (Map)dataList.get(i);
                String key = map.get("formName") + "_" + map.get("pageName");
                CacheHelper.getInstance().setIusParamCache(key, map);
            }
            this.log.info("\u521d\u59cb\u5316[IUS\u63a5\u53e3\u53c2\u6570][" + count + "]\u6761\u6570\u636e\u5230\u7f13\u5b58\u5b8c\u6210\uff01");
        }
    }

    private void initInterface(String beanId, List<DataMap> dataList, String cache_spaceName) {
        String cache_key = "interfaceRegister_" + beanId;
        this.log.info("\u63a5\u53e3\u6ce8\u518c\u4fe1\u606f\u52a0\u8f7dstart->" + cache_key);
        if (dataList.size() > 0) {
            ArrayList<InterfaceRegister> vos = (ArrayList<InterfaceRegister>)SystemTools.getInstance().getCache(cache_spaceName).getCacheObjectByKey(cache_key);
            if (Validator.isEmpty((List)vos)) {
                vos = new ArrayList<InterfaceRegister>();
            }
            for (int i = 0; i < dataList.size(); ++i) {
                DataMap dmObj = dataList.get(i);
                InterfaceRegister register = new InterfaceRegister();
                register.setRegisterId(String.valueOf(dmObj.get("registerId")));
                String data_beanId = String.valueOf(dmObj.get("beanId"));
                if (!data_beanId.equals(beanId)) continue;
                register.setBeanId(data_beanId);
                register.setBeanName(String.valueOf(dmObj.get("beanName")));
                register.setAddress(String.valueOf(dmObj.get("address")));
                register.setPort(String.valueOf(dmObj.get("port")));
                register.setMethodName(String.valueOf(dmObj.get("methodName")));
                register.setCallType(String.valueOf(dmObj.get("callType")));
                register.setFlag(String.valueOf(dmObj.get("flag")));
                register.setReserve1(String.valueOf(dmObj.get("reserve1")));
                register.setReserve2(String.valueOf(dmObj.get("reserve2")));
                register.setTimestampCreate(Long.valueOf(Long.parseLong(String.valueOf(dmObj.get("timestampCreate")))));
                register.setUserIdCreate(String.valueOf(dmObj.get("userIdCreate")));
                Iterator iterator = vos.iterator();
                while (iterator.hasNext()) {
                    InterfaceRegister ifr = (InterfaceRegister)iterator.next();
                    if (!ifr.getRegisterId().equals(register.getRegisterId())) continue;
                    iterator.remove();
                }
                vos.add(register);
                this.log.info(i + 1 + "\uff09\u63a5\u53e3\u6ce8\u518c\u5bf9\u8c61->" + JSONObject.fromObject((Object)register).toString());
            }
            SystemTools.getInstance().getCache(cache_spaceName).createCacheObject(cache_key, vos);
            this.log.info("\u521d\u59cb\u5316[\u63a5\u53e3\u6ce8\u518c\u4fe1\u606f][" + cache_key + "][" + vos.size() + "]\u6761\u6570\u636e\u5230\u7f13\u5b58\u5b8c\u6210\uff01");
        } else {
            SystemTools.getInstance().getCache(cache_spaceName).removeCacheObject(cache_key);
            this.log.info("\u6682\u65e0\u3010\u542f\u7528\u3011\u72b6\u6001\u7684\u63a5\u53e3\uff0c\u6545\u4e0d\u52a0\u8f7d\u7f13\u5b58\uff01");
        }
    }

    private void initDataSource(String sysEname, List<DataMap> dataList, String cache_spaceName) {
        if (dataList.size() > 0) {
            String cache_key = "rpc_datasource_" + sysEname;
            DataMap dmObj = dataList.get(0);
            RpcDatasource rds = new RpcDatasource();
            rds.setDataName(String.valueOf(dmObj.get("dataName")));
            rds.setDatabaseType(String.valueOf(dmObj.get("databaseType")));
            rds.setSysEname(String.valueOf(dmObj.get("sysEname")));
            rds.setDriverClassName(String.valueOf(dmObj.get("driverClassName")));
            rds.setJdbcPassword(String.valueOf(dmObj.get("jdbcPassword")));
            rds.setJdbcUrl(String.valueOf(dmObj.get("jdbcUrl")));
            rds.setJdbcUsername(String.valueOf(dmObj.get("jdbcUsername")));
            rds.setDatasource1(String.valueOf(dmObj.get("datasource1")));
            rds.setDatasource2(String.valueOf(dmObj.get("datasource2")));
            SystemTools.getInstance().getCache(cache_spaceName).createCacheObject(cache_key, (Object)rds);
            String cacheKeys = "rpc_datasource_keys";
            String cacheKeys_values = String.valueOf(SystemTools.getInstance().getCache(cache_spaceName).getCacheObjectByKey(cacheKeys));
            cacheKeys_values = Validator.getDefaultStr((String)cacheKeys_values, (String)"");
            if (cacheKeys_values.indexOf(sysEname) == -1) {
                if (!cacheKeys_values.endsWith(",")) {
                    cacheKeys_values = cacheKeys_values + ",";
                }
                cacheKeys_values = cacheKeys_values + sysEname;
                SystemTools.getInstance().getCache(cache_spaceName).createCacheObject(cacheKeys, (Object)cacheKeys_values);
                this.log.info("\u66f4\u65b0[\u6570\u636e\u6e90\u4fe1\u606f][" + cacheKeys + "->" + cacheKeys_values + "]\u5230\u7f13\u5b58");
            }
            this.log.info("\u66f4\u65b0[\u6570\u636e\u6e90\u4fe1\u606f][" + cache_key + "]\u5230\u7f13\u5b58\u5b8c\u6210\uff01");
        }
    }

    public void initSysPluginManager(List dataList) {
        String cache_spaceName = "pluginsCache";
        if (Validator.isEmpty((List)dataList)) {
            return;
        }
        if (!ToolsUtil.isEmpty((List)dataList)) {
            int count = dataList.size();
            for (int i = 0; i < dataList.size(); ++i) {
                Map map = (Map)dataList.get(i);
                String key = "group_" + String.valueOf(map.get("pluginShortName"));
                String value = String.valueOf(map.get("pluginFullName"));
                SystemTools.getInstance().getCache(cache_spaceName).createCacheObject(key, (Object)value);
                this.log.info(i + 1 + ".[" + key + "][" + value + "] " + String.valueOf(map.get("pluginRemark")));
            }
            this.log.info("\u66f4\u65b0[\u63d2\u4ef6][" + count + "]\u6761\u6570\u636e\u5230\u7f13\u5b58\u5b8c\u6210\uff01");
        }
    }

    public void initSysPluginGroup(List dataList) {
        String cache_spaceName = "pluginsCache";
        if (Validator.isEmpty((List)dataList)) {
            return;
        }
        if (!ToolsUtil.isEmpty((List)dataList)) {
            int count = dataList.size();
            for (int i = 0; i < dataList.size(); ++i) {
                Map map = (Map)dataList.get(i);
                String key = "plugin_" + String.valueOf(map.get("rulesCode"));
                String value = String.valueOf(map.get("rulesName"));
                SystemTools.getInstance().getCache(cache_spaceName).createCacheObject(key, (Object)value);
                this.log.info(i + 1 + ".[" + key + "][" + value + "] " + String.valueOf(map.get("rulesRemark")));
            }
            this.log.info("\u66f4\u65b0[\u63d2\u4ef6\u7ec4\u5408][" + count + "]\u6761\u6570\u636e\u5230\u7f13\u5b58\u5b8c\u6210\uff01");
        }
    }

    public void initVersion(List dataList) {
        String cache_spaceName = "versionCache";
        if (Validator.isEmpty((List)dataList)) {
            return;
        }
        if (!ToolsUtil.isEmpty((List)dataList)) {
            RedisCoreFactory.getInstance().getJedis().del(cache_spaceName);
            int count = dataList.size();
            for (int i = 0; i < dataList.size(); ++i) {
                Map map = (Map)dataList.get(i);
                String status = String.valueOf(map.get("status"));
                if ("1".equals(status)) {
                    SystemTools.getInstance().getCache(cache_spaceName).createCacheObject("current_version", (Object)String.valueOf(map.get("versionNo")));
                }
                String key = "version_" + String.valueOf(map.get("versionNo"));
                SystemTools.getInstance().getCache(cache_spaceName).createCacheObject(key, (Object)map);
                this.log.info(i + 1 + ".[" + key + "][" + map + "] ");
            }
            this.log.info("\u66f4\u65b0[\u63d2\u4ef6][" + count + "]\u6761\u6570\u636e\u5230\u7f13\u5b58\u5b8c\u6210\uff01");
        }
    }

    private Map<String, Object> getCacheObjTypeMap() {
        HashMap<String, Object> cacheObjTypeMap = new HashMap<String, Object>();
        JSONObject jsonObject_interFace = new JSONObject();
        jsonObject_interFace.put((Object)"cacheSpaceName", (Object)"apachecache");
        jsonObject_interFace.put((Object)"dataObj", (Object)new InterfaceRegister());
        cacheObjTypeMap.put("sysInterfaceRegister", jsonObject_interFace);
        JSONObject jsonObject_rpcDatasource = new JSONObject();
        jsonObject_rpcDatasource.put((Object)"cacheSpaceName", (Object)"apachecache");
        jsonObject_rpcDatasource.put((Object)"dataObj", (Object)new RpcDatasource());
        cacheObjTypeMap.put("sysRpcDatasource", jsonObject_rpcDatasource);
        JSONObject jsonObject_iusParam = new JSONObject();
        jsonObject_iusParam.put((Object)"cacheSpaceName", (Object)"iusparamcache");
        jsonObject_iusParam.put((Object)"dataObj", (Object)new DataMap());
        cacheObjTypeMap.put("sysParamManager", jsonObject_iusParam);
        return cacheObjTypeMap;
    }

    public void setInfoService(ApiService infoService) {
        this.infoService = infoService;
    }

    protected ResultEntity doInfoService(ParamsVo vo) {
        Object obj;
        if (null == this.infoService && (obj = SpringContextLoader.getBean((String)"infoService")) != null) {
            this.infoService = (ApiService)obj;
        }
        if (null == this.infoService) {
            return LoadRpcService.service().doService("infoService", vo.getMethodKey(), "xml", vo.getParams(), null);
        }
        return this.infoService.doService(vo);
    }
}

