/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.common.connectors.impl;

import com.apache.api.vo.ParamsVo;
import com.apache.ius.common.annotion.BeanFactory;
import com.apache.ius.common.connectors.InterceptorAdapter;
import com.apache.ius.common.connectors.impl.SetCreateInfoAdapterImpl;
import com.apache.ius.common.connectors.impl.SetReqParamAdapterImpl;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AdapterFactory {
    private static AdapterFactory instance;
    private Map<String, InterceptorAdapter> adapters = new HashMap<String, InterceptorAdapter>();

    private AdapterFactory() {
        this.adapters.put("createInfo", new SetCreateInfoAdapterImpl());
        this.adapters.put("setReqParam", new SetReqParamAdapterImpl());
    }

    public static AdapterFactory getInstance() {
        if (null == instance) {
            instance = new AdapterFactory();
        }
        return instance;
    }

    public InterceptorAdapter getAdapter(String key) {
        return (InterceptorAdapter)BeanFactory.getInstance().getBeans(key);
    }

    public Map getReqParamForBefor(String keys, Map param, HttpServletRequest request, HttpServletResponse response) {
        return this.getRequestParam("before", keys, param, request, response);
    }

    public Map getReqParamForAfter(String keys, Map param, HttpServletRequest request, HttpServletResponse response) {
        return this.getRequestParam("after", keys, param, request, response);
    }

    public Map getReqParam(String keys, Map param, HttpServletRequest request, HttpServletResponse response) {
        return this.getRequestParam("center", keys, param, request, response);
    }

    private Map getRequestParam(String methodType, String keys, Map param, HttpServletRequest request, HttpServletResponse response) {
        ParamsVo vo = new ParamsVo();
        try {
            String[] key = keys.split(",");
            vo.setParams(param);
            for (int i = 0; i < key.length; ++i) {
                if ("before".equals(methodType)) {
                    this.getAdapter(key[i]).beforPreHandle(request, response, vo);
                } else if ("center".equals(methodType)) {
                    this.getAdapter(key[i]).preHandle(request, response, vo);
                } else if ("after".equals(methodType)) {
                    this.getAdapter(key[i]).afterHandle(request, response, vo);
                }
                if (vo.getParams().containsKey("sys-cache-data")) break;
            }
            return vo.getParams();
        }
        catch (Exception e) {
            vo.setParams("execptionMsg", (Object)e.getMessage());
            return vo.getParams();
        }
    }
}

