/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.common.annotion;

import com.apache.ius.common.annotion.AnnotationUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PkgScanner {
    private String pkgName;
    private String pkgPath;
    private Class anClazz;
    private ClassLoader cl;

    public PkgScanner(String pkgName) {
        this.pkgName = pkgName;
        this.pkgPath = AnnotationUtil.packageToPath(pkgName);
        this.cl = Thread.currentThread().getContextClassLoader();
    }

    public PkgScanner(String pkgName, Class anClazz) {
        this(pkgName);
        this.anClazz = anClazz;
    }

    public List<String> scan() throws IOException {
        List<String> list = this.loadResource();
        if (null != this.anClazz) {
            list = this.filterComponents(list);
        }
        return list;
    }

    public void setPkgName(String pkgName) {
        this.pkgName = pkgName;
        this.pkgPath = AnnotationUtil.packageToPath(pkgName);
    }

    public void setAnnocation(Class an) {
        this.anClazz = an;
    }

    private List<String> loadResource() throws IOException {
        List<String> list = null;
        Enumeration<URL> urls = this.cl.getResources(this.pkgPath);
        while (urls.hasMoreElements()) {
            URL u = urls.nextElement();
            String type = u.getProtocol();
            String filePath = AnnotationUtil.getURLEncoderString(u.getPath().replace("%5c", "/"));
            switch (type) {
                case "jar": {
                    String path = AnnotationUtil.distillPathFromJarURL(filePath);
                    list = this.scanJar(path);
                    break;
                }
                case "file": {
                    list = this.scanFile(filePath, this.pkgName);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> scanJar(String path) throws IOException {
        JarFile jar = null;
        try {
            jar = new JarFile(path);
            ArrayList<String> classNameList = new ArrayList<String>();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(this.pkgPath) || !name.endsWith(".class")) continue;
                name = AnnotationUtil.trimSuffix(name);
                name = AnnotationUtil.pathToPackage(name);
                classNameList.add(name);
            }
            ArrayList<String> arrayList = classNameList;
            return arrayList;
        }
        finally {
            if (null != jar) {
                jar.close();
            }
        }
    }

    private List<String> scanFile(String path, String basePkg) {
        File f = new File(path);
        ArrayList<String> classNameList = new ArrayList<String>();
        File[] files = f.listFiles();
        if (null != files) {
            for (File file : files) {
                String className;
                if (file.isDirectory()) {
                    List<String> list = this.scanFile(file.getAbsolutePath(), AnnotationUtil.concat(basePkg, ".", file.getName()));
                    classNameList.addAll(list);
                    continue;
                }
                if (!file.getName().endsWith(".class") || -1 != (className = AnnotationUtil.trimSuffix(file.getName())).lastIndexOf("$")) continue;
                String result = AnnotationUtil.concat(basePkg, ".", className);
                classNameList.add(result);
            }
        }
        return classNameList;
    }

    private List<String> filterComponents(List<String> classList) {
        ArrayList<String> newList = new ArrayList<String>();
        if (null == classList) {
            return newList;
        }
        for (String name : classList) {
            try {
                Class<?> clazz = Class.forName(name);
                Object an = clazz.getAnnotation(this.anClazz);
                if (null == an) continue;
                newList.add(name);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return newList;
    }
}

