/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.common.annotion;

import com.apache.ius.common.annotion.AnntationBean;
import com.apache.ius.common.annotion.BeanFactory;
import com.apache.tools.StrUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationUtil {
    private static AnnotationUtil instance = new AnnotationUtil();
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static transient boolean isScanning = false;

    private AnnotationUtil() {
    }

    public static AnnotationUtil getInstance() {
        if (null == instance) {
            instance = new AnnotationUtil();
        }
        return instance;
    }

    public void findFileClass(String packName) {
        if (StrUtil.isNull((String)packName)) {
            return;
        }
        String[] pkNames = packName.split(",");
        boolean recursive = true;
        for (int i = 0; i < pkNames.length; ++i) {
            String pName = pkNames[i];
            String packageDirName = pName.replace('.', '/');
            try {
                Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
                while (dirs.hasMoreElements()) {
                    URL url = dirs.nextElement();
                    String protocol = url.getProtocol();
                    if ("file".equals(protocol)) {
                        String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                        this.findAndAddClassesInPackageByFile(pName, filePath, recursive);
                        continue;
                    }
                    if (!"jar".equals(protocol)) continue;
                    try {
                        JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                        this.loadJarClassBean(jar, packageDirName, pName, recursive);
                    }
                    catch (IOException e) {
                        this.log.error("\u5728\u626b\u63cf\u7528\u6237\u5b9a\u4e49\u89c6\u56fe\u65f6\u4ecejar\u5305\u83b7\u53d6\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                    }
                }
                continue;
            }
            catch (Exception e) {
                e.getStackTrace();
            }
        }
    }

    public boolean loadCalssBean(String pack) {
        if (StrUtil.isNull((String)pack)) {
            return false;
        }
        boolean recursive = true;
        String packageName = pack;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    this.findAndAddClassesInPackageByFile(packageName, filePath, recursive);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    this.loadJarClassBean(jar, packageDirName, packageName, recursive);
                }
                catch (IOException e) {
                    this.log.error("\u5728\u626b\u63cf\u7528\u6237\u5b9a\u4e49\u89c6\u56fe\u65f6\u4ecejar\u5305\u83b7\u53d6\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                }
            }
            isScanning = true;
        }
        catch (IOException e) {
            this.log.error("\u6267\u884c\u7c7b\u626b\u63cf\u5931\u8d25", (Throwable)e);
        }
        return true;
    }

    private void loadJarClassBean(JarFile jar, String packageDirName, String packageName, boolean recursive) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (!name.startsWith(packageDirName)) continue;
            int idx = name.lastIndexOf(47);
            if (idx != -1) {
                packageName = name.substring(0, idx).replace('/', '.');
            }
            if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
            String className = name.substring(packageName.length() + 1, name.length() - 6);
            try {
                Class<?> clazz = Class.forName(packageName + '.' + className);
                this.annotaitonBean(clazz, className);
            }
            catch (Exception e) {
                this.log.error("\u6dfb\u52a0\u7528\u6237\u81ea\u5b9a\u4e49\u89c6\u56fe\u7c7b\u9519\u8bef \u627e\u4e0d\u5230\u6b64\u7c7b\u7684.class\u6587\u4ef6", (Throwable)e);
            }
        }
    }

    private void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            this.log.warn("\u5305\u540d " + packageName + " \u4e0b\u6ca1\u6709\u4efb\u4f55\u6587\u4ef6");
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                this.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            this.log.warn(className);
            try {
                Class<?> clazz = Class.forName(packageName + '.' + className);
                this.annotaitonBean(clazz, className);
            }
            catch (Exception e) {
                this.log.error("\u6dfb\u52a0\u89c6\u56fe\u7c7b\u9519\u8bef \u627e\u4e0d\u5230\u6b64\u7c7b\u7684.class\u6587\u4ef6", (Throwable)e);
            }
        }
    }

    private void annotaitonBean(Class<?> calsz, String shortName) throws InstantiationException, IllegalAccessException {
        if (calsz.isAnnotationPresent(AnntationBean.class)) {
            AnntationBean annotation = calsz.getAnnotation(AnntationBean.class);
            String key = StrUtil.doNull((String)annotation.name(), (String)this.toLowerCaseFirstOne(shortName));
            BeanFactory.getInstance().setBeans(key, calsz.newInstance());
        }
    }

    private String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String pathToPackage(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path.replace("/", ".");
    }

    public static String packageToPath(String pkg) {
        return pkg.replace(".", File.separator);
    }

    public static String concat(Object ... objs) {
        StringBuilder sb = new StringBuilder(30);
        for (int ix = 0; ix < objs.length; ++ix) {
            sb.append(objs[ix]);
        }
        return sb.toString();
    }

    public static String trimSuffix(String name) {
        int dotIndex = name.indexOf(46);
        if (-1 == dotIndex) {
            return name;
        }
        return name.substring(0, dotIndex);
    }

    public static String distillPathFromJarURL(String url) {
        int startPos = url.indexOf(58);
        int endPos = url.lastIndexOf(33);
        return url.substring(startPos + 1, endPos);
    }

    public static String getURLEncoderString(String str) {
        String result = str;
        if (null == str) {
            return "";
        }
        try {
            result = URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }
}

