/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.common;

import com.apache.api.vo.ResultEntity;
import com.apache.api.vo.ResultMsg;
import com.apache.cache.service.impl.LoadCacheFactory;
import com.apache.cache.service.impl.redis.JedisSsoUtil;
import com.apache.cache.util.Validator;
import com.apache.client.UctCoreClient;
import com.apache.client.UctProtoclClient;
import com.apache.database.model.Page;
import com.apache.ius.common.CommonUtils;
import com.apache.rpc.client.SocketProtocolService;
import com.apache.rpc.common.LoadRpcService;
import com.apache.rpc.entity.InterfaceRegister;
import com.apache.tools.ConfigUtil;
import com.apache.tools.NumberUtils;
import com.apache.tools.StrUtil;
import com.apache.tools.UUIDUtil;
import com.apache.uct.common.LoginUser;
import com.apache.uct.common.ToolsUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfaceCallUtils {
    private static InterfaceCallUtils instance = new InterfaceCallUtils();

    private InterfaceCallUtils() {
    }

    public static InterfaceCallUtils getInstance() {
        return instance;
    }

    public Object userActsAction(Map params, LoginUser loginUser) {
        String method = StrUtil.doNull((String)String.valueOf(params.get("methodCall")), (String)"userRoleData");
        params.remove("methodCall");
        params.put("method", method);
        params.remove("pageName");
        params.remove("formName");
        if (loginUser != null) {
            params.put("createUser", loginUser.getUserEname());
        }
        if ("userRoleData".equalsIgnoreCase(method)) {
            params.put("userOrgId", loginUser.getOrgId());
            params.put("sysFlag", loginUser.getSysFlag());
            ResultEntity entity = UctProtoclClient.getInstance().doService("uctService", "userActsAction", params);
            Map map = (Map)entity.getEntity();
            if ("0".equals(loginUser.getSysFlag()) && (null == map || "0".equals(String.valueOf(map.get("total"))))) {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("userEname", loginUser.getUserEname());
                ResultEntity entity2 = UctCoreClient.searchRoleByReflect(param);
                HashMap<String, Object> mapo = new HashMap<String, Object>();
                if ("true".equals(entity2.getResult()) && !ToolsUtil.isEmpty((Object)entity2.getEntity())) {
                    List roles = (List)entity2.getEntity();
                    mapo.put("total", roles.size());
                    mapo.put("rows", roles);
                }
                return mapo;
            }
            return map;
        }
        if ("userRightRoleData".equalsIgnoreCase(method)) {
            ResultEntity entity = UctProtoclClient.getInstance().doService("uctService", "userActsAction", params);
            return entity.getEntity();
        }
        if ("userRightOrgData".equalsIgnoreCase(method)) {
            params.put("userOrgId", loginUser.getOrgId());
            params.put("nowOrgIds", loginUser.getDataOrgIds());
            params.put("sysFlag", loginUser.getSysFlag());
        } else if ("userRightDeptData".equalsIgnoreCase(method)) {
            params.put("nowDeptIds", loginUser.getDataDeptIds());
            params.put("sysFlag", loginUser.getSysFlag());
        } else if ("userRightAct".equalsIgnoreCase(method)) {
            if (!"1".equalsIgnoreCase(loginUser.getSysFlag())) {
                params.put("nowDeptId", loginUser.getDeptId());
                params.put("userOrgId", loginUser.getOrgId());
            }
            params.put("sysFlag", loginUser.getSysFlag());
        } else if ("orgActData".equalsIgnoreCase(method)) {
            params.put("nowOrgId", loginUser.getOrgId());
            params.put("nowSysUser", loginUser.getSysFlag());
            params.put("ParamType", "json");
            ResultEntity entity = UctProtoclClient.getInstance().doService("uctService", "orgAction", params);
            return entity.getEntity();
        }
        ResultEntity entity = UctProtoclClient.getInstance().doService("uctService", "userActsAction", params);
        return entity.getEntity();
    }

    public Object databaseInvoke(Map params, String serviceId, String methodKey) {
        ResultMsg msg = null;
        String method = StrUtil.doNull((String)String.valueOf(params.get("methodCall")), (String)"userRoleData");
        params.remove("methodCall");
        params.put("method", method);
        params.remove("pageName");
        params.remove("formName");
        if ("createDatabase".equals(method)) {
            params.put("useDatasource", StrUtil.doNull((String)String.valueOf(params.get("useDatasource")), (String)"plateform"));
        }
        ResultEntity entity = UctProtoclClient.getInstance().doService(serviceId, methodKey, params);
        if ("list".equals(method)) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (ToolsUtil.isEmpty((Object)entity.getEntity())) {
                if (entity.getEntity() instanceof Page) {
                    Page pageList = (Page)entity.getEntity();
                    data.put("total", pageList.getCount());
                    data.put("rows", pageList.getPageObjects());
                } else {
                    List list = (List)entity.getEntity();
                    data.put("total", list.size());
                    data.put("rows", list);
                }
            } else {
                data.put("total", "0");
            }
            return data;
        }
        msg = StrUtil.isNotNull((String)String.valueOf(entity.getEntity())) ? new ResultMsg("T", String.valueOf(entity.getEntity())) : new ResultMsg("F", entity.getMessage());
        return msg;
    }

    public Object sendSmsCode(Map params) {
        String userEmail;
        ResultMsg msg = new ResultMsg("F", "\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
        String templateIndex = StrUtil.doNull((String)String.valueOf(params.get("templateIndex")), (String)"0");
        String mobile = String.valueOf(params.get("mobile"));
        if (StrUtil.isNull((String)mobile)) {
            msg = new ResultMsg("F", StrUtil.doNull((String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"\u8bf7\u6c42\u7684Action\u5730\u5740\u672a\u5b9a\u4e49"));
            return msg;
        }
        String codeNo = UUIDUtil.getRandomStr((String)"1", (int)6, (int)97);
        Map<String, String> resultSmsMap = CommonUtils.sendSmsByCache(mobile, codeNo, String.valueOf(params.get("sysEname")), templateIndex);
        String resultCode = resultSmsMap.get("code");
        if ("OK".equals(resultCode)) {
            String content = "\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\u81f3\u60a8\u7684\u624b\u673a\u4e0a";
            if ("F".equals(resultSmsMap.get("sms_code_start"))) {
                content = content + "[" + codeNo + "]";
            }
            msg = new ResultMsg("T", content);
            CommonUtils.addCache("mobile_obj_" + mobile, codeNo, Integer.parseInt(StrUtil.doNull((String)CommonUtils.getConfigVal("expireTime"), (String)"1200")));
        }
        if (StrUtil.isNotNull((String)(userEmail = String.valueOf(params.get("userEmail"))))) {
            // empty if block
        }
        return msg;
    }

    public Object sendSSOMsg(Map params, String tokenId) {
        String method = StrUtil.doNull((String)String.valueOf(params.get("methodCall")), (String)"del");
        String spaceName = String.valueOf(params.get("spaceName"));
        if ("del".equals(method)) {
            ResultMsg rmsg = new ResultMsg("F", "\u64cd\u4f5c\u5931\u8d25,\u8bf7\u91cd\u8bd5!");
            String id = String.valueOf(params.get("id"));
            if (StrUtil.isNotNull((String)id)) {
                if (id.equals(tokenId)) {
                    rmsg.setFlag("H");
                    rmsg.setMsg("\u4e0d\u80fd\u5c06\u81ea\u5df1\u8e22\u51fa");
                    return rmsg;
                }
                JedisSsoUtil.getInstance().removeCacheObject(spaceName + "_" + id);
                JedisSsoUtil.getInstance().delListInfo(spaceName, id);
                rmsg.setFlag("T");
                rmsg.setMsg("\u5220\u9664\u6210\u529f");
            }
        } else if ("delAll".equals(method)) {
            ResultMsg rmsg = new ResultMsg("F", "\u64cd\u4f5c\u5931\u8d25,\u8bf7\u91cd\u8bd5!");
            String myCacheKey = "loginToken_" + tokenId;
            List keys = JedisSsoUtil.getInstance().getListForSpaceKey(spaceName, 0, 0);
            if (!Validator.isEmpty((List)keys)) {
                keys.remove(myCacheKey);
                int count = keys.size();
                for (int i = 0; i < count; ++i) {
                    String key = (String)keys.get(i);
                    JedisSsoUtil.getInstance().removeCacheObject(key);
                    JedisSsoUtil.getInstance().delListInfo(spaceName, key);
                }
            }
            rmsg.setFlag("T");
            rmsg.setMsg("\u5220\u9664\u6210\u529f");
        } else {
            int count = 0;
            HashMap<String, Serializable> mapData = new HashMap<String, Serializable>();
            ArrayList<Object> flightPageList = new ArrayList<Object>();
            int pageInt = NumberUtils.getInt((String)String.valueOf(params.get("page")), (int)1);
            int rowsInt = NumberUtils.getInt((String)String.valueOf(params.get("rows")), (int)15);
            List keys = JedisSsoUtil.getInstance().getListForSpaceKey(spaceName, 0, 0);
            if (!Validator.isEmpty((List)keys)) {
                count = keys.size();
            }
            if (count > 0) {
                int tj1;
                int pageCount = 0;
                pageCount = count % rowsInt == 0 ? count / rowsInt : count / rowsInt + 1;
                if (pageInt > pageCount) {
                    pageInt = pageCount;
                }
                for (int i = tj1 = (pageInt - 1) * rowsInt; i < count && i < pageInt * rowsInt && pageInt > 0; ++i) {
                    String key = (String)keys.get(i);
                    Object obj = JedisSsoUtil.getInstance().getCacheObjectByKey(key);
                    if (obj == null) {
                        JedisSsoUtil.getInstance().delListInfo(spaceName, key);
                    }
                    if (null == obj) continue;
                    flightPageList.add(JedisSsoUtil.getInstance().getCacheObjectByKey(key));
                }
            }
            mapData.put("total", Integer.valueOf(count));
            mapData.put("rows", flightPageList);
            return mapData;
        }
        return null;
    }

    public Object taskInvoke(Map params, String modelTypes) {
        String exeType = String.valueOf(params.get("exeType"));
        if ("start".equalsIgnoreCase(exeType) || "stop".equalsIgnoreCase(exeType)) {
            params.put("method", exeType);
            String exeIp = ConfigUtil.getInstance().getValueByKey("task.exe.ip");
            ResultEntity entity = null;
            if (StrUtil.isNotNull((String)exeIp)) {
                List list = (List)LoadCacheFactory.getInstance().getCacheManager("").getCacheCloneByKey("interfaceRegister_taskService");
                if (Validator.isEmpty((List)list)) {
                    return new ResultMsg("F", "\u8bf7\u6c42\u63a5\u53e3\u4e0d\u53ef\u7528");
                }
                InterfaceRegister register = null;
                for (InterfaceRegister item : list) {
                    if (!exeIp.equals(item.getAddress()) || !"socket".equals(item.getCallType())) continue;
                    register = item;
                    break;
                }
                if (register != null) {
                    SocketProtocolService socketService = new SocketProtocolService();
                    socketService.setRegister(register);
                    entity = socketService.doService("taskService", "timeTaskAction", params);
                }
            }
            if (entity == null) {
                entity = LoadRpcService.service().doService("taskService", "timeTaskAction", "xml", params, null);
            }
            if (StrUtil.isNotNull((String)String.valueOf(entity.getEntity()))) {
                return new ResultMsg("T", String.valueOf(entity.getEntity()));
            }
            return new ResultMsg("F", entity.getMessage());
        }
        String method = "list";
        if (modelTypes.startsWith("i_") || modelTypes.startsWith("u_")) {
            method = "save";
        } else if (modelTypes.startsWith("d_")) {
            method = "del";
        } else if ("loadCache".equals(exeType)) {
            method = "loadCache";
        }
        params.put("method", method);
        ResultEntity entity = LoadRpcService.service().doService("rpcService", "taskTimerAction", "xml", params, null);
        if (entity.getEntity() instanceof Page) {
            HashMap<String, Object> mapData = new HashMap<String, Object>();
            Page page = (Page)entity.getEntity();
            mapData.put("total", page.getCount());
            mapData.put("rows", page.getPageObjects());
            return mapData;
        }
        if (entity.getEntity() instanceof List) {
            HashMap<String, Object> mapData = new HashMap<String, Object>();
            List list = (List)entity.getEntity();
            mapData.put("total", list.size());
            mapData.put("rows", list);
            return mapData;
        }
        if (entity.getEntity() instanceof Map) {
            return entity.getEntity();
        }
        if (StrUtil.isNotNull((String)String.valueOf(entity.getEntity()))) {
            return new ResultMsg("T", String.valueOf(entity.getEntity()));
        }
        return new ResultMsg("F", entity.getMessage());
    }
}

