/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.common;

import com.apache.client.common.SmsUtil;
import com.apache.database.constant.SystemTools;
import com.apache.tools.ConfigUtil;
import com.apache.tools.StrUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static Logger log = LoggerFactory.getLogger(CommonUtils.class);
    private static final String file_config = "config.properties";
    private static String sysEname = CommonUtils.getConfigVal("sysEname");

    public static String getSysEname() {
        if (StrUtil.isNull((String)sysEname)) {
            sysEname = CommonUtils.getConfigVal("sysEname");
        }
        return sysEname;
    }

    public static boolean addCache(String cacheKey, Object object) {
        String spaceName = sysEname + "_" + cacheKey;
        boolean flag = SystemTools.getInstance().getCache(spaceName).createCacheObject(cacheKey, object);
        return flag;
    }

    public static boolean addCache(String cacheKey, Object object, int expireTime) {
        String spaceName = sysEname + "_" + cacheKey;
        boolean flag = SystemTools.getInstance().getCache(spaceName).createCacheObject(cacheKey, object, expireTime);
        return flag;
    }

    public static boolean addCache(String spaceName, String cacheKey, Object object, int expireTime) {
        boolean flag = SystemTools.getInstance().getCache(spaceName).createCacheObject(cacheKey, object, expireTime);
        return flag;
    }

    public static Object getCache(String cacheKey) {
        String spaceName = sysEname + "_" + cacheKey;
        Object object = SystemTools.getInstance().getCache(spaceName).getCacheObjectByKey(cacheKey);
        return object;
    }

    public static Object getCache(String spaceName, String cacheKey) {
        Object object = SystemTools.getInstance().getCache(spaceName).getCacheObjectByKey(cacheKey);
        return object;
    }

    public static Object getCacheByAppConfig(String typeKey) {
        Map appConfigCache;
        String key = "app_config";
        String spaceName = sysEname + "_" + key;
        log.info("-");
        log.info("\u4ece\u7f13\u5b58[" + spaceName + "]\u4e2d\uff0c\u8bfb\u53d6[" + key + "]\u4e0b\u7684[" + typeKey + "]\u7c7b\u578b\u914d\u7f6e....");
        Object object = SystemTools.getInstance().getCache(spaceName).getCacheObjectByKey(key);
        if (object != null && (appConfigCache = (Map)object) != null && appConfigCache.containsKey(typeKey)) {
            Map confMap = (Map)appConfigCache.get(typeKey);
            Iterator iter = confMap.entrySet().iterator();
            log.info("|********************[" + sysEname + "]\u7f13\u5b58\u7684[sys_app_config]\u914d\u7f6e\u4fe1\u606f start *******************************|");
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Map value = (Map)entry.getValue();
                log.info(" " + (String)entry.getKey() + "->" + value);
            }
            log.info("|********************[" + sysEname + "]\u7f13\u5b58\u7684[sys_app_config]\u914d\u7f6e\u4fe1\u606f end ********************************|");
            log.info("-");
            return confMap;
        }
        log.info("\u4ece\u7f13\u5b58[" + spaceName + "]\u4e2d\uff0c\u8bfb\u53d6[" + key + "]\u4e0b\u7684[" + typeKey + "]\u7c7b\u578b\u914d\u7f6e\u5931\u8d25\uff01\uff01\uff01");
        return null;
    }

    public static Object getCacheByAppConfig(String typeKey, String sysEname) {
        Map appConfigCache;
        String key = "app_config";
        String spaceName = StrUtil.doNull((String)sysEname, (String)CommonUtils.sysEname) + "_" + key;
        log.info("-");
        log.info("\u4ece\u7f13\u5b58[" + spaceName + "]\u4e2d\uff0c\u8bfb\u53d6[" + key + "]\u4e0b\u7684[" + typeKey + "]\u7c7b\u578b\u914d\u7f6e....");
        Object object = SystemTools.getInstance().getCache(spaceName).getCacheObjectByKey(key);
        if (object != null && (appConfigCache = (Map)object) != null && appConfigCache.containsKey(typeKey)) {
            Map confMap = (Map)appConfigCache.get(typeKey);
            Iterator iter = confMap.entrySet().iterator();
            log.info("|********************[" + sysEname + "]\u7f13\u5b58\u7684[sys_app_config]\u914d\u7f6e\u4fe1\u606f start *******************************|");
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Map value = (Map)entry.getValue();
                log.info(" " + (String)entry.getKey() + "->" + value);
            }
            log.info("|********************[" + sysEname + "]\u7f13\u5b58\u7684[sys_app_config]\u914d\u7f6e\u4fe1\u606f end ********************************|");
            log.info("-");
            return confMap;
        }
        log.info("\u4ece\u7f13\u5b58[" + spaceName + "]\u4e2d\uff0c\u8bfb\u53d6[" + key + "]\u4e0b\u7684[" + typeKey + "]\u7c7b\u578b\u914d\u7f6e\u5931\u8d25\uff01\uff01\uff01");
        return null;
    }

    public static Object removeCache(String cacheKey) {
        String spaceName = sysEname + "_" + cacheKey;
        Boolean object = SystemTools.getInstance().getCache(spaceName).removeCacheObject(cacheKey);
        return object;
    }

    public static Object exsistCache(String cacheKey) {
        String spaceName = sysEname + "_" + cacheKey;
        Boolean object = SystemTools.getInstance().getCache(spaceName).checkCacheObject(cacheKey);
        return object;
    }

    public static String getConfigVal(String key) {
        String configVal = ConfigUtil.getInstance().getLocalByKey(file_config, key);
        return configVal;
    }

    private static Map<String, String> sendSmsByAppConfig(String mobile, String codeNo, Map<String, Object> appConfig_sms) {
        Map<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("requestId", "");
        resultMap.put("bizId", "");
        resultMap.put("code", "fail");
        resultMap.put("message", "\u670d\u52a1\u7aef\u672a\u627e\u5230\u77ed\u4fe1\u670d\u52a1\u5546\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff01");
        if (appConfig_sms == null) {
            return resultMap;
        }
        String sms_code_start = StrUtil.doNull((String)String.valueOf(((Map)appConfig_sms.get("sms_code_start")).get("appValue")), (String)"F");
        String sms_aliyun_accessKeyId = String.valueOf(((Map)appConfig_sms.get("sms_aliyun_accessKeyId")).get("appValue"));
        String sms_aliyun_accessKeySecret = String.valueOf(((Map)appConfig_sms.get("sms_aliyun_accessKeySecret")).get("appValue"));
        String sms_aliyun_signName = String.valueOf(((Map)appConfig_sms.get("sms_aliyun_signName")).get("appValue"));
        String sms_aliyun_templateCode = String.valueOf(((Map)appConfig_sms.get("sms_aliyun_templateCode")).get("appValue"));
        if (StrUtil.isNull((String)sms_aliyun_accessKeyId)) {
            log.error("\u7f13\u5b58\u4e2d\u7f3a\u5c11[sms_aliyun_accessKeyId]\u914d\u7f6e\u4fe1\u606f");
            return resultMap;
        }
        if (StrUtil.isNull((String)sms_aliyun_accessKeySecret)) {
            log.error("\u7f13\u5b58\u4e2d\u7f3a\u5c11[sms_aliyun_accessKeySecret]\u914d\u7f6e\u4fe1\u606f");
            return resultMap;
        }
        if (StrUtil.isNull((String)sms_aliyun_signName)) {
            log.error("\u7f13\u5b58\u4e2d\u7f3a\u5c11[sms_aliyun_signName]\u914d\u7f6e\u4fe1\u606f");
            return resultMap;
        }
        if (StrUtil.isNull((String)sms_aliyun_templateCode)) {
            log.error("\u7f13\u5b58\u4e2d\u7f3a\u5c11[sms_aliyun_templateCode]\u914d\u7f6e\u4fe1\u606f");
            return resultMap;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("sms_code_start", sms_code_start);
        param.put("sms_aliyun_accessKeyId", sms_aliyun_accessKeyId);
        param.put("sms_aliyun_accessKeySecret", sms_aliyun_accessKeySecret);
        param.put("sms_aliyun_signName", sms_aliyun_signName);
        param.put("sms_aliyun_templateCode", sms_aliyun_templateCode.split(",")[0]);
        param.put("mobile", mobile);
        param.put("codeNo", codeNo);
        resultMap = SmsUtil.sendSms(param);
        resultMap.put("sms_code_start", sms_code_start);
        return resultMap;
    }

    private static Map<String, String> sendSmsByAppConfig(String mobile, String codeNo, Map<String, Object> appConfig_sms, String templateIndex) {
        Map<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("requestId", "");
        resultMap.put("bizId", "");
        resultMap.put("code", "fail");
        resultMap.put("message", "\u670d\u52a1\u7aef\u672a\u627e\u5230\u77ed\u4fe1\u670d\u52a1\u5546\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff01");
        if (appConfig_sms == null) {
            return resultMap;
        }
        String sms_code_start = StrUtil.doNull((String)String.valueOf(((Map)appConfig_sms.get("sms_code_start")).get("appValue")), (String)"F");
        String sms_aliyun_accessKeyId = String.valueOf(((Map)appConfig_sms.get("sms_aliyun_accessKeyId")).get("appValue"));
        String sms_aliyun_accessKeySecret = String.valueOf(((Map)appConfig_sms.get("sms_aliyun_accessKeySecret")).get("appValue"));
        String sms_aliyun_signName = String.valueOf(((Map)appConfig_sms.get("sms_aliyun_signName")).get("appValue"));
        String sms_aliyun_templateCode = String.valueOf(((Map)appConfig_sms.get("sms_aliyun_templateCode")).get("appValue"));
        if (StrUtil.isNull((String)sms_aliyun_accessKeyId)) {
            log.error("\u7f13\u5b58\u4e2d\u7f3a\u5c11[sms_aliyun_accessKeyId]\u914d\u7f6e\u4fe1\u606f");
            return resultMap;
        }
        if (StrUtil.isNull((String)sms_aliyun_accessKeySecret)) {
            log.error("\u7f13\u5b58\u4e2d\u7f3a\u5c11[sms_aliyun_accessKeySecret]\u914d\u7f6e\u4fe1\u606f");
            return resultMap;
        }
        if (StrUtil.isNull((String)sms_aliyun_signName)) {
            log.error("\u7f13\u5b58\u4e2d\u7f3a\u5c11[sms_aliyun_signName]\u914d\u7f6e\u4fe1\u606f");
            return resultMap;
        }
        if (StrUtil.isNull((String)sms_aliyun_templateCode)) {
            log.error("\u7f13\u5b58\u4e2d\u7f3a\u5c11[sms_aliyun_templateCode]\u914d\u7f6e\u4fe1\u606f");
            return resultMap;
        }
        String[] templateCodeArr = sms_aliyun_templateCode.split(",");
        if (Integer.parseInt(templateIndex) < 0 || Integer.parseInt(templateIndex) > templateCodeArr.length - 1) {
            log.error("\u7f13\u5b58\u4e2d\u7f3a\u5c11\u5bf9\u5e94\u7d22\u5f15\u7684[sms_aliyun_templateCode]\u914d\u7f6e\u4fe1\u606f");
            return resultMap;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("sms_code_start", sms_code_start);
        param.put("sms_aliyun_accessKeyId", sms_aliyun_accessKeyId);
        param.put("sms_aliyun_accessKeySecret", sms_aliyun_accessKeySecret);
        param.put("sms_aliyun_signName", sms_aliyun_signName);
        param.put("sms_aliyun_templateCode", sms_aliyun_templateCode.split(",")[Integer.parseInt(templateIndex)]);
        param.put("mobile", mobile);
        param.put("codeNo", codeNo);
        resultMap = SmsUtil.sendSms(param);
        return resultMap;
    }

    public static Map<String, String> sendSmsByCache(String mobile, String codeNo) {
        Map appConfig_sms = (Map)CommonUtils.getCacheByAppConfig("sms_aliyun");
        Map<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("requestId", "");
        resultMap.put("bizId", "");
        resultMap.put("code", "fail");
        resultMap.put("message", "\u670d\u52a1\u7aef\u672a\u627e\u5230\u77ed\u4fe1\u670d\u52a1\u5546\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff01");
        if (appConfig_sms == null) {
            return resultMap;
        }
        resultMap = CommonUtils.sendSmsByAppConfig(mobile, codeNo, appConfig_sms);
        return resultMap;
    }

    public static Map<String, String> sendSmsByCache(String mobile, String codeNo, String sysEname, String templateIndex) {
        Map appConfig_sms = (Map)CommonUtils.getCacheByAppConfig("sms_aliyun", sysEname);
        Map<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("requestId", "");
        resultMap.put("bizId", "");
        resultMap.put("code", "fail");
        resultMap.put("message", "\u670d\u52a1\u7aef\u672a\u627e\u5230\u77ed\u4fe1\u670d\u52a1\u5546\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u5e73\u53f0\u7ba1\u7406\u5458\uff01");
        if (appConfig_sms == null) {
            return resultMap;
        }
        resultMap = CommonUtils.sendSmsByAppConfig(mobile, codeNo, appConfig_sms, templateIndex);
        return resultMap;
    }
}

