/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.able;

import com.apache.database.constant.SpringContextLoader;
import com.apache.database.datasource.DynamicDataSource;
import com.apache.database.datasource.DynamicDataSourceHolder;
import com.apache.database.db.IDao;
import com.apache.database.model.MethodParam;
import java.util.concurrent.Callable;

public class SelectDatasourceCall
implements Callable<Object> {
    private String sql;
    private String datasource;
    private int pageIndex = 0;
    private int pageSize = 0;
    private boolean ifSort = false;

    public SelectDatasourceCall(String sql, String datasource) {
        this.datasource = datasource;
        this.sql = sql;
    }

    public SelectDatasourceCall(String sql, String datasource, int pageIndex, int pageSize) {
        this.datasource = datasource;
        this.sql = sql;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public SelectDatasourceCall(String sql, String datasource, int pageIndex, int pageSize, boolean ifSort) {
        this.datasource = datasource;
        this.sql = sql;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.ifSort = ifSort;
    }

    @Override
    public Object call() throws Exception {
        IDao dao = (IDao)SpringContextLoader.getBean((String)"iusPubDao");
        if (!DynamicDataSource.getInstance().checkDataSource(this.datasource)) {
            DynamicDataSource.getInstance().addDataSource(this.datasource);
        }
        DynamicDataSourceHolder.putDataSource((String)this.datasource);
        MethodParam params = new MethodParam(this.ifSort ? "ByLinkedObjInfo" : "ByObjInfo", "", "", "com.apache.ius.sql.DymicMapper");
        params.setParams("dyncSql", this.sql);
        if (this.pageSize > 0 && this.pageIndex > 0) {
            params.setPageIndex(this.pageIndex);
            params.setPageSize(this.pageSize);
            return dao.pageSelect(params);
        }
        return dao.select(params);
    }
}

