/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius.able;

import com.apache.cache.service.CacheManager;
import com.apache.cache.service.impl.ehcache.EhcacheManagerImpl;
import com.apache.cache.service.impl.redis.JedisSsoUtil;
import com.apache.tools.StrUtil;
import java.util.HashMap;
import java.util.Map;

public class CacheHelper {
    private static CacheHelper instance;
    private static Map<String, CacheManager> ehcaches;

    private CacheHelper() {
    }

    public static synchronized CacheHelper getInstance() {
        if (null == instance) {
            instance = new CacheHelper();
        }
        return instance;
    }

    public CacheManager getCache(String cacheName) {
        cacheName = StrUtil.doNull((String)cacheName, (String)"iusparamcache");
        return this.getEhcacheManager(cacheName);
    }

    public Object getCacheInfo(String key, String cacheName) {
        cacheName = StrUtil.doNull((String)cacheName, (String)"iusparamcache");
        return this.getEhcacheManager(cacheName).getCacheCloneByKey(key);
    }

    private CacheManager getEhcacheManager(String cacheName) {
        if (null == ehcaches.get(cacheName)) {
            EhcacheManagerImpl cacheManager = new EhcacheManagerImpl();
            cacheManager.setCacheName(cacheName);
            ehcaches.put(cacheName, (CacheManager)cacheManager);
        }
        return ehcaches.get(cacheName);
    }

    public Object getIusParamCache(String key) {
        if (JedisSsoUtil.getInstance().isRedisCache()) {
            return JedisSsoUtil.getInstance().getIusparamcacheByFileId(key);
        }
        return this.getCache("").getCacheObjectByKey(key);
    }

    public void setIusParamCache(String key, Map<String, String> params) {
        if (JedisSsoUtil.getInstance().isRedisCache()) {
            JedisSsoUtil.getInstance().setIusparamcache(key, params);
        } else {
            this.getCache("").createCacheObject(key, params);
        }
    }

    static {
        ehcaches = new HashMap<String, CacheManager>();
    }
}

