/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius;

import com.apache.api.vo.ParamsVo;
import com.apache.api.vo.ResultEntity;
import com.apache.cache.service.impl.redis.JedisSsoUtil;
import com.apache.cache.util.Validator;
import com.apache.client.InfoReleaseCoreCleint;
import com.apache.database.constant.SystemTools;
import com.apache.exception.BusinessException;
import com.apache.info.entity.PubMetadata;
import com.apache.ius.CustomMethodFactory;
import com.apache.ius.DymicSqlSuper;
import com.apache.ius.IusClassUtil;
import com.apache.ius.plugin.CustomMethodPlugin;
import com.apache.rpc.common.LoadRpcService;
import com.apache.tools.ConfigUtil;
import com.apache.uct.common.entity.Org;
import com.apache.uct.common.entity.User;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IusSqlTools
extends DymicSqlSuper {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String SPANCENAME = "com.apache.ius.sql.DymicMapper";
    private static IusSqlTools instance;

    private IusSqlTools() {
    }

    public void init() {
        instance = this;
    }

    public static IusSqlTools getInstance() {
        if (null == instance) {
            instance = new IusSqlTools();
        }
        return instance;
    }

    public String cteageNativeSql(ParamsVo vo, String exeType) {
        String modelTypes = String.valueOf(vo.getParams("modelTypes"));
        String execSql = "";
        if (Validator.isNotNull((String)modelTypes)) {
            String[] str = modelTypes.split(",");
            for (int i = 0; i < str.length; ++i) {
                Map<String, String> res = IusClassUtil.getInstance().convert2Map(vo.getParams(), str[i]);
                String sql = "";
                if ("insert".equalsIgnoreCase(exeType)) {
                    sql = this.createInsertSqlStr(res, str[i], vo);
                } else if ("update".equals(exeType)) {
                    sql = this.createUpdateSqlStr(res, str[i], vo);
                }
                if (!Validator.isNotNull((String)sql)) continue;
                execSql = execSql + sql + ";";
            }
        } else {
            execSql = String.valueOf(vo.getParams("execSql"));
        }
        this.log.info(execSql);
        return execSql;
    }

    public String cteageNativeSql(ParamsVo vo) {
        String execSql = "";
        String modelTypes = String.valueOf(vo.getParams("modelTypes"));
        if (Validator.isNotNull((String)modelTypes)) {
            String[] str = modelTypes.split(",");
            try {
                for (int i = 0; i < str.length; ++i) {
                    execSql = execSql + this.dymicInsertSql(vo, str, i);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException(e.getMessage());
            }
        } else {
            execSql = String.valueOf(vo.getParams("execSql"));
            this.log.info(execSql);
        }
        return execSql;
    }

    public String selectNativeSql(ParamsVo vo) {
        String modelTypes = String.valueOf(vo.getParams("modelTypes"));
        String sortCode = String.valueOf(vo.getParams("sortCode"));
        try {
            String sql = "";
            if (Validator.isNotNull((String)sortCode)) {
                Method method = IusSqlTools.class.getDeclaredMethod(modelTypes.substring(2) + "Sql", String.class, ParamsVo.class);
                sql = String.valueOf(method.invoke((Object)this, modelTypes, vo));
            } else {
                String sign = "";
                if ("T".equalsIgnoreCase(String.valueOf(vo.getParams("_resultType")))) {
                    sign = "@";
                }
                sql = this.getSelectMoreSqlStr(vo, modelTypes.split(","), sign);
            }
            this.log.info(sql);
            return sql;
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public String dymicNativeSql(ParamsVo vo) {
        String execSql = "";
        String modelTypes = String.valueOf(vo.getParams("modelTypes"));
        if (Validator.isNotNull((String)modelTypes)) {
            this.exeCustomPlugin(vo, "befor");
            if (Validator.isNotNull((String)String.valueOf(vo.getParams("plugin_execSql")))) {
                return String.valueOf(vo.getParams("plugin_execSql"));
            }
            String[] str = modelTypes.split(",");
            try {
                int count = str.length;
                if (modelTypes.startsWith("s_") && count > 1) {
                    execSql = this.getSelectMoreSqlStr(vo, str, "@");
                }
                if (modelTypes.startsWith("sl_") || modelTypes.startsWith("sr_") || modelTypes.startsWith("si_")) {
                    execSql = this.getSelectJoinSqlStr(vo, str, "@");
                }
                if (modelTypes.startsWith("s_") && count == 1) {
                    return this.selectNativeSql(vo);
                }
                for (int i = 0; i < str.length; ++i) {
                    execSql = execSql + this.dymicInsertSql(vo, str, i);
                }
            }
            catch (Exception e) {
                throw new BusinessException(e.getMessage());
            }
        } else {
            execSql = String.valueOf(vo.getParams("execSql"));
        }
        this.log.info(execSql);
        return execSql;
    }

    public String getTableAttr(String datasouce, String objName) {
        String attr = ConfigUtil.getInstance().getValueByKey("custom-method.properties", "obj_" + objName);
        if (Validator.isNull((String)attr)) {
            attr = this.getTableAttrStr("", datasouce, objName);
        }
        return attr;
    }

    private String dymicInsertSql(ParamsVo vo, String[] str, int i) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String prefix = str[i].substring(2);
        if (str[i].startsWith("ib_") || str[i].startsWith("ub_")) {
            prefix = str[i].substring(3);
        }
        String attr = ConfigUtil.getInstance().getValueByKey("custom-method.properties", "obj_" + prefix);
        String sql = "";
        if (Validator.isNull((String)attr)) {
            attr = this.densgerSql(vo, prefix);
        }
        Map<String, String> params = IusClassUtil.getInstance().convert2Map(vo.getParams(), prefix);
        if (Validator.isNull((String)attr)) {
            Method method = IusSqlTools.class.getDeclaredMethod(prefix + "Sql", String.class, ParamsVo.class);
            sql = String.valueOf(method.invoke((Object)this, str[i], vo));
        } else {
            String[] attrStr = attr.split(";");
            sql = this.dymicSql(str[i], vo, attrStr[2], attrStr[1], prefix, params, attrStr[3]);
            if (prefix.equalsIgnoreCase("sysPluginGroup")) {
                String rulesCode = String.valueOf(vo.getParams(prefix + ".rulesCode"));
                if (str[i].startsWith("d")) {
                    this.delCacheInfo("sysPluginGroup.w_rulesId", String.valueOf(vo.getParams(prefix + ".rulesId")), "sysPluginGroup");
                } else if (Validator.isNotNull((String)rulesCode)) {
                    this.getPlugin().setPluginInfo(rulesCode, params.get("rulesName"));
                }
            } else if (prefix.equalsIgnoreCase("sysPluginManager")) {
                if (str[i].startsWith("d")) {
                    this.delCacheInfo("sysPluginManager.w_infoId", String.valueOf(vo.getParams(prefix + ".infoId")), "sysPluginManager");
                } else {
                    CustomMethodFactory.getInstance().setPlugins(params.get("pluginShortName"), params.get("pluginFullName"));
                }
            } else if (prefix.equalsIgnoreCase("sysParamManager")) {
                if (str[i].startsWith("d")) {
                    this.delCacheInfo("sysParamManager.w_infoId", String.valueOf(vo.getParams(prefix + ".infoId")), "sysParamManager");
                }
            } else if (prefix.equalsIgnoreCase("trsRulesPro")) {
                // empty if block
            }
        }
        if (Validator.isNotNull((String)sql)) {
            String[] exsqlArry = (sql = sql + ";").split(";");
            if (exsqlArry.length > 1) {
                String printSql = sql;
                printSql = printSql.replace(";", ";\n");
                printSql = printSql.substring(0, printSql.lastIndexOf("\n"));
                this.log.info("[" + str[i] + "] Batch execution of SQL \uff1a\n" + printSql);
            } else {
                this.log.info(sql);
            }
        } else {
            this.log.info(sql);
        }
        return sql;
    }

    protected String uctUserSql(String exeType, ParamsVo vo) {
        vo.setParams(exeType + "_User", (Object)"uct_user");
        String result = this.reflection(exeType, vo, new User(), "user_id");
        return result;
    }

    protected String uctOrg(String exeType, ParamsVo vo) {
        vo.setParams(exeType + "_Org", (Object)"uct_org");
        String result = this.reflection(exeType, vo, new Org(), "org_id");
        return result;
    }

    protected String infoSql(String exeType, ParamsVo vo) {
        String sortCode = String.valueOf(vo.getParams("sortCode"));
        String sysName = String.valueOf(vo.getParams("datasource"));
        List list = InfoReleaseCoreCleint.getInstance().getMetadatas(sortCode, sysName);
        if (null == list) {
            return "";
        }
        Map<String, String> params = IusClassUtil.getInstance().convert2Map(vo.getParams(), "info");
        String attrStr = "";
        String primaryKeyId = "info_id";
        for (PubMetadata pm : list) {
            if ("1".equals(pm.getDataRestrict())) {
                primaryKeyId = pm.getDataShortName();
            }
            attrStr = attrStr + pm.getDataAttr() + ",";
        }
        this.invokePlugin(exeType, vo, "info", params);
        String tableName = this.upperCharToUnderLine("pub_" + sortCode);
        String result = this.dymicSql(exeType, vo, primaryKeyId, attrStr, "info", params, tableName);
        return result;
    }

    private String reflection(String exeType, ParamsVo vo, Object obj, String primaryKeyId) {
        String result = "";
        String attrStr = this.getReflectAttr(obj);
        String modelType = exeType.substring(2);
        Map<String, String> params = IusClassUtil.getInstance().convert2Map(vo.getParams(), modelType);
        this.invokePlugin(exeType, vo, modelType, params);
        String tableName = this.upperCharToUnderLine(obj.getClass().getSimpleName());
        if (Validator.isNotNull((String)String.valueOf(vo.getParams(exeType + "_" + obj.getClass().getSimpleName())))) {
            tableName = String.valueOf(vo.getParams(exeType + "_" + obj.getClass().getSimpleName()));
        }
        result = this.dymicSql(exeType, vo, primaryKeyId, attrStr, modelType, params, tableName);
        return result;
    }

    private void invokePlugin(String exeType, ParamsVo vo, String modelType, Map<String, String> params) {
        String keys = String.valueOf(vo.getParams("sqlKeyId"));
        String invokeMethodKey = String.valueOf(vo.getParams("invokeMethodKey"));
        if (Validator.isNotNull((String)keys)) {
            if (Validator.isNull((String)invokeMethodKey)) {
                return;
            }
            ParamsVo pvo = new ParamsVo();
            pvo.setParams(params);
            pvo.setParams("sqlKeyId", (Object)keys);
            pvo.setParams("plugin_exeType", (Object)modelType);
            pvo.setMethodKey("invokeMethodKey");
            Map map = (Map)this.getPlugin().doInvoke(pvo);
            if (!Validator.isEmpty((Object)map) && !map.isEmpty()) {
                for (String key : map.keySet()) {
                    params.put(key, String.valueOf(map.get(key)));
                }
                vo.setParams("invokeMethodKey", (Object)"");
                vo.setParams("sqlKeyId", (Object)"");
            }
        } else {
            if (Validator.isNull((String)invokeMethodKey)) {
                return;
            }
            CustomMethodPlugin plugin = CustomMethodFactory.getInstance().getPluginByKey(invokeMethodKey);
            if (!Validator.isEmpty((Object)plugin) && (exeType.startsWith("i_") || exeType.startsWith("u_") || exeType.startsWith("d_"))) {
                vo.setParams("plugin_exeType", (Object)modelType);
                Map map = (Map)plugin.doInvoke(vo.getParams());
                if (!Validator.isEmpty((Object)map)) {
                    for (String key : map.keySet()) {
                        params.put(key, String.valueOf(map.get(key)));
                    }
                }
                vo.setParams("invokeMethodKey", (Object)"");
            }
        }
    }

    public String createInsertSqlStr(Map<String, String> params, String modelType, ParamsVo paramVo) {
        String result = "";
        return result;
    }

    public String createUpdateSqlStr(Map<String, String> params, String modelType, ParamsVo paramVo) {
        String result = "";
        return result;
    }

    private void delCacheInfo(String idKey, String idValue, String tabObj) {
        HashMap<String, String> pms = new HashMap<String, String>();
        pms.put(idKey, idValue);
        pms.put("modelTypes", "s_" + tabObj);
        pms.put("resultType", "objInfo");
        pms.put("resultObjType", "obj");
        pms.put("sysPass", ConfigUtil.getInstance().interfacePass());
        ResultEntity result = LoadRpcService.service().doService("iusService", "dymicSql", "xml", pms, null);
        Map objInfo = (Map)result.getEntity();
        if (null == objInfo) {
            return;
        }
        switch (tabObj) {
            case "sysPluginGroup": {
                this.getPlugin().setPluginInfo(String.valueOf(objInfo.get("rulesCode")), "");
                break;
            }
            case "sysPluginManager": {
                CustomMethodFactory.getInstance().removePlugin(String.valueOf(objInfo.get("pluginShortName")));
                break;
            }
            case "sysParamManager": {
                String key = objInfo.get("formName") + "_" + objInfo.get("pageName");
                if (JedisSsoUtil.getInstance().isRedisCache()) {
                    JedisSsoUtil.getInstance().delIusparamcache(key);
                    break;
                }
                SystemTools.getInstance().getCache("iusparamcache").removeCacheObject(key);
            }
        }
    }
}

