/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius;

import com.apache.api.vo.ParamsVo;
import com.apache.api.vo.ResultEntity;
import com.apache.cache.util.Validator;
import com.apache.database.constant.SystemTools;
import com.apache.exception.BusinessException;
import com.apache.ius.function.FelFunction;
import com.apache.ius.plugin.IusPluginUtil;
import com.apache.tools.DateUtils;
import com.apache.tools.NumberUtils;
import com.apache.tools.StrUtil;
import com.greenpineyu.fel.FelEngine;
import com.greenpineyu.fel.FelEngineImpl;
import com.greenpineyu.fel.context.FelContext;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FelToolsUtil {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static FelToolsUtil instance;
    private static FelEngine felEngine;
    private static FelContext felContext;

    private FelToolsUtil() {
    }

    public static FelToolsUtil getInstance() {
        if (null == instance) {
            instance = new FelToolsUtil();
        }
        felEngine = new FelEngineImpl();
        felContext = felEngine.getContext();
        return instance;
    }

    public void evl(ParamsVo vo) {
        String cateNo = String.valueOf(vo.getParams("cateNo"));
        String saleId = String.valueOf(vo.getParams("saleId"));
        String proId = String.valueOf(vo.getParams("proId"));
        String constantType = String.valueOf(vo.getParams("constantType"));
        String constantStatus = String.valueOf(vo.getParams("constantStatus"));
        String constantResult = String.valueOf(vo.getParams("constantResult"));
        if (Validator.isNotNull((String)proId) || Validator.isNotNull((String)saleId) || Validator.isNotNull((String)constantType) || Validator.isNotNull((String)constantResult)) {
            HashMap<String, Object> whereMap = new HashMap<String, Object>();
            if (Validator.isNotNull((String)saleId)) {
                whereMap.put("sysRulesProd.w_saleId", saleId);
            }
            if (Validator.isNotNull((String)proId)) {
                whereMap.put("sysRulesProd.w_proId", proId);
            }
            if (Validator.isNotNull((String)cateNo)) {
                whereMap.put("sysRulesProd.wi_cateNo", cateNo);
            }
            if (Validator.isNotNull((String)constantType)) {
                whereMap.put("sysRulesProd.wi_constantType", constantType);
            }
            if (Validator.isNotNull((String)constantStatus)) {
                whereMap.put("sysRulesProd.wi_constantStatus", constantStatus);
            }
            whereMap.put("orderBy", "sysRulesProd.rules_no,sysRulesProd.order_no+0");
            ResultEntity resS = IusPluginUtil.getInstance().select("plateform", "list", "s_sysRulesProd", whereMap);
            if (resS == null || resS.getEntity() == null) {
                return;
            }
            List list = (List)resS.getEntity();
            if (Validator.isEmpty((List)list)) {
                return;
            }
            Map param = vo.getParams();
            this.log.info("request.param.data->" + param);
            for (int i = 0; i < list.size(); ++i) {
                Object numCalVal;
                String[] str;
                Map map = (Map)list.get(i);
                String dealType = String.valueOf(map.get("dealType"));
                String formulaCal = String.valueOf(map.get("formulaCal"));
                String rulesNo = String.valueOf(map.get("rulesNo"));
                String rulesName = String.valueOf(map.get("rulesName"));
                String formulaName = String.valueOf(map.get("formulaName"));
                String paramNo = String.valueOf(map.get("paramNo"));
                String ruelsResFlag = String.valueOf(map.get("resFlag"));
                param.put("rulesNo", rulesNo);
                param.put("paramNo", paramNo);
                param.put("formulaName", formulaName);
                if ("numCalculate".equals(dealType)) {
                    str = formulaCal.split("=");
                    if (!StrUtil.isNull((String)constantResult) && "T".equals(ruelsResFlag)) {
                        this.addCalsResList(constantResult, vo, map, str[0]);
                        continue;
                    }
                    numCalVal = this.numCalculateForFel(rulesNo, formulaCal, param);
                    this.log.info("\u89c4\u5219[" + rulesNo + "][" + dealType + "][" + formulaName + "][" + formulaCal + "]->\u5904\u7406\u7ed3\u679c[" + String.valueOf(numCalVal) + "]");
                    vo.setParams(str[0], numCalVal);
                    continue;
                }
                if ("numValidate".equals(dealType)) {
                    this.numValidate(formulaCal, param);
                    continue;
                }
                if ("dateValidate".equals(dealType)) {
                    this.dateValidate(formulaCal, param);
                    continue;
                }
                if ("dateCalculate".equals(dealType)) {
                    str = formulaCal.split("=");
                    Object rs = this.dateCalculate(formulaCal, param);
                    String[] keys = str[0].split(":");
                    if (keys.length > 1) {
                        vo.setParams(keys[1], rs);
                        continue;
                    }
                    vo.setParams(str[0], rs);
                    continue;
                }
                if ("custom".equals(dealType)) {
                    try {
                        this.log.info("\u89c4\u5219[" + rulesNo + "][" + dealType + "][" + formulaName + "][" + formulaCal + "]->[\u81ea\u5b9a\u4e49\u63d2\u4ef6]");
                        Class<?> cls = Class.forName(formulaCal);
                        Method m = cls.getDeclaredMethod("run", ParamsVo.class);
                        m.invoke(cls.newInstance(), vo);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new BusinessException(e.getCause().getMessage());
                    }
                }
                if ("customFun".equals(dealType)) {
                    str = formulaCal.split("=");
                    numCalVal = this.exeFormula(rulesNo, formulaCal, param);
                    this.log.info("\u89c4\u5219[" + rulesNo + "][" + dealType + "][" + formulaName + "][" + formulaCal + "]->\u5904\u7406\u7ed3\u679c[" + String.valueOf(numCalVal) + "]");
                    vo.setParams(str[0], numCalVal);
                    continue;
                }
                if (!"datetext".equals(dealType) || formulaCal.indexOf("=") <= -1 || (str = formulaCal.split("=")).length <= 0) continue;
                vo.setParams(str[0], (Object)str[1]);
                this.log.info("\u89c4\u5219[" + rulesNo + "][" + dealType + "][" + formulaName + "][" + formulaCal + "]->\u5904\u7406\u7ed3\u679c[" + String.valueOf(vo.getParams(str[0])) + "]");
            }
            this.printConstantResult_log(param);
        } else {
            this.log.error("\u3010constantType\u3011\u3010proId\u3011\u3010saleId\u3011\u3010constantResult\u3011\u4e0d\u80fd\u90fd\u4e3a\u7a7a\uff01");
        }
    }

    private void printConstantResult_log(Map<String, Object> param) {
        String constantResultKeys = String.valueOf(param.get("constantResult"));
        if (param.containsKey(constantResultKeys)) {
            List list = (List)param.get(constantResultKeys);
            this.log.info("-");
            this.log.info("<---- Rule execution is complete,return items,print to start. ---->");
            for (int i = 0; i < list.size(); ++i) {
                this.log.info(i + 1 + "." + list.get(i));
            }
            this.log.info("<---- Rule execution is complete,return items,print to end.   ---->");
            this.log.info("-");
        }
    }

    private void addCalsResList(String constantResult, ParamsVo vo, Map sysRulesProd, String calKey) {
        Map param = vo.getParams();
        String sysRulesProd_constantType = String.valueOf(sysRulesProd.get("constantType"));
        String sysRulesProd_constantStatus = String.valueOf(sysRulesProd.get("constantStatus"));
        String formulaCal = String.valueOf(sysRulesProd.get("formulaCal"));
        String rulesNo = String.valueOf(sysRulesProd.get("rulesNo"));
        String rulesName = String.valueOf(sysRulesProd.get("rulesName"));
        String dealType = String.valueOf(sysRulesProd.get("dealType"));
        String formulaName = String.valueOf(sysRulesProd.get("formulaName"));
        List calsResList = new ArrayList();
        Object calResultObj = vo.getParams(constantResult);
        if (calResultObj != null) {
            calsResList = (List)calResultObj;
        }
        String rules_custom_key = "rules_custom_" + calKey;
        Object rules_custom_obj = vo.getParams(rules_custom_key);
        Map rules_custom_map = new HashMap();
        if (rules_custom_obj != null) {
            rules_custom_map = (Map)rules_custom_obj;
        }
        String rules_custom_res_flag = StrUtil.doNull((String)String.valueOf(rules_custom_map.get("res")), (String)"T");
        Object loopObj = rules_custom_map.get("list");
        List rules_custom_loop = new ArrayList();
        if (loopObj != null) {
            rules_custom_loop = (List)loopObj;
        }
        HashMap<String, Object> calResultMap = new HashMap<String, Object>();
        if ("T".equalsIgnoreCase(rules_custom_res_flag)) {
            if (rules_custom_loop.size() > 0) {
                for (int j = 0; j < rules_custom_loop.size(); ++j) {
                    calResultMap = new HashMap();
                    Map customMap = (Map)rules_custom_loop.get(j);
                    param.putAll(customMap);
                    Object numCalVal = this.numCalculateForFel(rulesNo, formulaCal, param);
                    this.log.info("\u89c4\u5219[" + rulesNo + "][" + dealType + "][" + formulaName + "][" + formulaCal + "]->\u5904\u7406\u7ed3\u679c[" + String.valueOf(numCalVal) + "]");
                    calResultMap.put("constantType", sysRulesProd_constantType);
                    calResultMap.put("constantStatus", sysRulesProd_constantStatus);
                    calResultMap.put("rulesName", rulesName);
                    calResultMap.put("calculateKey", calKey);
                    calResultMap.put("calculateVal", numCalVal);
                    calResultMap.put("calculate", formulaCal);
                    calResultMap.put("otherParam", customMap.get("otherParam"));
                    calsResList.add(calResultMap);
                }
            } else {
                Object numCalVal = this.numCalculateForFel(rulesNo, formulaCal, param);
                this.log.info("\u89c4\u5219[" + rulesNo + "][" + dealType + "][" + formulaName + "][" + formulaCal + "]->\u5904\u7406\u7ed3\u679c[" + String.valueOf(numCalVal) + "]");
                calResultMap.put("constantType", sysRulesProd_constantType);
                calResultMap.put("constantStatus", sysRulesProd_constantStatus);
                calResultMap.put("rulesName", rulesName);
                calResultMap.put("calculateKey", calKey);
                calResultMap.put("calculateVal", numCalVal);
                calResultMap.put("calculate", formulaCal);
                calResultMap.put("otherParam", "");
                calsResList.add(calResultMap);
            }
            vo.setParams(constantResult, calsResList);
        }
    }

    public void calculate(ParamsVo vo) {
    }

    public boolean compare(ParamsVo vo) {
        return false;
    }

    public Object numCalculateForFel(String rulesNo, String formulaCal, Map<String, Object> param) {
        formulaCal = formulaCal.replace("==", "###");
        formulaCal = formulaCal.replace("<=", "#lteq#");
        formulaCal = formulaCal.replace(">=", "#gteq#");
        formulaCal = formulaCal.replace("[[", "'").replace("]]", "'");
        String[] str = formulaCal.split("=");
        String eval = str[1];
        StringBuffer keyssb = new StringBuffer("");
        for (String key : param.keySet()) {
            if (str[1].indexOf(key) == -1) continue;
            String val = String.valueOf(param.get(key));
            keyssb.append("[" + key + "=" + val + "]");
            if (this.isNumeric(val)) {
                felContext.set(key.replace(".", "_"), (Object)Double.valueOf(val));
            } else {
                felContext.set(key.replace(".", "_"), (Object)val);
            }
            eval = eval.replace(key, key.replace(".", "_"));
        }
        if (keyssb.length() > 0) {
            this.log.info("\u89c4\u5219[" + rulesNo + "]->variables required by formulas\uff1a" + keyssb.toString());
        }
        eval = eval.replace("###", "==").replace("#lteq#", "<=").replace("#gteq#", ">=");
        Object result = null;
        try {
            result = felEngine.eval(eval);
        }
        catch (Exception ew) {
            this.log.error("\u89c4\u5219[" + rulesNo + "]->\u3010\u3010\u5f02\u5e38\u9519\u8bef\u3011\u3011[exception message->" + ew.getMessage() + "][\u53ef\u80fd\u662f\u53d8\u91cf\u7f3a\u5931\u6216\u8005\u7c7b\u578b\u4e0d\u7b26\u5bfc\u81f4\u5f02\u5e38\uff01\uff01\uff01]");
        }
        if (result != null) {
            String res = NumberUtils.format((double)Double.valueOf(String.valueOf(result)), (int)2, (boolean)false);
            return res;
        }
        return "";
    }

    private boolean numValidate(String formulaCal, Map<String, Object> param) {
        for (String key : param.keySet()) {
            if (formulaCal.indexOf(key) == -1) continue;
            felContext.set(key.replace(".", "_"), (Object)Double.valueOf(String.valueOf(param.get(key))));
            formulaCal = formulaCal.replace(key, key.replace(".", "_"));
        }
        if (formulaCal.indexOf(62) == -1 && formulaCal.indexOf(60) == -1 && formulaCal.indexOf("==") == -1) {
            String[] compareStr = formulaCal.split("=");
            Object result = felEngine.eval(compareStr[1].replace(".", "_"));
            if (String.valueOf(result).contains(".")) {
                result = String.format("%.2f", result);
            }
            Object paramResult = param.get(compareStr[0]);
            felContext.set("result", result);
            felContext.set("paramResult", paramResult);
            if ("true".equalsIgnoreCase(String.valueOf(felEngine.eval("result==paramResult")))) {
                return true;
            }
            this.log.info("----" + param.get("formulaName") + "[" + param.get("rulesNo") + "][" + formulaCal + "]-\u516c\u5f0f\u6821\u9a8c\u5931\u8d25\uff01");
            throw new BusinessException(param.get("rulesNo") + "|" + param.get("formulaName") + ",\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff01");
        }
        Object result = felEngine.eval(formulaCal);
        this.log.info("----[numValidate][" + param.get("formulaName") + "][" + formulaCal + "]->\u5904\u7406\u7ed3\u679c\uff1a" + result);
        if (!"true".equalsIgnoreCase(String.valueOf(result))) {
            this.log.info(param.get("formulaName") + "[" + param.get("rulesNo") + "][" + formulaCal + "]-\u516c\u5f0f\u6821\u9a8c\u5931\u8d25\uff01");
            throw new BusinessException(param.get("rulesNo") + "|" + param.get("formulaName") + "|\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff01|" + param.get("paramNo"));
        }
        return true;
    }

    public Object exeFormula(String rulesNo, String formulaCal, Map<String, Object> param) {
        String[] str = formulaCal.split("=");
        String eval = str[1];
        StringBuffer keyssb = new StringBuffer("");
        for (String key : param.keySet()) {
            if (str[1].indexOf(key) == -1) continue;
            String val = String.valueOf(param.get(key));
            keyssb.append("[" + key + "=" + val + "]");
            felContext.set(key, (Object)val);
        }
        if (keyssb.length() > 0) {
            this.log.info("\u89c4\u5219[" + rulesNo + "]->variables required by formulas\uff1a" + keyssb.toString());
        } else {
            this.log.error("\u89c4\u5219[" + rulesNo + "]->this function required param is all empty");
        }
        Object result = null;
        try {
            result = felEngine.eval(eval);
        }
        catch (Exception ew) {
            this.log.error(ew.getMessage());
        }
        if (result != null) {
            return result;
        }
        return "";
    }

    private boolean dateValidate(String formulaCal, Map<String, Object> param) {
        Object eval;
        String expPrefix = formulaCal;
        String[] keys = formulaCal.split(":");
        String enumKey = "dateCompare";
        if (keys.length > 1) {
            enumKey = keys[0];
            expPrefix = keys[1];
        }
        for (String key : param.keySet()) {
            if (expPrefix.indexOf(key) == -1) continue;
            expPrefix = expPrefix.replace(key, String.valueOf(param.get(key)));
        }
        String exp = "";
        if (expPrefix.indexOf("certEndTime") != -1) {
            felEngine.addFun(FelFunction.getInstance().dateValidate());
            exp = "dateValidate('dateCompare','" + expPrefix + "')";
        }
        if (Validator.isNull((String)String.valueOf(eval = felEngine.eval(exp)))) {
            this.log.info(param.get("formulaName") + "[" + param.get("rulesNo") + "][" + formulaCal + "]-\u516c\u5f0f\u6821\u9a8c\u5931\u8d25\uff01");
            throw new BusinessException(param.get("rulesNo") + "|" + param.get("formulaName") + ",\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff01");
        }
        eval = felEngine.eval(String.valueOf(eval));
        this.log.info("----[dateValidate][" + param.get("formulaName") + "][" + eval + "]->\u5904\u7406\u7ed3\u679c\uff1a" + eval);
        if (!"true".equalsIgnoreCase(String.valueOf(eval))) {
            this.log.info(param.get("formulaName") + "[" + param.get("rulesNo") + "][" + formulaCal + "]-\u516c\u5f0f\u6821\u9a8c\u5931\u8d25\uff01");
            throw new BusinessException(param.get("rulesNo") + "|" + param.get("formulaName") + ",\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff01");
        }
        return true;
    }

    private Object dateCalculate(String formulaCal, Map<String, Object> param) {
        String[] str = formulaCal.split("=");
        String expPrefix = str[1];
        String[] keys = str[0].split(":");
        String enumKey = "sumDate";
        if (keys.length > 1) {
            enumKey = keys[0];
        }
        if (expPrefix.indexOf("sysdate") != -1) {
            expPrefix = expPrefix.replace("sysdate", DateUtils.getToday());
        }
        if (expPrefix.indexOf("systime") != -1) {
            expPrefix = expPrefix.replace("systime", DateUtils.Now.fmt_HHmmss());
        }
        if (expPrefix.indexOf("sysDateTime") != -1) {
            expPrefix = expPrefix.replace("sysDateTime", DateUtils.Now.fmt_yyyyMMdd_HHmmss());
        }
        for (String key : param.keySet()) {
            if (expPrefix.indexOf(key) == -1) continue;
            expPrefix = expPrefix.replace(key, String.valueOf(param.get(key)));
        }
        String exp = "";
        felEngine.addFun(FelFunction.getInstance().dateCalculate());
        exp = "dateCalculate('" + enumKey + "','" + expPrefix + "')";
        Object eval = felEngine.eval(exp);
        this.log.info("----[dateCalculate][" + param.get("formulaName") + "][" + exp + "]->\u5904\u7406\u7ed3\u679c\uff1a" + eval);
        return eval;
    }

    private String densgerSql(ParamsVo vo, String prefix) {
        String sortCode = "";
        String tab = this.upperCharToUnderLine(prefix);
        if (tab.indexOf(95) == -1) {
            return "";
        }
        sortCode = tab.substring(tab.indexOf(95) + 1);
        String key = sortCode + "_tableAttr";
        String content = String.valueOf(SystemTools.getInstance().getCache("").getCacheObjectByKey(key));
        if (Validator.isNotNull((String)content)) {
            return content;
        }
        return "1;*;info_id;" + tab;
    }

    private String upperCharToUnderLine(String param) {
        Pattern p = Pattern.compile("[A-Z]");
        if (param == null || param.equals("")) {
            return "";
        }
        StringBuilder builder = new StringBuilder(param);
        Matcher mc = p.matcher(param);
        int i = 0;
        while (mc.find()) {
            builder.replace(mc.start() + i, mc.end() + i, "_" + mc.group().toLowerCase());
            ++i;
        }
        if ('_' == builder.charAt(0)) {
            builder.deleteCharAt(0);
        }
        return builder.toString();
    }

    private boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("(^[0-9]+(.[0-9]{1,6})?$)|(^\\-[0-9]+(.[0-9]{1,6})?$)");
        return pattern.matcher(str).matches();
    }

    private boolean isDate(String str) {
        Pattern pattern = Pattern.compile("(\\d{4}-\\d{1,2}-\\d{1,2})|(\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{2}:\\d{2}:\\d{2})");
        return pattern.matcher(str).matches();
    }

    public static void main(String[] args) {
        FelEngineImpl fel = new FelEngineImpl();
        FelContext ctx = fel.getContext();
        ctx.set("totalMoney", (Object)100);
        ctx.set("buyFee", (Object)10);
        ctx.set("sellFee", (Object)20);
        ctx.set("flag", (Object)"buy");
        System.out.println("\u666e\u901a\u8fd0\u7b97->" + fel.eval("totalMoney*buyFee+sellFee"));
        System.out.println("\u4e09\u76ee\u8fd0\u7b97->" + fel.eval("(flag=='buy')?(totalMoney+buyFee):(sellFee)"));
        ctx.set("price", (Object)40000);
        String cals = "(price<=50000)?(price*0.06):((price>50000&&price<=100000)?(50000*0.06+(price-50000)*0.08):(50000*0.06+50000*0.08+(price-100000)*0.1))";
        System.out.println("40000\u5224\u65ad&&\u8ba1\u7b97\u60c5\u51b51->" + fel.eval(cals));
        ctx.set("price", (Object)80000);
        System.out.println("80000\u5224\u65ad&&\u8ba1\u7b97\u60c5\u51b52->" + fel.eval(cals));
        ctx.set("price", (Object)120000);
        System.out.println("120000\u5224\u65ad&&\u8ba1\u7b97\u60c5\u51b53->" + fel.eval(cals));
        int[] intArray = new int[]{1, 2, 3};
        ctx.set("intArray", (Object)intArray);
        System.out.println("\u8bbf\u95ee\u6570\u7ec4->" + fel.eval("intArray[1]"));
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user1", "user111");
        m.put("user2", "user222");
        ctx.set("userMap", m);
        System.out.println("\u8bbf\u95eeMap\u6307\u5b9akey\u5bf9\u5e94value->" + fel.eval("userMap.user1"));
        ctx.set("x", (Object)2);
        ctx.set("y", (Object)3);
        cals = "$('Math').pow(x,y)";
        System.out.println("\u8c03\u7528\u9759\u6001\u65b9\u6cd5Math.pow(x\u7684y\u6b21\u65b9)->" + fel.eval(cals));
        try {
            ctx.set("nowDate", (Object)DateUtils.parse((String)"2019-09-05"));
            ctx.set("day", (Object)3);
            cals = "$('com.apache.tools.DateUtils').beforeNDays(nowDate,day)";
            Date befDate = (Date)fel.eval(cals);
            System.out.println("\u8c03\u7528\u81ea\u5b9a\u4e49\u7c7b\u7684\u65b9\u6cd5->" + DateUtils.format((Date)befDate, (String)DateUtils.FmtStr.yyyyMMdd.toString()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

