/*
 * Decompiled with CFR 0.152.
 */
package com.apache.ius;

import com.apache.cache.util.Validator;
import com.apache.database.constant.SpringContextLoader;
import com.apache.database.datasource.DynamicDataSource;
import com.apache.database.datasource.DynamicDataSourceHolder;
import com.apache.database.db.IDao;
import com.apache.database.model.MethodParam;
import com.apache.exception.BusinessException;
import com.apache.ius.IusSqlTools;
import com.apache.ius.plugin.CustomMethodPlugin;
import com.apache.tools.DataMap;
import com.apache.tools.StrUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMethodFactory {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static CustomMethodFactory instance;
    private final String customPluginCacheKey = "group_";

    private CustomMethodFactory() {
    }

    public static synchronized CustomMethodFactory getInstance() {
        if (null == instance) {
            instance = new CustomMethodFactory();
        }
        return instance;
    }

    private CustomMethodPlugin initConfig(String key) {
        try {
            if (Validator.isNull((String)key)) {
                if (!IusSqlTools.getInstance().getPluginsCache().checkCacheObject("groups_open_mark")) {
                    List list = this.getList("");
                    if (null == list || list.isEmpty()) {
                        return null;
                    }
                    int count = list.size();
                    for (int i = 0; i < count; ++i) {
                        DataMap dmap = (DataMap)list.get(i);
                        String pluginKey = String.valueOf(dmap.get("pluginFullName"));
                        this.log.info("\u52a0\u8f7d\u63d2\u4ef6[" + dmap.get("sysName") + "]:" + pluginKey);
                        this.setCacheInfo(String.valueOf(dmap.get("pluginShortName")), pluginKey);
                    }
                    this.log.info("\u52a0\u8f7d\u4e86[" + list.size() + "]\u6761\u63d2\u4ef6\u6570\u636e");
                    IusSqlTools.getInstance().getPluginsCache().createCacheObject("groups_open_mark", (Object)"true");
                }
                return null;
            }
            String cacheKey = "group_" + key;
            Object value = IusSqlTools.getInstance().getPluginsCache().getCacheObjectByKey(cacheKey);
            if (null != value) {
                if (value instanceof String) {
                    return this.getPluginsByKey(String.valueOf(value));
                }
                return (CustomMethodPlugin)value;
            }
            List list = this.getList(key);
            String pluginKey = "";
            if (null != list && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    DataMap dmap = (DataMap)list.get(i);
                    pluginKey = String.valueOf(dmap.get("pluginFullName"));
                    this.log.info("\u52a0\u8f7d\u63d2\u4ef6[" + dmap.get("sysName") + "]:" + pluginKey);
                    this.setCacheInfo(String.valueOf(dmap.get("pluginShortName")), pluginKey);
                }
                this.log.info("\u52a0\u8f7d\u4e86[" + list.size() + "]\u6761\u63d2\u4ef6\u6570\u636e");
                return this.getPluginsByKey(pluginKey);
            }
            return null;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.info("\u6ce8\u5165\u63a5\u53e3\u5931\u8d25\uff01", (Throwable)e);
            return null;
        }
    }

    private List getList(String key) {
        if (!DynamicDataSource.getInstance().checkDataSource("plateform")) {
            DynamicDataSource.getInstance().addDataSource("plateform");
        }
        DynamicDataSourceHolder.putDataSource((String)"plateform");
        IDao iusDao = (IDao)SpringContextLoader.getBean((String)"iusPubDao");
        MethodParam param = new MethodParam("sysPluginManager", "", "", "com.apache.ius.sql.DymicMapper");
        if (Validator.isNotNull((String)key)) {
            param.setParams("pluginShortName", key);
        }
        param.setOrderby("sys");
        List list = iusDao.select(param);
        return list;
    }

    private CustomMethodPlugin getPluginsByKey(String className) {
        if (StrUtil.isNotNull((String)className)) {
            try {
                this.log.info("\u5f00\u59cb\u6267\u884c\u63d2\u4ef6\uff1a" + className);
                Class<?> clazz = Class.forName(className);
                CustomMethodPlugin plugin = (CustomMethodPlugin)clazz.newInstance();
                return plugin;
            }
            catch (Exception e) {
                this.log.error("\u52a0\u8f7d\u63d2\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5[" + className + "]\u914d\u7f6e\u6216\u8005\u63d2\u4ef6\u662f\u5426\u5b58\u5728");
                throw new BusinessException("\u52a0\u8f7d\u63d2\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5[" + className + "]\u914d\u7f6e\u6216\u8005\u63d2\u4ef6\u662f\u5426\u5b58\u5728");
            }
        }
        return null;
    }

    public void init() {
        this.initConfig("");
    }

    private void setCacheInfo(String key, Object plugin) {
        String cacheKey = "group_" + key;
        IusSqlTools.getInstance().getPluginsCache().createCacheObject(cacheKey, plugin);
    }

    public void setPlugins(String key, String value) {
        if (Validator.isNull((String)key) || Validator.isNull((String)value)) {
            return;
        }
        this.setCacheInfo(key, value.trim());
    }

    public void removePlugin(String key) {
        String cacheKey = "group_" + key;
        IusSqlTools.getInstance().getPluginsCache().removeCacheObject(cacheKey);
    }

    public CustomMethodPlugin getPluginByKey(String key) {
        return this.initConfig(key);
    }
}

