/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.util.ImportExcelUtil;
import org.jeecg.modules.system.entity.SysRole;
import org.jeecg.modules.system.mapper.SysRoleMapper;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.jeecg.modules.system.service.ISysRoleService;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysRoleServiceImpl
extends ServiceImpl<SysRoleMapper, SysRole>
implements ISysRoleService {
    @Autowired
    SysRoleMapper sysRoleMapper;
    @Autowired
    SysUserMapper sysUserMapper;

    @Override
    public Result importExcelCheckRoleCode(MultipartFile file, ImportParams params) throws Exception {
        List listSysRoles = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), SysRole.class, (ImportParams)params);
        int totalCount = listSysRoles.size();
        ArrayList<String> errorStrs = new ArrayList<String>();
        block0: for (int i = 0; i < listSysRoles.size(); ++i) {
            String roleCodeI = ((SysRole)listSysRoles.get(i)).getRoleCode();
            for (int j = i + 1; j < listSysRoles.size(); ++j) {
                String roleCodeJ = ((SysRole)listSysRoles.get(j)).getRoleCode();
                if (!roleCodeI.equals(roleCodeJ)) continue;
                errorStrs.add("\u7b2c " + (j + 1) + " \u884c\u7684 roleCode \u503c\uff1a" + roleCodeI + " \u5df2\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165");
                listSysRoles.remove(j);
                continue block0;
            }
        }
        Integer errorLines = 0;
        Integer successLines = 0;
        List<String> list = ImportExcelUtil.importDateSave(listSysRoles, ISysRoleService.class, errorStrs, "uniq_sys_role_role_code");
        errorLines = errorLines + list.size();
        successLines = successLines + (listSysRoles.size() - errorLines);
        return ImportExcelUtil.imporReturnRes(errorLines, successLines, list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteRole(String roleid) {
        this.sysRoleMapper.deleteRoleUserRelation(roleid);
        this.sysRoleMapper.deleteRolePermissionRelation(roleid);
        this.removeById((Serializable)((Object)roleid));
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteBatchRole(String[] roleIds) {
        this.sysUserMapper.deleteBathRoleUserRelation(roleIds);
        this.sysUserMapper.deleteBathRolePermissionRelation(roleIds);
        this.removeByIds(Arrays.asList(roleIds));
        return true;
    }
}

