/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jeecg.modules.system.entity.SysCheckRule;
import org.jeecg.modules.system.mapper.SysCheckRuleMapper;
import org.jeecg.modules.system.service.ISysCheckRuleService;
import org.springframework.stereotype.Service;

@Service
public class SysCheckRuleServiceImpl
extends ServiceImpl<SysCheckRuleMapper, SysCheckRule>
implements ISysCheckRuleService {
    private final String CHECK_ALL_SYMBOL = "*";

    @Override
    public SysCheckRule getByCode(String ruleCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysCheckRule::getRuleCode, (Object)ruleCode);
        return (SysCheckRule)super.getOne((Wrapper)queryWrapper);
    }

    @Override
    public JSONObject checkValue(SysCheckRule checkRule, String value) {
        String ruleJson;
        if (checkRule != null && StringUtils.isNotBlank((String)value) && StringUtils.isNotBlank((String)(ruleJson = checkRule.getRuleJson()))) {
            int beginIndex = 0;
            JSONArray rules = JSON.parseArray((String)ruleJson);
            for (int i = 0; i < rules.size(); ++i) {
                String checkValue;
                JSONObject result = new JSONObject();
                JSONObject rule = rules.getJSONObject(i);
                String digits = rule.getString("digits");
                result.put("digits", (Object)digits);
                String pattern = rule.getString("pattern");
                result.put("pattern", (Object)pattern);
                String message = rule.getString("message");
                result.put("message", (Object)message);
                if ("*".equals(digits)) {
                    checkValue = value;
                } else {
                    int num = Integer.parseInt(digits);
                    int endIndex = beginIndex + num;
                    endIndex = endIndex > value.length() ? value.length() : endIndex;
                    checkValue = beginIndex > endIndex ? "" : value.substring(beginIndex, endIndex);
                    result.put("beginIndex", (Object)beginIndex);
                    result.put("endIndex", (Object)endIndex);
                    beginIndex += num;
                }
                result.put("checkValue", (Object)checkValue);
                boolean passed = Pattern.matches(pattern, checkValue);
                result.put("passed", (Object)passed);
                if (passed) continue;
                return result;
            }
        }
        return null;
    }
}

