/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.FillRuleUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysCategory;
import org.jeecg.modules.system.mapper.SysCategoryMapper;
import org.jeecg.modules.system.model.TreeSelectModel;
import org.jeecg.modules.system.service.ISysCategoryService;
import org.springframework.stereotype.Service;

@Service
public class SysCategoryServiceImpl
extends ServiceImpl<SysCategoryMapper, SysCategory>
implements ISysCategoryService {
    @Override
    public void addSysCategory(SysCategory sysCategory) {
        String categoryCode = "";
        String categoryPid = "0";
        String parentCode = null;
        if (oConvertUtils.isNotEmpty(sysCategory.getPid()) && !"0".equals(categoryPid = sysCategory.getPid())) {
            SysCategory parent = (SysCategory)((SysCategoryMapper)this.baseMapper).selectById((Serializable)((Object)categoryPid));
            parentCode = parent.getCode();
            if (parent != null && !"1".equals(parent.getHasChild())) {
                parent.setHasChild("1");
                ((SysCategoryMapper)this.baseMapper).updateById(parent);
            }
        }
        JSONObject formData = new JSONObject();
        formData.put("pid", (Object)categoryPid);
        categoryCode = (String)FillRuleUtil.executeRule("category_code_rule", formData);
        sysCategory.setCode(categoryCode);
        sysCategory.setPid(categoryPid);
        ((SysCategoryMapper)this.baseMapper).insert(sysCategory);
    }

    @Override
    public void updateSysCategory(SysCategory sysCategory) {
        if (oConvertUtils.isEmpty(sysCategory.getPid())) {
            sysCategory.setPid("0");
        } else {
            SysCategory parent = (SysCategory)((SysCategoryMapper)this.baseMapper).selectById((Serializable)((Object)sysCategory.getPid()));
            if (parent != null && !"1".equals(parent.getHasChild())) {
                parent.setHasChild("1");
                ((SysCategoryMapper)this.baseMapper).updateById(parent);
            }
        }
        ((SysCategoryMapper)this.baseMapper).updateById(sysCategory);
    }

    @Override
    public List<TreeSelectModel> queryListByCode(String pcode) throws JeecgBootException {
        String pid = "0";
        if (oConvertUtils.isNotEmpty(pcode)) {
            List list = ((SysCategoryMapper)this.baseMapper).selectList((Wrapper)new LambdaQueryWrapper().eq(SysCategory::getCode, (Object)pcode));
            if (list == null || list.size() == 0) {
                throw new JeecgBootException("\u8be5\u7f16\u7801\u3010" + pcode + "\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e!");
            }
            if (list.size() > 1) {
                throw new JeecgBootException("\u8be5\u7f16\u7801\u3010" + pcode + "\u3011\u5b58\u5728\u591a\u4e2a\uff0c\u8bf7\u6838\u5b9e!");
            }
            pid = ((SysCategory)list.get(0)).getId();
        }
        return ((SysCategoryMapper)this.baseMapper).queryListByPid(pid, null);
    }

    @Override
    public List<TreeSelectModel> queryListByPid(String pid) {
        if (oConvertUtils.isEmpty(pid)) {
            pid = "0";
        }
        return ((SysCategoryMapper)this.baseMapper).queryListByPid(pid, null);
    }

    @Override
    public List<TreeSelectModel> queryListByPid(String pid, Map<String, String> condition) {
        if (oConvertUtils.isEmpty(pid)) {
            pid = "0";
        }
        return ((SysCategoryMapper)this.baseMapper).queryListByPid(pid, condition);
    }

    @Override
    public String queryIdByCode(String code) {
        return ((SysCategoryMapper)this.baseMapper).queryIdByCode(code);
    }
}

