/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysAnnouncement;
import org.jeecg.modules.system.entity.SysAnnouncementSend;
import org.jeecg.modules.system.mapper.SysAnnouncementMapper;
import org.jeecg.modules.system.mapper.SysAnnouncementSendMapper;
import org.jeecg.modules.system.service.ISysAnnouncementService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysAnnouncementServiceImpl
extends ServiceImpl<SysAnnouncementMapper, SysAnnouncement>
implements ISysAnnouncementService {
    @Resource
    private SysAnnouncementMapper sysAnnouncementMapper;
    @Resource
    private SysAnnouncementSendMapper sysAnnouncementSendMapper;

    @Override
    @Transactional
    public void saveAnnouncement(SysAnnouncement sysAnnouncement) {
        if (sysAnnouncement.getMsgType().equals("ALL")) {
            this.sysAnnouncementMapper.insert(sysAnnouncement);
        } else {
            this.sysAnnouncementMapper.insert(sysAnnouncement);
            String userId = sysAnnouncement.getUserIds();
            String[] userIds = userId.substring(0, userId.length() - 1).split(",");
            String anntId = sysAnnouncement.getId();
            Date refDate = new Date();
            for (int i = 0; i < userIds.length; ++i) {
                SysAnnouncementSend announcementSend = new SysAnnouncementSend();
                announcementSend.setAnntId(anntId);
                announcementSend.setUserId(userIds[i]);
                announcementSend.setReadFlag("0");
                announcementSend.setReadTime(refDate);
                this.sysAnnouncementSendMapper.insert(announcementSend);
            }
        }
    }

    @Override
    @Transactional
    public boolean upDateAnnouncement(SysAnnouncement sysAnnouncement) {
        this.sysAnnouncementMapper.updateById(sysAnnouncement);
        String userId = sysAnnouncement.getUserIds();
        if (oConvertUtils.isNotEmpty(userId) && sysAnnouncement.getMsgType().equals("USER")) {
            LambdaQueryWrapper queryWrapper;
            String[] userIds = userId.substring(0, userId.length() - 1).split(",");
            String anntId = sysAnnouncement.getId();
            Date refDate = new Date();
            for (int i = 0; i < userIds.length; ++i) {
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysAnnouncementSend::getAnntId, (Object)anntId);
                queryWrapper.eq(SysAnnouncementSend::getUserId, (Object)userIds[i]);
                List announcementSends = this.sysAnnouncementSendMapper.selectList((Wrapper)queryWrapper);
                if (announcementSends.size() > 0) continue;
                SysAnnouncementSend announcementSend = new SysAnnouncementSend();
                announcementSend.setAnntId(anntId);
                announcementSend.setUserId(userIds[i]);
                announcementSend.setReadFlag("0");
                announcementSend.setReadTime(refDate);
                this.sysAnnouncementSendMapper.insert(announcementSend);
            }
            List<String> delUserIds = Arrays.asList(userIds);
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.notIn(SysAnnouncementSend::getUserId, delUserIds);
            queryWrapper.eq(SysAnnouncementSend::getAnntId, (Object)anntId);
            this.sysAnnouncementSendMapper.delete((Wrapper)queryWrapper);
        }
        return true;
    }

    @Override
    public void saveSysAnnouncement(String title, String msgContent) {
        SysAnnouncement announcement = new SysAnnouncement();
        announcement.setTitile(title);
        announcement.setMsgContent(msgContent);
        announcement.setSender("JEECG BOOT");
        announcement.setPriority("L");
        announcement.setMsgType("ALL");
        announcement.setSendStatus("1");
        announcement.setSendTime(new Date());
        announcement.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
        this.sysAnnouncementMapper.insert(announcement);
    }

    @Override
    public Page<SysAnnouncement> querySysCementPageByUserId(Page<SysAnnouncement> page, String userId, String msgCategory) {
        return page.setRecords(this.sysAnnouncementMapper.querySysCementListByUserId(page, userId, msgCategory));
    }
}

