/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.message.websocket.WebSocket;
import org.jeecg.modules.system.entity.SysAnnouncement;
import org.jeecg.modules.system.entity.SysAnnouncementSend;
import org.jeecg.modules.system.service.ISysAnnouncementSendService;
import org.jeecg.modules.system.service.ISysAnnouncementService;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/sys/annountCement"})
public class SysAnnouncementController {
    private static final Logger log = LoggerFactory.getLogger(SysAnnouncementController.class);
    @Autowired
    private ISysAnnouncementService sysAnnouncementService;
    @Autowired
    private ISysAnnouncementSendService sysAnnouncementSendService;
    @Resource
    private WebSocket webSocket;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<IPage<SysAnnouncement>> queryPageList(SysAnnouncement sysAnnouncement, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Result<IPage<SysAnnouncement>> result = new Result<IPage<SysAnnouncement>>();
        sysAnnouncement.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
        QueryWrapper queryWrapper = new QueryWrapper((Object)sysAnnouncement);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String column = req.getParameter("column");
        String order = req.getParameter("order");
        if (oConvertUtils.isNotEmpty(column) && oConvertUtils.isNotEmpty(order)) {
            if ("asc".equals(order)) {
                queryWrapper.orderByAsc((Object)oConvertUtils.camelToUnderline(column));
            } else {
                queryWrapper.orderByDesc((Object)oConvertUtils.camelToUnderline(column));
            }
        }
        IPage pageList = this.sysAnnouncementService.page((IPage)page, (Wrapper)queryWrapper);
        log.info("\u67e5\u8be2\u5f53\u524d\u9875\uff1a" + pageList.getCurrent());
        log.info("\u67e5\u8be2\u5f53\u524d\u9875\u6570\u91cf\uff1a" + pageList.getSize());
        log.info("\u67e5\u8be2\u7ed3\u679c\u6570\u91cf\uff1a" + pageList.getRecords().size());
        log.info("\u6570\u636e\u603b\u6570\uff1a" + pageList.getTotal());
        result.setSuccess(true);
        result.setResult(pageList);
        return result;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Result<SysAnnouncement> add(@RequestBody SysAnnouncement sysAnnouncement) {
        Result<SysAnnouncement> result = new Result<SysAnnouncement>();
        try {
            sysAnnouncement.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
            sysAnnouncement.setSendStatus("0");
            this.sysAnnouncementService.saveAnnouncement(sysAnnouncement);
            result.success("\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT})
    public Result<SysAnnouncement> eidt(@RequestBody SysAnnouncement sysAnnouncement) {
        Result<SysAnnouncement> result = new Result<SysAnnouncement>();
        SysAnnouncement sysAnnouncementEntity = (SysAnnouncement)this.sysAnnouncementService.getById((Serializable)((Object)sysAnnouncement.getId()));
        if (sysAnnouncementEntity == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            boolean ok = this.sysAnnouncementService.upDateAnnouncement(sysAnnouncement);
            if (ok) {
                result.success("\u4fee\u6539\u6210\u529f!");
            }
        }
        return result;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public Result<SysAnnouncement> delete(@RequestParam(name="id", required=true) String id) {
        Result<SysAnnouncement> result = new Result<SysAnnouncement>();
        SysAnnouncement sysAnnouncement = (SysAnnouncement)this.sysAnnouncementService.getById((Serializable)((Object)id));
        if (sysAnnouncement == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            sysAnnouncement.setDelFlag(CommonConstant.DEL_FLAG_1.toString());
            boolean ok = this.sysAnnouncementService.updateById(sysAnnouncement);
            if (ok) {
                result.success("\u5220\u9664\u6210\u529f!");
            }
        }
        return result;
    }

    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.DELETE})
    public Result<SysAnnouncement> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        Result<SysAnnouncement> result = new Result<SysAnnouncement>();
        if (ids == null || "".equals(ids.trim())) {
            result.error500("\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        } else {
            String[] id = ids.split(",");
            for (int i = 0; i < id.length; ++i) {
                SysAnnouncement announcement = (SysAnnouncement)this.sysAnnouncementService.getById((Serializable)((Object)id[i]));
                announcement.setDelFlag(CommonConstant.DEL_FLAG_1.toString());
                this.sysAnnouncementService.updateById(announcement);
            }
            result.success("\u5220\u9664\u6210\u529f!");
        }
        return result;
    }

    @RequestMapping(value={"/queryById"}, method={RequestMethod.GET})
    public Result<SysAnnouncement> queryById(@RequestParam(name="id", required=true) String id) {
        Result<SysAnnouncement> result = new Result<SysAnnouncement>();
        SysAnnouncement sysAnnouncement = (SysAnnouncement)this.sysAnnouncementService.getById((Serializable)((Object)id));
        if (sysAnnouncement == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            result.setResult(sysAnnouncement);
            result.setSuccess(true);
        }
        return result;
    }

    @RequestMapping(value={"/doReleaseData"}, method={RequestMethod.GET})
    public Result<SysAnnouncement> doReleaseData(@RequestParam(name="id", required=true) String id, HttpServletRequest request) {
        Result<SysAnnouncement> result = new Result<SysAnnouncement>();
        SysAnnouncement sysAnnouncement = (SysAnnouncement)this.sysAnnouncementService.getById((Serializable)((Object)id));
        if (sysAnnouncement == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            sysAnnouncement.setSendStatus("1");
            sysAnnouncement.setSendTime(new Date());
            String currentUserName = JwtUtil.getUserNameByToken(request);
            sysAnnouncement.setSender(currentUserName);
            boolean ok = this.sysAnnouncementService.updateById(sysAnnouncement);
            if (ok) {
                result.success("\u8be5\u7cfb\u7edf\u901a\u77e5\u53d1\u5e03\u6210\u529f");
                if (sysAnnouncement.getMsgType().equals("ALL")) {
                    JSONObject obj = new JSONObject();
                    obj.put("cmd", (Object)"topic");
                    obj.put("msgId", (Object)sysAnnouncement.getId());
                    obj.put("msgTxt", (Object)sysAnnouncement.getTitile());
                    this.webSocket.sendAllMessage(obj.toJSONString());
                } else {
                    String userId = sysAnnouncement.getUserIds();
                    String[] userIds = userId.substring(0, userId.length() - 1).split(",");
                    String anntId = sysAnnouncement.getId();
                    Date refDate = new Date();
                    JSONObject obj = new JSONObject();
                    obj.put("cmd", (Object)"user");
                    obj.put("msgId", (Object)sysAnnouncement.getId());
                    obj.put("msgTxt", (Object)sysAnnouncement.getTitile());
                    this.webSocket.sendMoreMessage(userIds, obj.toJSONString());
                }
            }
        }
        return result;
    }

    @RequestMapping(value={"/doReovkeData"}, method={RequestMethod.GET})
    public Result<SysAnnouncement> doReovkeData(@RequestParam(name="id", required=true) String id, HttpServletRequest request) {
        Result<SysAnnouncement> result = new Result<SysAnnouncement>();
        SysAnnouncement sysAnnouncement = (SysAnnouncement)this.sysAnnouncementService.getById((Serializable)((Object)id));
        if (sysAnnouncement == null) {
            result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        } else {
            sysAnnouncement.setSendStatus("2");
            sysAnnouncement.setCancelTime(new Date());
            boolean ok = this.sysAnnouncementService.updateById(sysAnnouncement);
            if (ok) {
                result.success("\u8be5\u7cfb\u7edf\u901a\u77e5\u64a4\u9500\u6210\u529f");
            }
        }
        return result;
    }

    @RequestMapping(value={"/listByUser"}, method={RequestMethod.GET})
    public Result<Map<String, Object>> listByUser() {
        List announcements;
        Result<Map<String, Object>> result = new Result<Map<String, Object>>();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = sysUser.getId();
        List<String> anntIds = this.sysAnnouncementSendService.queryByUserId(userId);
        LambdaQueryWrapper querySaWrapper = new LambdaQueryWrapper();
        querySaWrapper.eq(SysAnnouncement::getMsgType, (Object)"ALL");
        querySaWrapper.eq(SysAnnouncement::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        querySaWrapper.eq(SysAnnouncement::getSendStatus, (Object)"1");
        querySaWrapper.ge(SysAnnouncement::getEndTime, (Object)sysUser.getCreateTime());
        if (anntIds != null && anntIds.size() > 0) {
            querySaWrapper.notIn(SysAnnouncement::getId, anntIds);
        }
        if ((announcements = this.sysAnnouncementService.list((Wrapper)querySaWrapper)).size() > 0) {
            for (int i = 0; i < announcements.size(); ++i) {
                SysAnnouncementSend announcementSend = new SysAnnouncementSend();
                announcementSend.setAnntId(((SysAnnouncement)announcements.get(i)).getId());
                announcementSend.setUserId(userId);
                announcementSend.setReadFlag("0");
                this.sysAnnouncementSendService.save(announcementSend);
            }
        }
        Page<SysAnnouncement> anntMsgList = new Page<SysAnnouncement>(0L, 5L);
        anntMsgList = this.sysAnnouncementService.querySysCementPageByUserId(anntMsgList, userId, "1");
        Page<SysAnnouncement> sysMsgList = new Page<SysAnnouncement>(0L, 5L);
        sysMsgList = this.sysAnnouncementService.querySysCementPageByUserId(sysMsgList, userId, "2");
        HashMap<String, Object> sysMsgMap = new HashMap<String, Object>();
        sysMsgMap.put("sysMsgList", sysMsgList.getRecords());
        sysMsgMap.put("sysMsgTotal", sysMsgList.getTotal());
        sysMsgMap.put("anntMsgList", anntMsgList.getRecords());
        sysMsgMap.put("anntMsgTotal", anntMsgList.getTotal());
        result.setSuccess(true);
        result.setResult(sysMsgMap);
        return result;
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(SysAnnouncement sysAnnouncement, HttpServletRequest request) {
        QueryWrapper<SysAnnouncement> queryWrapper = QueryGenerator.initQueryWrapper(sysAnnouncement, request.getParameterMap());
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        List pageList = this.sysAnnouncementService.list((Wrapper)queryWrapper);
        mv.addObject("fileName", (Object)"\u7cfb\u7edf\u901a\u544a\u5217\u8868");
        mv.addObject("entity", SysAnnouncement.class);
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        mv.addObject("params", (Object)new ExportParams("\u7cfb\u7edf\u901a\u544a\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u5bfc\u51fa\u4fe1\u606f"));
        mv.addObject("data", (Object)pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List listSysAnnouncements = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), SysAnnouncement.class, (ImportParams)params);
                for (SysAnnouncement sysAnnouncementExcel : listSysAnnouncements) {
                    if (sysAnnouncementExcel.getDelFlag() == null) {
                        sysAnnouncementExcel.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
                    }
                    this.sysAnnouncementService.save(sysAnnouncementExcel);
                }
                Result<Object> result = Result.ok("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570\uff1a" + listSysAnnouncements.size());
                return result;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result<Object> result = Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/syncNotic"}, method={RequestMethod.GET})
    public Result<SysAnnouncement> syncNotic(@RequestParam(name="anntId", required=false) String anntId, HttpServletRequest request) {
        Result<SysAnnouncement> result = new Result<SysAnnouncement>();
        JSONObject obj = new JSONObject();
        if (StringUtils.isNotBlank((String)anntId)) {
            SysAnnouncement sysAnnouncement = (SysAnnouncement)this.sysAnnouncementService.getById((Serializable)((Object)anntId));
            if (sysAnnouncement == null) {
                result.error500("\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
            } else if (sysAnnouncement.getMsgType().equals("ALL")) {
                obj.put("cmd", (Object)"topic");
                obj.put("msgId", (Object)sysAnnouncement.getId());
                obj.put("msgTxt", (Object)sysAnnouncement.getTitile());
                this.webSocket.sendAllMessage(obj.toJSONString());
            } else {
                String userId = sysAnnouncement.getUserIds();
                if (oConvertUtils.isNotEmpty(userId)) {
                    String[] userIds = userId.substring(0, userId.length() - 1).split(",");
                    obj.put("cmd", (Object)"user");
                    obj.put("msgId", (Object)sysAnnouncement.getId());
                    obj.put("msgTxt", (Object)sysAnnouncement.getTitile());
                    this.webSocket.sendMoreMessage(userIds, obj.toJSONString());
                }
            }
        } else {
            obj.put("cmd", (Object)"topic");
            obj.put("msgTxt", (Object)"\u6279\u91cf\u8bbe\u7f6e\u5df2\u8bfb");
            this.webSocket.sendAllMessage(obj.toJSONString());
        }
        return result;
    }
}

