/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.aspect;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.IPUtils;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.modules.system.entity.SysLog;
import org.jeecg.modules.system.service.ISysLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class AutoLogAspect {
    @Autowired
    private ISysLogService sysLogService;

    @Pointcut(value="@annotation(org.jeecg.common.aspect.annotation.AutoLog)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        Object result = point.proceed();
        long time = System.currentTimeMillis() - beginTime;
        this.saveSysLog(point, time);
        return result;
    }

    private void saveSysLog(ProceedingJoinPoint joinPoint, long time) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        SysLog sysLog = new SysLog();
        AutoLog syslog = method.getAnnotation(AutoLog.class);
        if (syslog != null) {
            sysLog.setLogContent(syslog.value());
            sysLog.setLogType(syslog.logType());
        }
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = signature.getName();
        sysLog.setMethod(className + "." + methodName + "()");
        if (sysLog.getLogType() == 2) {
            sysLog.setOperateType(this.getOperateType(methodName, syslog.operateType()));
        }
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        sysLog.setRequestParam(this.getReqestParams(request, (JoinPoint)joinPoint));
        sysLog.setIp(IPUtils.getIpAddr(request));
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (sysUser != null) {
            sysLog.setUserid(sysUser.getUsername());
            sysLog.setUsername(sysUser.getRealname());
        }
        sysLog.setCostTime(time);
        sysLog.setCreateTime(new Date());
        this.sysLogService.save(sysLog);
    }

    private int getOperateType(String methodName, int operateType) {
        if (operateType > 0) {
            return operateType;
        }
        if (methodName.startsWith("list")) {
            return 1;
        }
        if (methodName.startsWith("add")) {
            return 2;
        }
        if (methodName.startsWith("edit")) {
            return 3;
        }
        if (methodName.startsWith("delete")) {
            return 4;
        }
        if (methodName.startsWith("import")) {
            return 5;
        }
        if (methodName.startsWith("export")) {
            return 6;
        }
        return 1;
    }

    private String getReqestParams(HttpServletRequest request, JoinPoint joinPoint) {
        String httpMethod = request.getMethod();
        String params = "";
        if ("POST".equals(httpMethod) || "PUT".equals(httpMethod) || "PATCH".equals(httpMethod)) {
            Object[] paramsArray = joinPoint.getArgs();
            Object[] arguments = new Object[paramsArray.length];
            for (int i = 0; i < paramsArray.length; ++i) {
                if (paramsArray[i] instanceof ServletRequest || paramsArray[i] instanceof ServletResponse || paramsArray[i] instanceof MultipartFile) continue;
                arguments[i] = paramsArray[i];
            }
            params = JSONObject.toJSONString((Object)arguments);
        } else {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            Object[] args = joinPoint.getArgs();
            LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
            String[] paramNames = u.getParameterNames(method);
            if (args != null && paramNames != null) {
                for (int i = 0; i < args.length; ++i) {
                    params = params + "  " + paramNames[i] + ": " + args[i];
                }
            }
        }
        return params;
    }
}

