/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.shiro.web;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.subject.Subject;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.modules.shiro.vo.ResponseBean;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TestWebController {
    private ISysUserService userService;

    @Autowired
    public void setService(ISysUserService userService) {
        this.userService = userService;
    }

    @PostMapping(value={"/login"})
    public ResponseBean login(@RequestParam(value="username") String username, @RequestParam(value="password") String password) {
        SysUser user = this.userService.getUserByName(username);
        if (user == null) {
            return new ResponseBean(200, "\u7528\u6237\u4e0d\u5b58\u5728\uff01", JwtUtil.sign(username, user.getPassword()));
        }
        String passwordEncode = PasswordUtil.encrypt(username, password, user.getSalt());
        if (passwordEncode.equals(user.getPassword())) {
            return new ResponseBean(200, "Login success", JwtUtil.sign(username, user.getPassword()));
        }
        throw new UnauthorizedException();
    }

    @GetMapping(value={"/article"})
    public ResponseBean article() {
        Subject subject = SecurityUtils.getSubject();
        if (subject.isAuthenticated()) {
            return new ResponseBean(200, "You are already logged in", null);
        }
        return new ResponseBean(200, "You are guest", null);
    }

    @GetMapping(value={"/require_auth"})
    @RequiresAuthentication
    public ResponseBean requireAuth() {
        return new ResponseBean(200, "You are authenticated", null);
    }

    @GetMapping(value={"/require_role"})
    @RequiresRoles(value={"admin"})
    public ResponseBean requireRole() {
        return new ResponseBean(200, "You are visiting require_role", null);
    }

    @GetMapping(value={"/require_permission"})
    @RequiresPermissions(logical=Logical.AND, value={"view", "edit"})
    public ResponseBean requirePermission() {
        return new ResponseBean(200, "You are visiting permission require edit,view", null);
    }

    @RequestMapping(path={"/401"})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseBean unauthorized() {
        return new ResponseBean(401, "Unauthorized", null);
    }
}

