/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.message.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jeecg.modules.message.entity.SysMessage;
import org.jeecg.modules.message.entity.SysMessageTemplate;
import org.jeecg.modules.message.handle.enums.SendMsgStatusEnum;
import org.jeecg.modules.message.service.ISysMessageService;
import org.jeecg.modules.message.service.ISysMessageTemplateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PushMsgUtil {
    @Autowired
    private ISysMessageService sysMessageService;
    @Autowired
    private ISysMessageTemplateService sysMessageTemplateService;

    public boolean sendMessage(String msgType, String templateCode, Map<String, String> map, String sentTo) {
        List<SysMessageTemplate> sysSmsTemplates = this.sysMessageTemplateService.selectByCode(templateCode);
        SysMessage sysMessage = new SysMessage();
        if (sysSmsTemplates.size() > 0) {
            SysMessageTemplate sysSmsTemplate = sysSmsTemplates.get(0);
            sysMessage.setEsType(msgType);
            sysMessage.setEsReceiver(sentTo);
            String title = sysSmsTemplate.getTemplateName();
            String content = sysSmsTemplate.getTemplateContent();
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String str = "${" + entry.getKey() + "}";
                    title = title.replace(str, entry.getValue());
                    content = content.replace(str, entry.getValue());
                }
            }
            sysMessage.setEsTitle(title);
            sysMessage.setEsContent(content);
            sysMessage.setEsParam(JSONObject.toJSONString(map));
            sysMessage.setEsSendTime(new Date());
            sysMessage.setEsSendStatus(SendMsgStatusEnum.WAIT.getCode());
            sysMessage.setEsSendNum(0);
            if (this.sysMessageService.save(sysMessage)) {
                return true;
            }
        }
        return false;
    }
}

