/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config;

import com.baomidou.mybatisplus.core.parser.ISqlParserFilter;
import com.baomidou.mybatisplus.core.parser.SqlParserHelper;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantHandler;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.schema.Column;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.jeecg.config.mybatis.JeecgTenantParser;
import org.jeecg.modules.system.util.TenantContext;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@MapperScan(value={"org.jeecg.modules.**.mapper*"})
public class MybatisPlusConfig {
    public static final String tenant_field = "tenant_id";
    private static final List<String> tenantTable = new ArrayList<String>();

    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor().setLimit(-1L);
        ArrayList<JeecgTenantParser> sqlParserList = new ArrayList<JeecgTenantParser>();
        JeecgTenantParser tenantSqlParser = new JeecgTenantParser();
        tenantSqlParser.setTenantHandler(new TenantHandler(){

            public Expression getTenantId(boolean select) {
                String tenant_id = TenantContext.getTenant();
                return new LongValue(tenant_id);
            }

            public String getTenantIdColumn() {
                return MybatisPlusConfig.tenant_field;
            }

            public boolean doTableFilter(String tableName) {
                return !tenantTable.contains(tableName);
            }

            private Expression in(String ids) {
                InExpression inExpression = new InExpression();
                inExpression.setLeftExpression((Expression)new Column(this.getTenantIdColumn()));
                ExpressionList itemsList = new ExpressionList();
                ArrayList<LongValue> inValues = new ArrayList<LongValue>(2);
                for (String id : ids.split(",")) {
                    inValues.add(new LongValue(id));
                }
                itemsList.setExpressions(inValues);
                inExpression.setRightItemsList((ItemsList)itemsList);
                return inExpression;
            }
        });
        sqlParserList.add(tenantSqlParser);
        paginationInterceptor.setSqlParserList(sqlParserList);
        paginationInterceptor.setSqlParserFilter(new ISqlParserFilter(){

            public boolean doFilter(MetaObject metaObject) {
                MappedStatement ms = SqlParserHelper.getMappedStatement((MetaObject)metaObject);
                return "com.baomidou.springboot.mapper.UserMapper.selectListBySQL".equals(ms.getId());
            }
        });
        return paginationInterceptor;
    }

    static {
        tenantTable.add("jee_bug_danbiao");
    }
}

