/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.zugferd;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.Version;
import com.itextpdf.kernel.counter.EventCounterHandler;
import com.itextpdf.kernel.counter.event.IEvent;
import com.itextpdf.kernel.counter.event.IMetaInfo;
import com.itextpdf.kernel.log.CounterManager;
import com.itextpdf.kernel.log.ICounter;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfOutputIntent;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.XMPMetaFactory;
import com.itextpdf.kernel.xmp.XMPUtils;
import com.itextpdf.pdfa.PdfADocument;
import com.itextpdf.zugferd.ZugferdChecker;
import com.itextpdf.zugferd.ZugferdConformanceLevel;
import com.itextpdf.zugferd.ZugferdProperties;
import com.itextpdf.zugferd.events.PdfInvoiceEvent;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZugferdDocument
extends PdfADocument {
    private static final long serialVersionUID = 1737898087328462098L;
    private ZugferdConformanceLevel zugferdConformanceLevel;

    public ZugferdDocument(PdfWriter writer, ZugferdProperties properties) {
        block2: {
            super(writer, ZugferdDocument.getPdfAConformanceLevel(properties), properties.pdfOutputIntent, new DocumentProperties().setEventCountingMetaInfo((IMetaInfo)new ZugferdMetaInfo()));
            String licenseKeyClassName = "com.itextpdf.licensekey.LicenseKey";
            String licenseKeyProductClassName = "com.itextpdf.licensekey.LicenseKeyProduct";
            String licenseKeyFeatureClassName = "com.itextpdf.licensekey.LicenseKeyProductFeature";
            String checkLicenseKeyMethodName = "scheduledCheck";
            try {
                Class<?> licenseKeyClass = Class.forName(licenseKeyClassName);
                Class<?> licenseKeyProductClass = Class.forName(licenseKeyProductClassName);
                Class<?> licenseKeyProductFeatureClass = Class.forName(licenseKeyFeatureClassName);
                Object licenseKeyProductFeatureArray = Array.newInstance(licenseKeyProductFeatureClass, 0);
                Class[] params = new Class[]{String.class, Integer.TYPE, Integer.TYPE, licenseKeyProductFeatureArray.getClass()};
                Constructor<?> licenseKeyProductConstructor = licenseKeyProductClass.getConstructor(params);
                Object licenseKeyProductObject = licenseKeyProductConstructor.newInstance("pdfInvoice", 2, 0, licenseKeyProductFeatureArray);
                Method method = licenseKeyClass.getMethod(checkLicenseKeyMethodName, licenseKeyProductClass);
                method.invoke(null, licenseKeyProductObject);
            }
            catch (Exception e) {
                if (Version.isAGPLVersion()) break block2;
                throw new RuntimeException(e.getCause());
            }
        }
        this.zugferdConformanceLevel = ZugferdDocument.getZugferdConformanceLevel(properties);
        EventCounterHandler.getInstance().onEvent((IEvent)PdfInvoiceEvent.DOCUMENT, properties.metaInfo, ((Object)((Object)this)).getClass());
    }

    public ZugferdDocument(PdfWriter writer, ZugferdConformanceLevel zugferdConformanceLevel, PdfAConformanceLevel pdfaConformanceLevel, PdfOutputIntent outputIntent) {
        this(writer, new ZugferdProperties().setZugferdConformanceLevel(zugferdConformanceLevel).setPdfAConformanceLevel(pdfaConformanceLevel).setPdfOutputIntent(outputIntent));
    }

    public ZugferdDocument(PdfWriter writer, ZugferdConformanceLevel zugferdConformanceLevel, PdfOutputIntent outputIntent) {
        this(writer, zugferdConformanceLevel, null, outputIntent);
    }

    public ZugferdDocument(PdfWriter writer, PdfAConformanceLevel pdfaConformanceLevel, PdfOutputIntent outputIntent) {
        this(writer, null, pdfaConformanceLevel, outputIntent);
    }

    public ZugferdDocument(PdfWriter writer, PdfOutputIntent outputIntent) {
        this(writer, null, null, outputIntent);
    }

    protected void addCustomMetadataExtensions(XMPMeta xmpMeta) {
        super.addCustomMetadataExtensions(xmpMeta);
        try {
            this.addZugferdRdfDescription(xmpMeta, this.zugferdConformanceLevel);
        }
        catch (XMPException e) {
            Logger logger = LoggerFactory.getLogger(ZugferdDocument.class);
            logger.error("Exception while updating XmpMetadata", (Throwable)e);
        }
    }

    protected void setChecker(PdfAConformanceLevel conformanceLevel) {
        if (!conformanceLevel.equals(PdfAConformanceLevel.PDF_A_3B)) {
            Logger logger = LoggerFactory.getLogger(ZugferdDocument.class);
            logger.warn("ZUGFeRD document must be PDF/A-3 document. The PDF/A-3B will be used.");
            this.checker = new ZugferdChecker(PdfAConformanceLevel.PDF_A_3B);
        } else {
            this.checker = new ZugferdChecker(conformanceLevel);
        }
    }

    @Deprecated
    protected List<ICounter> getCounters() {
        return CounterManager.getInstance().getCounters(ZugferdDocument.class);
    }

    private void addZugferdRdfDescription(XMPMeta xmpMeta, ZugferdConformanceLevel zugferdConformanceLevel) throws XMPException {
        switch (zugferdConformanceLevel) {
            case ZUGFeRDBasic: 
            case ZUGFeRDComfort: 
            case ZUGFeRDExtended: {
                XMPMeta taggedExtensionMetaComfort = XMPMetaFactory.parseFromString((String)this.getZugferdExtension(zugferdConformanceLevel));
                XMPUtils.appendProperties((XMPMeta)taggedExtensionMetaComfort, (XMPMeta)xmpMeta, (boolean)true, (boolean)false);
                break;
            }
        }
    }

    private String getZugferdExtension(ZugferdConformanceLevel conformanceLevel) {
        switch (conformanceLevel) {
            case ZUGFeRDBasic: {
                return MessageFormatUtil.format((String)"    <x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n      <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n        <rdf:Description rdf:about=\"\" xmlns:zf=\"urn:ferd:pdfa:CrossIndustryDocument:invoice:1p0#\">\n          <zf:ConformanceLevel>{0}</zf:ConformanceLevel>\n          <zf:DocumentFileName>ZUGFeRD-invoice.xml</zf:DocumentFileName>\n          <zf:DocumentType>INVOICE</zf:DocumentType>\n          <zf:Version>1.0</zf:Version>\n        </rdf:Description>\n        <rdf:Description rdf:about=\"\" xmlns:pdfaExtension=\"http://www.aiim.org/pdfa/ns/extension/\" xmlns:pdfaSchema=\"http://www.aiim.org/pdfa/ns/schema#\" xmlns:pdfaProperty=\"http://www.aiim.org/pdfa/ns/property#\">\n          <pdfaExtension:schemas>\n            <rdf:Bag>\n              <rdf:li rdf:parseType=\"Resource\">\n                <pdfaSchema:schema>ZUGFeRD PDFA Extension Schema</pdfaSchema:schema>\n                <pdfaSchema:namespaceURI>urn:ferd:pdfa:CrossIndustryDocument:invoice:1p0#</pdfaSchema:namespaceURI>\n                <pdfaSchema:prefix>zf</pdfaSchema:prefix>\n                <pdfaSchema:property>\n                  <rdf:Seq>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:name>DocumentFileName</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                      <pdfaProperty:category>external</pdfaProperty:category>\n                      <pdfaProperty:description>name of the embedded XML invoice file</pdfaProperty:description>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:name>DocumentType</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                      <pdfaProperty:category>external</pdfaProperty:category>\n                      <pdfaProperty:description>INVOICE</pdfaProperty:description>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:name>Version</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                      <pdfaProperty:category>external</pdfaProperty:category>\n                      <pdfaProperty:description>The actual version of the ZUGFeRD data</pdfaProperty:description>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:name>ConformanceLevel</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                      <pdfaProperty:category>external</pdfaProperty:category>\n                      <pdfaProperty:description>The conformance level of the ZUGFeRD data</pdfaProperty:description>\n                    </rdf:li>\n                  </rdf:Seq>\n                </pdfaSchema:property>\n              </rdf:li>\n            </rdf:Bag>\n          </pdfaExtension:schemas>\n        </rdf:Description>\n      </rdf:RDF>\n    </x:xmpmeta>\n", (Object[])new Object[]{"BASIC"});
            }
            case ZUGFeRDComfort: {
                return MessageFormatUtil.format((String)"    <x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n      <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n        <rdf:Description rdf:about=\"\" xmlns:zf=\"urn:ferd:pdfa:CrossIndustryDocument:invoice:1p0#\">\n          <zf:ConformanceLevel>{0}</zf:ConformanceLevel>\n          <zf:DocumentFileName>ZUGFeRD-invoice.xml</zf:DocumentFileName>\n          <zf:DocumentType>INVOICE</zf:DocumentType>\n          <zf:Version>1.0</zf:Version>\n        </rdf:Description>\n        <rdf:Description rdf:about=\"\" xmlns:pdfaExtension=\"http://www.aiim.org/pdfa/ns/extension/\" xmlns:pdfaSchema=\"http://www.aiim.org/pdfa/ns/schema#\" xmlns:pdfaProperty=\"http://www.aiim.org/pdfa/ns/property#\">\n          <pdfaExtension:schemas>\n            <rdf:Bag>\n              <rdf:li rdf:parseType=\"Resource\">\n                <pdfaSchema:schema>ZUGFeRD PDFA Extension Schema</pdfaSchema:schema>\n                <pdfaSchema:namespaceURI>urn:ferd:pdfa:CrossIndustryDocument:invoice:1p0#</pdfaSchema:namespaceURI>\n                <pdfaSchema:prefix>zf</pdfaSchema:prefix>\n                <pdfaSchema:property>\n                  <rdf:Seq>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:name>DocumentFileName</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                      <pdfaProperty:category>external</pdfaProperty:category>\n                      <pdfaProperty:description>name of the embedded XML invoice file</pdfaProperty:description>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:name>DocumentType</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                      <pdfaProperty:category>external</pdfaProperty:category>\n                      <pdfaProperty:description>INVOICE</pdfaProperty:description>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:name>Version</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                      <pdfaProperty:category>external</pdfaProperty:category>\n                      <pdfaProperty:description>The actual version of the ZUGFeRD data</pdfaProperty:description>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:name>ConformanceLevel</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                      <pdfaProperty:category>external</pdfaProperty:category>\n                      <pdfaProperty:description>The conformance level of the ZUGFeRD data</pdfaProperty:description>\n                    </rdf:li>\n                  </rdf:Seq>\n                </pdfaSchema:property>\n              </rdf:li>\n            </rdf:Bag>\n          </pdfaExtension:schemas>\n        </rdf:Description>\n      </rdf:RDF>\n    </x:xmpmeta>\n", (Object[])new Object[]{"COMFORT"});
            }
            case ZUGFeRDExtended: {
                return MessageFormatUtil.format((String)"    <x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n      <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n        <rdf:Description rdf:about=\"\" xmlns:zf=\"urn:ferd:pdfa:CrossIndustryDocument:invoice:1p0#\">\n          <zf:ConformanceLevel>{0}</zf:ConformanceLevel>\n          <zf:DocumentFileName>ZUGFeRD-invoice.xml</zf:DocumentFileName>\n          <zf:DocumentType>INVOICE</zf:DocumentType>\n          <zf:Version>1.0</zf:Version>\n        </rdf:Description>\n        <rdf:Description rdf:about=\"\" xmlns:pdfaExtension=\"http://www.aiim.org/pdfa/ns/extension/\" xmlns:pdfaSchema=\"http://www.aiim.org/pdfa/ns/schema#\" xmlns:pdfaProperty=\"http://www.aiim.org/pdfa/ns/property#\">\n          <pdfaExtension:schemas>\n            <rdf:Bag>\n              <rdf:li rdf:parseType=\"Resource\">\n                <pdfaSchema:schema>ZUGFeRD PDFA Extension Schema</pdfaSchema:schema>\n                <pdfaSchema:namespaceURI>urn:ferd:pdfa:CrossIndustryDocument:invoice:1p0#</pdfaSchema:namespaceURI>\n                <pdfaSchema:prefix>zf</pdfaSchema:prefix>\n                <pdfaSchema:property>\n                  <rdf:Seq>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:name>DocumentFileName</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                      <pdfaProperty:category>external</pdfaProperty:category>\n                      <pdfaProperty:description>name of the embedded XML invoice file</pdfaProperty:description>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:name>DocumentType</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                      <pdfaProperty:category>external</pdfaProperty:category>\n                      <pdfaProperty:description>INVOICE</pdfaProperty:description>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:name>Version</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                      <pdfaProperty:category>external</pdfaProperty:category>\n                      <pdfaProperty:description>The actual version of the ZUGFeRD data</pdfaProperty:description>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:name>ConformanceLevel</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                      <pdfaProperty:category>external</pdfaProperty:category>\n                      <pdfaProperty:description>The conformance level of the ZUGFeRD data</pdfaProperty:description>\n                    </rdf:li>\n                  </rdf:Seq>\n                </pdfaSchema:property>\n              </rdf:li>\n            </rdf:Bag>\n          </pdfaExtension:schemas>\n        </rdf:Description>\n      </rdf:RDF>\n    </x:xmpmeta>\n", (Object[])new Object[]{"EXTENDED"});
            }
        }
        return null;
    }

    private static PdfAConformanceLevel getPdfAConformanceLevel(ZugferdProperties properties) {
        PdfAConformanceLevel local = properties.pdfaConformanceLevel;
        if (local != null) {
            return local;
        }
        LoggerFactory.getLogger(ZugferdDocument.class).warn("ZUGFeRD document must be PDF/A-3 document. The PDF/A-3B will be used.");
        return PdfAConformanceLevel.PDF_A_3B;
    }

    private static ZugferdConformanceLevel getZugferdConformanceLevel(ZugferdProperties properties) {
        ZugferdConformanceLevel local = properties.zugferdConformanceLevel;
        if (local != null) {
            return local;
        }
        LoggerFactory.getLogger(ZugferdDocument.class).warn("The ZUGFeRD profile type was not specified. The BASIC will be used.");
        return ZugferdConformanceLevel.ZUGFeRDBasic;
    }

    private static class ZugferdMetaInfo
    implements IMetaInfo {
        private static final long serialVersionUID = -2022871056576306571L;

        private ZugferdMetaInfo() {
        }
    }
}

