/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CSS;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import com.itextpdf.tool.xml.css.apply.MarginMemory;
import com.itextpdf.tool.xml.html.CssAppliers;
import java.util.Map;

public class ParagraphCssApplier {
    private final CssAppliers appliers;

    public ParagraphCssApplier(CssAppliers appliers) {
        this.appliers = appliers;
    }

    public Paragraph apply(Paragraph p, Tag t, MarginMemory configuration) {
        String value;
        CssUtils utils = CssUtils.getInstance();
        float fontSize = FontSizeTranslator.getInstance().getFontSize(t);
        if (fontSize == -1.0f) {
            fontSize = 0.0f;
        }
        float lmb = 0.0f;
        boolean hasLMB = false;
        Map<String, String> css = t.getCSS();
        for (Map.Entry<String, String> entry : css.entrySet()) {
            String key = entry.getKey();
            String value2 = entry.getValue();
            if ("margin-top".equalsIgnoreCase(key)) {
                p.setSpacingBefore(p.getSpacingBefore() + utils.calculateMarginTop(value2, fontSize, configuration));
                continue;
            }
            if ("padding-top".equalsIgnoreCase(key)) {
                p.setSpacingBefore(p.getSpacingBefore() + utils.parseValueToPt(value2, fontSize));
                p.setPaddingTop(utils.parseValueToPt(value2, fontSize));
                continue;
            }
            if ("margin-bottom".equalsIgnoreCase(key)) {
                float after = utils.parseValueToPt(value2, fontSize);
                p.setSpacingAfter(p.getSpacingAfter() + after);
                lmb = after;
                hasLMB = true;
                continue;
            }
            if ("padding-bottom".equalsIgnoreCase(key)) {
                p.setSpacingAfter(p.getSpacingAfter() + utils.parseValueToPt(value2, fontSize));
                continue;
            }
            if ("margin-left".equalsIgnoreCase(key)) {
                p.setIndentationLeft(p.getIndentationLeft() + utils.parseValueToPt(value2, fontSize));
                continue;
            }
            if ("margin-right".equalsIgnoreCase(key)) {
                p.setIndentationRight(p.getIndentationRight() + utils.parseValueToPt(value2, fontSize));
                continue;
            }
            if ("padding-left".equalsIgnoreCase(key)) {
                p.setIndentationLeft(p.getIndentationLeft() + utils.parseValueToPt(value2, fontSize));
                continue;
            }
            if ("padding-right".equalsIgnoreCase(key)) {
                p.setIndentationRight(p.getIndentationRight() + utils.parseValueToPt(value2, fontSize));
                continue;
            }
            if ("text-align".equalsIgnoreCase(key)) {
                p.setAlignment(CSS.getElementAlignment(value2));
                continue;
            }
            if ("text-indent".equalsIgnoreCase(key)) {
                p.setFirstLineIndent(utils.parseValueToPt(value2, fontSize));
                continue;
            }
            if (!"line-height".equalsIgnoreCase(key)) continue;
            if (utils.isNumericValue(value2)) {
                p.setLeading(Float.parseFloat(value2) * fontSize);
                continue;
            }
            if (utils.isRelativeValue(value2)) {
                p.setLeading(utils.parseRelativeValue(value2, fontSize));
                continue;
            }
            if (!utils.isMetricValue(value2)) continue;
            p.setLeading(utils.parsePxInCmMmPcToPt(value2));
        }
        if (t.getAttributes().containsKey("align") && (value = t.getAttributes().get("align")) != null) {
            p.setAlignment(CSS.getElementAlignment(value));
        }
        if (hasLMB) {
            configuration.setLastMarginBottom(Float.valueOf(lmb));
        }
        Font font = this.appliers.getChunkCssAplier().applyFontStyles(t);
        p.setFont(font);
        return p;
    }
}

