/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg.utils;

import com.itextpdf.tool.xml.svg.exceptions.EllipseArcException;

public class EllipseArc {
    private final float cx;
    private final float cy;
    private final float a;
    private final float b;
    private final float startAng;
    private final float extend;

    public float getCx() {
        return this.cx;
    }

    public float getCy() {
        return this.cy;
    }

    public float getA() {
        return this.a;
    }

    public float getB() {
        return this.b;
    }

    public float getStartAng() {
        return this.startAng;
    }

    public float getExtend() {
        return this.extend;
    }

    public static EllipseArc createEllipseArc(float x1, float y1, float x2, float y2, float a, float b, float sweep, float largeArc) throws EllipseArcException {
        return EllipseArc.getEllipse(x1, y1, x2, y2, a, b, (int)sweep, (int)largeArc);
    }

    private static double calculateAngle(double x, double y, double cx, double cy, double a, double b) {
        double result = Math.pow((x - cx) / a, 2.0) + Math.pow((y - cy) / b, 2.0);
        double cos = (x - cx) / a;
        double sin = (y - cy) / b;
        if (cos >= 0.0 && sin >= 0.0) {
            result = Math.toDegrees(Math.acos(cos));
        }
        if (cos >= 0.0 && sin < 0.0) {
            result = 360.0 - Math.toDegrees(Math.acos(cos));
        }
        if (cos < 0.0 && sin >= 0.0) {
            result = Math.toDegrees(Math.acos(cos));
        }
        if (cos < 0.0 && sin < 0.0) {
            result = 360.0 - Math.toDegrees(Math.acos(cos));
        }
        return result;
    }

    private static EllipseArc getEllipse(float x1, float y1, float x2, float y2, float a, float b, int sweep, int largeArc) throws EllipseArcException {
        double tussen2;
        double r1 = (double)(x1 - x2) / (-2.0 * (double)a);
        double r2 = (double)(y1 - y2) / (2.0 * (double)b);
        if (Math.sqrt(r1 * r1 + r2 * r2) > 1.0) {
            throw new EllipseArcException("the two given points are not on the ellipse");
        }
        double tussen1 = Math.asin(Math.sqrt(r1 * r1 + r2 * r2));
        EllipseArc result = EllipseArc.calculatePossibleMiddle(x1, y1, x2, y2, a, b, tussen1, tussen2 = Math.atan(r1 / r2), sweep, largeArc);
        if (result != null) {
            return result;
        }
        result = EllipseArc.calculatePossibleMiddle(x1, y1, x2, y2, a, b, Math.PI - tussen1, tussen2, sweep, largeArc);
        if (result != null) {
            return result;
        }
        result = EllipseArc.calculatePossibleMiddle(x1, y1, x2, y2, a, b, tussen1, tussen2 + Math.PI, sweep, largeArc);
        if (result != null) {
            return result;
        }
        result = EllipseArc.calculatePossibleMiddle(x1, y1, x2, y2, a, b, Math.PI - tussen1, tussen2 + Math.PI, sweep, largeArc);
        if (result != null) {
            return result;
        }
        return null;
    }

    private static EllipseArc calculatePossibleMiddle(double x1, double y1, double x2, double y2, double a, double b, double t1, double t2, int sweep, int largeArc) {
        float[] result = new float[2];
        double x0 = x1 - a * Math.cos(t1 + t2);
        double y0 = y1 - b * Math.sin(t1 + t2);
        double check = Math.pow((x2 - x0) / a, 2.0) + Math.pow((y2 - y0) / b, 2.0);
        if (check - 1.0 < 1.0E-10) {
            result[0] = (float)x0;
            result[1] = (float)y0;
            double theta1 = EllipseArc.calculateAngle(x1, y1, x0, y0, a, b);
            double theta2 = EllipseArc.calculateAngle(x2, y2, x0, y0, a, b);
            double startAngl = 0.0;
            double extend = 0.0;
            if (largeArc == 1) {
                if (theta2 > theta1 && theta2 - theta1 > 180.0 && sweep == 1) {
                    startAngl = theta1;
                    extend = theta2 - theta1;
                }
                if (theta1 > theta2 && theta1 - theta2 <= 180.0 && sweep == 1) {
                    startAngl = theta1;
                    extend = 360.0 - theta1 + theta2;
                }
                if (theta2 > theta1 && theta2 - theta1 <= 180.0 && sweep == 0) {
                    startAngl = theta2;
                    extend = 360.0 - theta2 + theta1;
                }
                if (theta1 > theta2 && theta1 - theta2 > 180.0 && sweep == 0) {
                    startAngl = theta2;
                    extend = theta1 - theta2;
                }
            } else {
                if (theta2 > theta1 && theta2 - theta1 <= 180.0 && sweep == 1) {
                    startAngl = theta1;
                    extend = theta2 - theta1;
                }
                if (theta1 > theta2 && theta1 - theta2 > 180.0 && sweep == 1) {
                    startAngl = theta1;
                    extend = 360.0 - theta1 + theta2;
                }
                if (theta2 > theta1 && theta2 - theta1 > 180.0 && sweep == 0) {
                    startAngl = theta2;
                    extend = 360.0 - theta2 + theta1;
                }
                if (theta1 > theta2 && theta1 - theta2 <= 180.0 && sweep == 0) {
                    startAngl = theta2;
                    extend = theta1 - theta2;
                }
            }
            if (startAngl >= 0.0 && extend > 0.0) {
                return new EllipseArc((float)x0, (float)y0, (float)a, (float)b, (float)startAngl, (float)extend);
            }
        }
        return null;
    }

    protected EllipseArc(float cx, float cy, float a, float b, float startAng, float extend) {
        this.cx = cx;
        this.cy = cy;
        this.a = a;
        this.b = b;
        this.startAng = startAng;
        this.extend = extend;
    }
}

