/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;

public class ImageSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    @Override
    public ISvgNodeRenderer createDeepCopy() {
        ImageSvgNodeRenderer copy = new ImageSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }

    @Override
    public Rectangle getObjectBoundingBox(SvgDrawContext context) {
        throw new UnsupportedOperationException("The renderer has no object bounding box.");
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        ResourceResolver resourceResolver = context.getResourceResolver();
        if (resourceResolver == null || this.attributesAndStyles == null) {
            return;
        }
        String uri = (String)this.attributesAndStyles.get("xlink:href");
        PdfXObject xObject = resourceResolver.retrieveImage(uri);
        if (xObject == null) {
            return;
        }
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        float x = 0.0f;
        if (this.attributesAndStyles.containsKey("x")) {
            x = CssDimensionParsingUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("x")));
        }
        float y = 0.0f;
        if (this.attributesAndStyles.containsKey("y")) {
            y = CssDimensionParsingUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("y")));
        }
        float width = 0.0f;
        if (this.attributesAndStyles.containsKey("width")) {
            width = CssDimensionParsingUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("width")));
        }
        float height = 0.0f;
        if (this.attributesAndStyles.containsKey("height")) {
            height = CssDimensionParsingUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("height")));
        }
        String preserveAspectRatio = "";
        if (this.attributesAndStyles.containsKey("preserveAspectRatio")) {
            preserveAspectRatio = (String)this.attributesAndStyles.get("preserveAspectRatio");
        } else if (this.attributesAndStyles.containsKey("preserveAspectRatio".toLowerCase())) {
            preserveAspectRatio = (String)this.attributesAndStyles.get("preserveAspectRatio".toLowerCase());
        }
        preserveAspectRatio = preserveAspectRatio.toLowerCase();
        if (!"none".equals(preserveAspectRatio) && width != 0.0f && height != 0.0f) {
            float normalizedHeight;
            float normalizedWidth;
            if (xObject.getWidth() / width > xObject.getHeight() / height) {
                normalizedWidth = width;
                normalizedHeight = xObject.getHeight() / xObject.getWidth() * width;
            } else {
                normalizedWidth = xObject.getWidth() / xObject.getHeight() * height;
                normalizedHeight = height;
            }
            switch (preserveAspectRatio.toLowerCase()) {
                case "xminymin": {
                    break;
                }
                case "xminymid": {
                    y += Math.abs(normalizedHeight - height) / 2.0f;
                    break;
                }
                case "xminymax": {
                    y += Math.abs(normalizedHeight - height);
                    break;
                }
                case "xmidymin": {
                    x += Math.abs(normalizedWidth - width) / 2.0f;
                    break;
                }
                case "xmidymax": {
                    x += Math.abs(normalizedWidth - width) / 2.0f;
                    y += Math.abs(normalizedHeight - height);
                    break;
                }
                case "xmaxymin": {
                    x += Math.abs(normalizedWidth - width);
                    break;
                }
                case "xmaxymid": {
                    x += Math.abs(normalizedWidth - width);
                    y += Math.abs(normalizedHeight - height) / 2.0f;
                    break;
                }
                case "xmaxymax": {
                    x += Math.abs(normalizedWidth - width);
                    y += Math.abs(normalizedHeight - height);
                    break;
                }
                default: {
                    x += Math.abs(normalizedWidth - width) / 2.0f;
                    y += Math.abs(normalizedHeight - height) / 2.0f;
                }
            }
            width = normalizedWidth;
            height = normalizedHeight;
        }
        float v = y + height;
        currentCanvas.addXObjectWithTransformationMatrix(xObject, width, 0.0f, 0.0f, -height, x, v);
    }
}

