/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.path.impl;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.path.impl.AbstractPathShape;
import java.util.Arrays;

public class QuadraticCurveTo
extends AbstractPathShape {
    private String[] coordinates;

    @Override
    public void draw(PdfCanvas canvas) {
        float x1 = CssUtils.parseAbsoluteLength((String)this.coordinates[0]);
        float y1 = CssUtils.parseAbsoluteLength((String)this.coordinates[1]);
        float x = CssUtils.parseAbsoluteLength((String)this.coordinates[2]);
        float y = CssUtils.parseAbsoluteLength((String)this.coordinates[3]);
        canvas.curveTo((double)x1, (double)y1, (double)x, (double)y);
    }

    @Override
    public void setCoordinates(String[] coordinates, Point startPoint) {
        if (coordinates.length == 0 || coordinates.length % 4 != 0) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"(x1 y1 x y)+ parameters are expected for quadratic curves. Got: {0}", (Object[])new Object[]{Arrays.toString(coordinates)}));
        }
        if (coordinates.length > 4) {
            throw new UnsupportedOperationException();
        }
        this.coordinates = new String[]{coordinates[0], coordinates[1], coordinates[2], coordinates[3]};
    }

    @Override
    public Point getEndingPoint() {
        return this.createPoint(this.coordinates[2], this.coordinates[3]);
    }
}

