/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.colors.WebColors;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.ClipPathSvgNodeRenderer;
import com.itextpdf.svg.utils.TransformUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractSvgNodeRenderer
implements ISvgNodeRenderer {
    private ISvgNodeRenderer parent;
    protected Map<String, String> attributesAndStyles;
    private boolean doFill = false;
    private boolean doStroke = false;
    boolean partOfClipPath;

    @Override
    public void setParent(ISvgNodeRenderer parent) {
        this.parent = parent;
    }

    @Override
    public ISvgNodeRenderer getParent() {
        return this.parent;
    }

    @Override
    public void setAttributesAndStyles(Map<String, String> attributesAndStyles) {
        this.attributesAndStyles = attributesAndStyles;
    }

    @Override
    public final void draw(SvgDrawContext context) {
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        if (this.attributesAndStyles != null) {
            AffineTransform transformation;
            String transformString = this.attributesAndStyles.get("transform");
            if (transformString != null && !transformString.isEmpty() && !(transformation = TransformUtils.parseTransform(transformString)).isIdentity()) {
                currentCanvas.concatMatrix(transformation);
            }
            if (this.attributesAndStyles.containsKey("id")) {
                context.addUsedId(this.attributesAndStyles.get("id"));
            }
        }
        if (!this.drawInClipPath(context)) {
            this.preDraw(context);
            this.doDraw(context);
            this.postDraw(context);
        }
        if (this.attributesAndStyles.containsKey("id")) {
            context.removeUsedId(this.attributesAndStyles.get("id"));
        }
    }

    private boolean drawInClipPath(SvgDrawContext context) {
        String clipPathName;
        ISvgNodeRenderer template;
        if (this.attributesAndStyles.containsKey("clip-path") && (template = context.getNamedObject(this.normalizeName(clipPathName = this.attributesAndStyles.get("clip-path")))) instanceof ClipPathSvgNodeRenderer) {
            ClipPathSvgNodeRenderer clipPath = (ClipPathSvgNodeRenderer)template.createDeepCopy();
            clipPath.setClippedRenderer(this);
            clipPath.draw(context);
            return !clipPath.getChildren().isEmpty();
        }
        return false;
    }

    private String normalizeName(String name) {
        return name.replace("url(#", "").replace(")", "").trim();
    }

    void preDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            if (!this.partOfClipPath) {
                String opacityValue;
                String strokeRawValue;
                String fillRawValue = this.getAttribute("fill");
                boolean bl = this.doFill = !"none".equalsIgnoreCase(fillRawValue);
                if (this.doFill && this.canElementFill()) {
                    Color color = ColorConstants.BLACK;
                    if (fillRawValue != null) {
                        color = WebColors.getRGBColor((String)fillRawValue);
                    }
                    currentCanvas.setFillColor(color);
                }
                if (!"none".equalsIgnoreCase(strokeRawValue = this.getAttribute("stroke"))) {
                    DeviceRgb rgbColor = WebColors.getRGBColor((String)strokeRawValue);
                    if (strokeRawValue != null && rgbColor != null) {
                        currentCanvas.setStrokeColor((Color)rgbColor);
                        String strokeWidthRawValue = this.getAttribute("stroke-width");
                        float strokeWidth = 1.0f;
                        if (strokeWidthRawValue != null) {
                            strokeWidth = CssUtils.parseAbsoluteLength((String)strokeWidthRawValue);
                        }
                        currentCanvas.setLineWidth(strokeWidth);
                        this.doStroke = true;
                    }
                }
                if ((opacityValue = this.getAttribute("fill-opacity")) != null && !"none".equalsIgnoreCase(opacityValue)) {
                    PdfExtGState gs1 = new PdfExtGState();
                    gs1.setFillOpacity(Float.valueOf(opacityValue).floatValue());
                    currentCanvas.setExtGState(gs1);
                }
            }
        }
    }

    protected boolean canElementFill() {
        return true;
    }

    public boolean canConstructViewPort() {
        return false;
    }

    AffineTransform calculateViewPortTranslation(SvgDrawContext context) {
        Rectangle viewPort = context.getCurrentViewPort();
        AffineTransform transform = AffineTransform.getTranslateInstance((double)viewPort.getX(), (double)viewPort.getY());
        return transform;
    }

    void postDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            if (this.partOfClipPath) {
                if ("evenodd".equalsIgnoreCase(this.getAttribute("clip-rule"))) {
                    currentCanvas.eoClip();
                } else {
                    currentCanvas.clip();
                }
                currentCanvas.newPath();
            } else {
                if (this.doFill && this.canElementFill()) {
                    String fillRuleRawValue = this.getAttribute("fill-rule");
                    if ("evenodd".equalsIgnoreCase(fillRuleRawValue)) {
                        if (this.doStroke) {
                            currentCanvas.eoFillStroke();
                        } else {
                            currentCanvas.eoFill();
                        }
                    } else if (this.doStroke) {
                        currentCanvas.fillStroke();
                    } else {
                        currentCanvas.fill();
                    }
                } else if (this.doStroke) {
                    currentCanvas.stroke();
                }
                currentCanvas.closePath();
            }
        }
    }

    protected abstract void doDraw(SvgDrawContext var1);

    @Override
    public String getAttribute(String key) {
        return this.attributesAndStyles.get(key);
    }

    @Override
    public void setAttribute(String key, String value) {
        if (this.attributesAndStyles == null) {
            this.attributesAndStyles = new HashMap<String, String>();
        }
        this.attributesAndStyles.put(key, value);
    }

    @Override
    public Map<String, String> getAttributeMapCopy() {
        HashMap<String, String> copy = new HashMap<String, String>();
        if (this.attributesAndStyles == null) {
            return copy;
        }
        copy.putAll(this.attributesAndStyles);
        return copy;
    }

    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractSvgNodeRenderer oar = (AbstractSvgNodeRenderer)other;
        boolean attributesAndStylesEqual = true;
        if (this.attributesAndStyles != null && oar.attributesAndStyles != null) {
            attributesAndStylesEqual &= this.attributesAndStyles.size() == oar.attributesAndStyles.size();
            for (Map.Entry<String, String> kvp : this.attributesAndStyles.entrySet()) {
                String value = oar.attributesAndStyles.get(kvp.getKey());
                if (value != null && kvp.getValue().equals(value)) continue;
                return false;
            }
        } else {
            attributesAndStylesEqual = this.attributesAndStyles == null && oar.attributesAndStyles == null;
        }
        return attributesAndStylesEqual && this.doFill == oar.doFill && this.doStroke == oar.doStroke;
    }

    public int hashCode() {
        int hash = 112;
        hash = hash * 3 + this.attributesAndStyles.hashCode();
        return hash;
    }

    protected void deepCopyAttributesAndStyles(ISvgNodeRenderer deepCopy) {
        HashMap<String, String> stylesDeepCopy = new HashMap<String, String>();
        if (this.attributesAndStyles != null) {
            stylesDeepCopy.putAll(this.attributesAndStyles);
            deepCopy.setAttributesAndStyles(stylesDeepCopy);
        }
    }

    void setPartOfClipPath(boolean value) {
        this.partOfClipPath = value;
    }
}

