/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.path.IPathShape;
import com.itextpdf.svg.renderers.path.SvgPathShapeFactory;
import com.itextpdf.svg.renderers.path.impl.CurveTo;
import com.itextpdf.svg.renderers.path.impl.LineTo;
import com.itextpdf.svg.renderers.path.impl.MoveTo;
import com.itextpdf.svg.renderers.path.impl.SmoothSCurveTo;
import com.itextpdf.svg.utils.SvgCssUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class PathSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    private static final String SEPARATOR = "";
    private static final String SPACE_CHAR = " ";
    private final String INVALID_OPERATOR_REGEX = "(\\p{L}{2,})";
    private final String SPLIT_REGEX = "(?=[\\p{L}])";
    private LineTo zOperator = null;

    @Override
    public void doDraw(SvgDrawContext context) {
        PdfCanvas canvas = context.getCurrentCanvas();
        canvas.writeLiteral("% path\n");
        for (IPathShape item : this.getShapes()) {
            item.draw(canvas);
        }
    }

    private Collection<IPathShape> getShapes() {
        Collection<String> parsedResults = this.parsePropertiesAndStyles();
        ArrayList<IPathShape> shapes = new ArrayList<IPathShape>();
        for (String parsedResult : parsedResults) {
            String[] pathProperties = parsedResult.split(SPACE_CHAR);
            if (pathProperties.length <= 0 || pathProperties[0].equals(SEPARATOR)) continue;
            if (pathProperties[0].equalsIgnoreCase("z")) {
                if (this.zOperator != null) {
                    shapes.add(this.zOperator);
                    continue;
                }
                throw new SvgProcessingException("The close path operator (Z) may not be used before a move to operation (M)");
            }
            String[] startingControlPoint = new String[2];
            IPathShape pathShape = SvgPathShapeFactory.createPathShape(pathProperties[0].toUpperCase());
            if (pathShape instanceof MoveTo) {
                this.zOperator = new LineTo();
                this.zOperator.setCoordinates(Arrays.copyOfRange(pathProperties, 1, pathProperties.length));
            }
            if (pathShape instanceof SmoothSCurveTo) {
                IPathShape previousCommand;
                IPathShape iPathShape = previousCommand = !shapes.isEmpty() ? (IPathShape)shapes.get(shapes.size() - 1) : null;
                if (previousCommand != null) {
                    Map<String, String> coordinates = previousCommand.getCoordinates();
                    if (previousCommand instanceof CurveTo || previousCommand instanceof SmoothSCurveTo) {
                        float reflectedX = 2.0f * CssUtils.parseFloat((String)coordinates.get("x")).floatValue() - CssUtils.parseFloat((String)coordinates.get("x2")).floatValue();
                        float reflectedy = 2.0f * CssUtils.parseFloat((String)coordinates.get("y")).floatValue() - CssUtils.parseFloat((String)coordinates.get("y2")).floatValue();
                        startingControlPoint[0] = SvgCssUtils.convertFloatToString(reflectedX);
                        startingControlPoint[1] = SvgCssUtils.convertFloatToString(reflectedy);
                    } else {
                        startingControlPoint[0] = coordinates.get("x");
                        startingControlPoint[1] = coordinates.get("y");
                    }
                } else {
                    startingControlPoint[0] = pathProperties[1];
                    startingControlPoint[1] = pathProperties[2];
                }
                String[] properties = PathSvgNodeRenderer.concatenate(startingControlPoint, Arrays.copyOfRange(pathProperties, 1, pathProperties.length));
                pathShape.setCoordinates(properties);
                shapes.add(pathShape);
                continue;
            }
            if (pathShape == null) continue;
            pathShape.setCoordinates(Arrays.copyOfRange(pathProperties, 1, pathProperties.length));
            shapes.add(pathShape);
        }
        return shapes;
    }

    private static String[] concatenate(String[] first, String[] second) {
        String[] arr = new String[first.length + second.length];
        System.arraycopy(first, 0, arr, 0, first.length);
        System.arraycopy(second, 0, arr, first.length, second.length);
        return arr;
    }

    private boolean containsInvalidAttributes(String attributes) {
        return attributes.split("(\\p{L}{2,})").length > 1;
    }

    private Collection<String> parsePropertiesAndStyles() {
        String[] coordinates;
        StringBuilder result = new StringBuilder();
        String attributes = (String)this.attributesAndStyles.get("d");
        if (this.containsInvalidAttributes(attributes)) {
            throw new SvgProcessingException("Invalid operators found in path data attribute: {0}").setMessageParams(new Object[]{attributes});
        }
        for (String inst : coordinates = attributes.split("(?=[\\p{L}])")) {
            if (inst.equals(SEPARATOR)) continue;
            String instTrim = inst.trim();
            String instruction = instTrim.charAt(0) + SPACE_CHAR;
            String temp = instruction + instTrim.replace(instTrim.charAt(0) + SEPARATOR, SEPARATOR).replace(",", SPACE_CHAR).trim();
            result.append(SPACE_CHAR);
            result.append(temp);
        }
        String[] resultArray = result.toString().split("(?=[\\p{L}])");
        ArrayList<String> resultList = new ArrayList<String>(Arrays.asList(resultArray));
        return resultList;
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        PathSvgNodeRenderer copy = new PathSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }
}

