/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.IBranchSvgNodeRenderer;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractBranchSvgNodeRenderer
extends AbstractSvgNodeRenderer
implements IBranchSvgNodeRenderer {
    private final List<ISvgNodeRenderer> children = new ArrayList<ISvgNodeRenderer>();

    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.getChildren().size() > 0) {
            PdfStream stream = new PdfStream();
            stream.put(PdfName.Type, (PdfObject)PdfName.XObject);
            stream.put(PdfName.Subtype, (PdfObject)PdfName.Form);
            PdfFormXObject xObject = (PdfFormXObject)PdfXObject.makeXObject((PdfStream)stream);
            PdfCanvas newCanvas = new PdfCanvas(xObject, context.getCurrentCanvas().getDocument());
            this.applyViewBox(context);
            stream.put(PdfName.BBox, (PdfObject)new PdfArray(context.getCurrentViewPort()));
            context.pushCanvas(newCanvas);
            this.applyViewport(context);
            for (ISvgNodeRenderer child : this.getChildren()) {
                newCanvas.saveState();
                child.draw(context);
                newCanvas.restoreState();
            }
            this.cleanUp(context);
            context.getCurrentCanvas().addXObject((PdfXObject)xObject, 0.0f, 0.0f);
        }
    }

    private void applyViewBox(SvgDrawContext context) {
        if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("viewbox")) {
            AffineTransform transform;
            float scaleHeight;
            String viewBoxValues = (String)this.attributesAndStyles.get("viewbox");
            List<String> valueStrings = SvgCssUtils.splitValueList(viewBoxValues);
            float[] values = new float[valueStrings.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = CssUtils.parseAbsoluteLength((String)valueStrings.get(i));
            }
            Rectangle currentViewPort = context.getCurrentViewPort();
            float scaleWidth = currentViewPort.getWidth() / values[2];
            AffineTransform scale = AffineTransform.getScaleInstance((double)scaleWidth, (double)(scaleHeight = currentViewPort.getHeight() / values[3]));
            if (!scale.isIdentity()) {
                context.getCurrentCanvas().concatMatrix(scale);
                context.getCurrentViewPort().setWidth(currentViewPort.getWidth() / scaleWidth);
                context.getCurrentViewPort().setX(currentViewPort.getX() / scaleWidth);
                context.getCurrentViewPort().setHeight(currentViewPort.getHeight() / scaleHeight);
                context.getCurrentViewPort().setY(currentViewPort.getY() / scaleHeight);
            }
            if (!(transform = this.processAspectRatio(context, values)).isIdentity()) {
                context.getCurrentCanvas().writeLiteral("% applying viewbox aspect ratio correction (not correct) \n");
            }
        }
    }

    private void applyViewport(SvgDrawContext context) {
        if (this.getParent() != null && this.getParent() instanceof AbstractSvgNodeRenderer) {
            AbstractSvgNodeRenderer parent = (AbstractSvgNodeRenderer)this.getParent();
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            currentCanvas.rectangle(context.getCurrentViewPort());
            currentCanvas.clip();
            currentCanvas.newPath();
            if (parent.canConstructViewPort()) {
                currentCanvas.concatMatrix(parent.calculateViewPortTranslation(context));
            }
        }
    }

    private AffineTransform processAspectRatio(SvgDrawContext context, float[] viewBoxValues) {
        AffineTransform transform = new AffineTransform();
        if (this.attributesAndStyles.containsKey("preserveaspectratio")) {
            Rectangle currentViewPort = context.getCurrentViewPort();
            String preserveAspectRatioValue = (String)this.attributesAndStyles.get("preserveaspectratio");
            List<String> values = SvgCssUtils.splitValueList(preserveAspectRatioValue);
            if ("defer".equalsIgnoreCase(values.get(0))) {
                values.remove(0);
            }
            String align = values.get(0);
            float x = 0.0f;
            float y = 0.0f;
            float midXBox = viewBoxValues[0] + viewBoxValues[2] / 2.0f;
            float midYBox = viewBoxValues[1] + viewBoxValues[3] / 2.0f;
            float midXPort = currentViewPort.getX() + currentViewPort.getWidth() / 2.0f;
            float midYPort = currentViewPort.getY() + currentViewPort.getHeight() / 2.0f;
            switch (align.toLowerCase()) {
                case "none": {
                    break;
                }
                case "xminymin": {
                    x = -viewBoxValues[0];
                    y = -viewBoxValues[1];
                    break;
                }
                case "xminymid": {
                    x = -viewBoxValues[0];
                    y = midYPort - midYBox;
                    break;
                }
                case "xminymax": {
                    x = -viewBoxValues[0];
                    y = currentViewPort.getHeight() - viewBoxValues[3];
                    break;
                }
                case "xmidymin": {
                    x = midXPort - midXBox;
                    y = -viewBoxValues[1];
                    break;
                }
                case "xmidymax": {
                    x = midXPort - midXBox;
                    y = currentViewPort.getHeight() - viewBoxValues[3];
                    break;
                }
                case "xmaxymin": {
                    x = currentViewPort.getWidth() - viewBoxValues[2];
                    y = -viewBoxValues[1];
                    break;
                }
                case "xmaxymid": {
                    x = currentViewPort.getWidth() - viewBoxValues[2];
                    y = midYPort - midYBox;
                    break;
                }
                case "xmaxymax": {
                    x = currentViewPort.getWidth() - viewBoxValues[2];
                    y = currentViewPort.getHeight() - viewBoxValues[3];
                    break;
                }
                default: {
                    x = midXPort - midXBox;
                    y = midYPort - midYBox;
                }
            }
            transform.translate((double)x, (double)y);
        }
        return transform;
    }

    private void cleanUp(SvgDrawContext context) {
        if (this.getParent() != null) {
            context.removeCurrentViewPort();
        }
        context.popCanvas();
    }

    @Override
    public final void addChild(ISvgNodeRenderer child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    @Override
    public final List<ISvgNodeRenderer> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    protected final void deepCopyChildren(AbstractBranchSvgNodeRenderer deepCopy) {
        for (ISvgNodeRenderer child : this.children) {
            ISvgNodeRenderer newChild = child.createDeepCopy();
            child.setParent(deepCopy);
            deepCopy.addChild(newChild);
        }
    }

    @Override
    public abstract ISvgNodeRenderer createDeepCopy();

    @Override
    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractBranchSvgNodeRenderer oabr = (AbstractBranchSvgNodeRenderer)other;
        boolean result = super.equals(oabr);
        if (result) {
            result &= this.children.equals(oabr.getChildren());
        }
        return result;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 7 + 255 + this.children.hashCode();
    }
}

