/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import com.itextpdf.svg.utils.TransformUtils;
import java.io.IOException;
import java.util.List;

public class TextSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("text_content")) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            Rectangle currentViewPort = context.getCurrentViewPort();
            currentCanvas.concatMatrix(TransformUtils.parseTransform("matrix(1 0 0 -1 0 " + SvgCssUtils.convertFloatToString(currentViewPort.getHeight()) + ")"));
            String xRawValue = (String)this.attributesAndStyles.get("x");
            String yRawValue = (String)this.attributesAndStyles.get("y");
            String fontSizeRawValue = (String)this.attributesAndStyles.get("font-size");
            List<String> xValuesList = SvgCssUtils.splitValueList(xRawValue);
            List<String> yValuesList = SvgCssUtils.splitValueList(yRawValue);
            float x = 0.0f;
            float y = 0.0f;
            float fontSize = 0.0f;
            if (fontSizeRawValue != null && !fontSizeRawValue.isEmpty()) {
                fontSize = CssUtils.parseAbsoluteLength((String)fontSizeRawValue, (String)"pt");
            }
            if (!xValuesList.isEmpty()) {
                x = Float.parseFloat(xValuesList.get(0));
            }
            if (!yValuesList.isEmpty()) {
                y = Float.parseFloat(yValuesList.get(0));
            }
            currentCanvas.beginText();
            try {
                currentCanvas.setFontAndSize(PdfFontFactory.createFont(), fontSize);
            }
            catch (IOException e) {
                throw new SvgProcessingException("The font wasn't found.", e);
            }
            currentCanvas.moveText((double)x, (double)y);
            currentCanvas.setColor(ColorConstants.BLACK, true);
            currentCanvas.showText((String)this.attributesAndStyles.get("text_content"));
            currentCanvas.endText();
        }
    }
}

