/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.colors.WebColors;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.utils.TransformUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class AbstractSvgNodeRenderer
implements ISvgNodeRenderer {
    private ISvgNodeRenderer parent;
    private final List<ISvgNodeRenderer> children = new ArrayList<ISvgNodeRenderer>();
    protected Map<String, String> attributesAndStyles;
    private boolean doFill = false;

    @Override
    public void setParent(ISvgNodeRenderer parent) {
        this.parent = parent;
    }

    @Override
    public ISvgNodeRenderer getParent() {
        return this.parent;
    }

    @Override
    public final void addChild(ISvgNodeRenderer child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    @Override
    public final List<ISvgNodeRenderer> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public void setAttributesAndStyles(Map<String, String> attributesAndStyles) {
        this.attributesAndStyles = attributesAndStyles;
    }

    @Override
    public final void draw(SvgDrawContext context) {
        String transformString;
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        if (this.attributesAndStyles != null && (transformString = this.attributesAndStyles.get("transform")) != null && !transformString.isEmpty()) {
            AffineTransform transformation = TransformUtils.parseTransform(transformString);
            currentCanvas.concatMatrix(transformation);
        }
        this.preDraw(context);
        this.doDraw(context);
        this.postDraw(context);
        if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("id")) {
            context.addNamedObject(this.attributesAndStyles.get("id"), this);
        }
    }

    void preDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            String fillRawValue = this.getAttribute("fill");
            boolean bl = this.doFill = !"none".equalsIgnoreCase(fillRawValue);
            if (this.doFill && this.canElementFill()) {
                Color color = ColorConstants.BLACK;
                if (fillRawValue != null) {
                    color = WebColors.getRGBColor((String)fillRawValue);
                }
                currentCanvas.setFillColor(color);
            }
            String strokeRawValue = this.getAttribute("stroke");
            DeviceRgb rgbColor = WebColors.getRGBColor((String)strokeRawValue);
            if (strokeRawValue != null && rgbColor != null) {
                currentCanvas.setStrokeColor((Color)rgbColor);
                String strokeWidthRawValue = this.getAttribute("stroke-width");
                float strokeWidth = 1.0f;
                if (strokeWidthRawValue != null) {
                    strokeWidth = CssUtils.parseAbsoluteLength((String)strokeWidthRawValue);
                }
                currentCanvas.setLineWidth(strokeWidth);
            }
        }
    }

    protected boolean canElementFill() {
        return true;
    }

    void postDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            if (this.doFill && this.canElementFill()) {
                String fillRuleRawValue = this.getAttribute("fill-rule");
                if ("evenodd".equalsIgnoreCase(fillRuleRawValue)) {
                    currentCanvas.eoFill();
                } else {
                    currentCanvas.fill();
                }
            }
            if (this.getAttribute("stroke") != null) {
                currentCanvas.stroke();
            }
            currentCanvas.closePath();
        }
    }

    protected abstract void doDraw(SvgDrawContext var1);

    @Override
    public String getAttribute(String key) {
        return this.attributesAndStyles.get(key);
    }

    @Override
    public void setAttribute(String key, String value) {
        this.attributesAndStyles.put(key, value);
    }
}

