/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCssUtils;
import com.itextpdf.svg.utils.TransformUtils;
import java.util.List;

public abstract class AbstractBranchSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.getChildren().size() > 0) {
            PdfStream stream = new PdfStream();
            stream.put(PdfName.Type, (PdfObject)PdfName.XObject);
            stream.put(PdfName.Subtype, (PdfObject)PdfName.Form);
            stream.put(PdfName.BBox, (PdfObject)new PdfArray(context.getCurrentViewPort()));
            PdfFormXObject xObject = (PdfFormXObject)PdfXObject.makeXObject((PdfStream)stream);
            PdfCanvas newCanvas = new PdfCanvas(xObject, context.getCurrentCanvas().getDocument());
            this.applyViewBox(context);
            context.pushCanvas(newCanvas);
            this.applyViewport(context);
            for (ISvgNodeRenderer child : this.getChildren()) {
                newCanvas.saveState();
                child.draw(context);
                newCanvas.restoreState();
            }
            this.cleanUp(context);
            AffineTransform transformation = new AffineTransform();
            if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("transform")) {
                transformation = TransformUtils.parseTransform((String)this.attributesAndStyles.get("transform"));
            }
            float[] matrixValues = new float[6];
            transformation.getMatrix(matrixValues);
            context.getCurrentCanvas().addXObject((PdfXObject)xObject, matrixValues[0], matrixValues[1], matrixValues[2], matrixValues[3], matrixValues[4], matrixValues[5]);
            if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("id")) {
                context.addNamedObject((String)this.attributesAndStyles.get("id"), xObject);
            }
        }
    }

    private void applyViewBox(SvgDrawContext context) {
        if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("viewbox")) {
            String viewBoxValues = (String)this.attributesAndStyles.get("viewbox");
            List<String> valueStrings = SvgCssUtils.splitValueList(viewBoxValues);
            float[] values = new float[valueStrings.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = CssUtils.parseAbsoluteLength((String)valueStrings.get(i));
            }
            Rectangle currentViewPort = context.getCurrentViewPort();
            float scaleWidth = currentViewPort.getWidth() / values[2];
            float scaleHeight = currentViewPort.getHeight() / values[3];
            AffineTransform scale = AffineTransform.getScaleInstance((double)scaleWidth, (double)scaleHeight);
            context.getCurrentCanvas().concatMatrix(scale);
            AffineTransform transform = this.processAspectRatio(context, values);
            context.getCurrentCanvas().concatMatrix(transform);
        }
    }

    private void applyViewport(SvgDrawContext context) {
        if (this.getParent() != null) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            currentCanvas.rectangle(context.getCurrentViewPort());
            currentCanvas.clip();
            currentCanvas.newPath();
        }
    }

    private AffineTransform processAspectRatio(SvgDrawContext context, float[] viewBoxValues) {
        AffineTransform transform = new AffineTransform();
        if (this.attributesAndStyles.containsKey("preserveaspectratio")) {
            Rectangle currentViewPort = context.getCurrentViewPort();
            String preserveAspectRatioValue = (String)this.attributesAndStyles.get("preserveaspectratio");
            List<String> values = SvgCssUtils.splitValueList(preserveAspectRatioValue);
            if ("defer".equalsIgnoreCase(values.get(0))) {
                values.remove(0);
            }
            String align = values.get(0);
            float x = 0.0f;
            float y = 0.0f;
            float midXBox = viewBoxValues[0] + viewBoxValues[2] / 2.0f;
            float midYBox = viewBoxValues[1] + viewBoxValues[3] / 2.0f;
            float midXPort = currentViewPort.getX() + currentViewPort.getWidth() / 2.0f;
            float midYPort = currentViewPort.getY() + currentViewPort.getHeight() / 2.0f;
            switch (align.toLowerCase()) {
                case "none": {
                    break;
                }
                case "xminymin": {
                    x = -viewBoxValues[0];
                    y = -viewBoxValues[1];
                    break;
                }
                case "xminymid": {
                    x = -viewBoxValues[0];
                    y = midYPort - midYBox;
                    break;
                }
                case "xminymax": {
                    x = -viewBoxValues[0];
                    y = currentViewPort.getHeight() - viewBoxValues[3];
                    break;
                }
                case "xmidymin": {
                    x = midXPort - midXBox;
                    y = -viewBoxValues[1];
                    break;
                }
                case "xmidymax": {
                    x = midXPort - midXBox;
                    y = currentViewPort.getHeight() - viewBoxValues[3];
                    break;
                }
                case "xmaxymin": {
                    x = currentViewPort.getWidth() - viewBoxValues[2];
                    y = -viewBoxValues[1];
                    break;
                }
                case "xmaxymid": {
                    x = currentViewPort.getWidth() - viewBoxValues[2];
                    y = midYPort - midYBox;
                    break;
                }
                case "xmaxymax": {
                    x = currentViewPort.getWidth() - viewBoxValues[2];
                    y = currentViewPort.getHeight() - viewBoxValues[3];
                    break;
                }
                default: {
                    x = midXPort - midXBox;
                    y = midYPort - midYBox;
                }
            }
            transform.translate((double)x, (double)y);
        }
        return transform;
    }

    private void cleanUp(SvgDrawContext context) {
        if (this.getParent() != null) {
            context.removeCurrentViewPort();
        }
        context.popCanvas();
    }
}

