/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.css.impl;

import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.CssStyleSheet;
import com.itextpdf.styledxmlparser.css.ICssContext;
import com.itextpdf.styledxmlparser.css.ICssResolver;
import com.itextpdf.styledxmlparser.css.media.MediaDeviceDescription;
import com.itextpdf.styledxmlparser.css.parse.CssRuleSetParser;
import com.itextpdf.styledxmlparser.css.parse.CssStyleSheetParser;
import com.itextpdf.styledxmlparser.node.IAttribute;
import com.itextpdf.styledxmlparser.node.IDataNode;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import com.itextpdf.styledxmlparser.node.ITextNode;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DefaultSvgStyleResolver
implements ICssResolver {
    private CssStyleSheet internalStyleSheet = new CssStyleSheet();

    public DefaultSvgStyleResolver(INode rootNode) {
        this.collectCssDeclarations(rootNode);
    }

    public Map<String, String> resolveStyles(INode node, ICssContext context) {
        HashMap<String, String> styles = new HashMap<String, String>();
        List styleSheetDeclarations = this.internalStyleSheet.getCssDeclarations(node, MediaDeviceDescription.createDefault());
        for (CssDeclaration ssd : styleSheetDeclarations) {
            styles.put(ssd.getProperty(), ssd.getExpression());
        }
        if (node instanceof IElementNode) {
            IElementNode eNode = (IElementNode)node;
            for (IAttribute attr : eNode.getAttributes()) {
                this.processAttribute(attr, styles);
            }
        }
        return styles;
    }

    private void processAttribute(IAttribute attr, Map<String, String> styles) {
        if (attr.getKey().equals("style")) {
            Map<String, String> parsed = this.parseStylesFromStyleAttribute(attr.getValue());
            for (Map.Entry<String, String> style : parsed.entrySet()) {
                styles.put(style.getKey(), style.getValue());
            }
        } else {
            styles.put(attr.getKey(), attr.getValue());
        }
    }

    private Map<String, String> parseStylesFromStyleAttribute(String style) {
        HashMap<String, String> parsed = new HashMap<String, String>();
        List declarations = CssRuleSetParser.parsePropertyDeclarations((String)style);
        for (CssDeclaration declaration : declarations) {
            parsed.put(declaration.getProperty(), declaration.getExpression());
        }
        return parsed;
    }

    private void collectCssDeclarations(INode rootNode) {
        this.internalStyleSheet = new CssStyleSheet();
        LinkedList<INode> q = new LinkedList<INode>();
        if (rootNode != null) {
            q.add(rootNode);
        }
        while (!q.isEmpty()) {
            IElementNode headChildElement;
            INode currentNode = (INode)q.getFirst();
            q.removeFirst();
            if (currentNode instanceof IElementNode && (headChildElement = (IElementNode)currentNode).name().equals("style") && currentNode.childNodes().size() > 0 && (currentNode.childNodes().get(0) instanceof IDataNode || currentNode.childNodes().get(0) instanceof ITextNode)) {
                String styleData = currentNode.childNodes().get(0) instanceof IDataNode ? ((IDataNode)currentNode.childNodes().get(0)).getWholeData() : ((ITextNode)currentNode.childNodes().get(0)).wholeText();
                CssStyleSheet styleSheet = CssStyleSheetParser.parse((String)styleData);
                this.internalStyleSheet.appendCssStyleSheet(styleSheet);
            }
            for (INode child : currentNode.childNodes()) {
                if (!(child instanceof IElementNode)) continue;
                q.add(child);
            }
        }
    }
}

