/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.path.impl;

import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.path.IPathShape;
import com.itextpdf.svg.renderers.path.impl.DefaultOperatorConverter;
import com.itextpdf.svg.renderers.path.impl.IOperatorConverter;
import java.util.Map;

public abstract class AbstractPathShape
implements IPathShape {
    protected Map<String, String> properties;
    protected boolean relative;
    protected final IOperatorConverter copier;
    protected String[] coordinates;

    public AbstractPathShape() {
        this(false);
    }

    public AbstractPathShape(boolean relative) {
        this(relative, new DefaultOperatorConverter());
    }

    public AbstractPathShape(boolean relative, IOperatorConverter copier) {
        this.relative = relative;
        this.copier = copier;
    }

    @Override
    public boolean isRelative() {
        return this.relative;
    }

    protected Point createPoint(String coordX, String coordY) {
        return new Point(CssUtils.parseDouble((String)coordX).doubleValue(), CssUtils.parseDouble((String)coordY).doubleValue());
    }

    @Override
    public Point getEndingPoint() {
        return this.createPoint(this.coordinates[this.coordinates.length - 2], this.coordinates[this.coordinates.length - 1]);
    }

    public Rectangle getPathShapeRectangle(Point lastPoint) {
        return new Rectangle((float)CssUtils.convertPxToPts((double)this.getEndingPoint().getX()), (float)CssUtils.convertPxToPts((double)this.getEndingPoint().getY()), 0.0f, 0.0f);
    }
}

