/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.factories;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.factories.DefaultSvgNodeRendererMapper;
import com.itextpdf.svg.renderers.factories.ISvgNodeRendererFactory;
import com.itextpdf.svg.renderers.factories.ISvgNodeRendererMapper;
import com.itextpdf.svg.renderers.impl.NoDrawOperationSvgNodeRenderer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSvgNodeRendererFactory
implements ISvgNodeRendererFactory {
    private Map<String, Class<? extends ISvgNodeRenderer>> rendererMap = new HashMap<String, Class<? extends ISvgNodeRenderer>>();
    private Collection<String> ignoredTags = new HashSet<String>();

    public DefaultSvgNodeRendererFactory() {
        this(new DefaultSvgNodeRendererMapper());
    }

    public DefaultSvgNodeRendererFactory(ISvgNodeRendererMapper mapper) {
        if (mapper != null) {
            this.rendererMap.putAll(mapper.getMapping());
            this.ignoredTags.addAll(mapper.getIgnoredTags());
        } else {
            DefaultSvgNodeRendererMapper defaultMapper = new DefaultSvgNodeRendererMapper();
            this.rendererMap.putAll(defaultMapper.getMapping());
            this.ignoredTags.addAll(defaultMapper.getIgnoredTags());
        }
    }

    @Override
    public ISvgNodeRenderer createSvgNodeRendererForTag(IElementNode tag, ISvgNodeRenderer parent) {
        ISvgNodeRenderer result;
        if (tag == null) {
            throw new SvgProcessingException("Tag parameter must not be null");
        }
        try {
            Class<? extends ISvgNodeRenderer> clazz = this.rendererMap.get(tag.name());
            if (clazz == null) {
                Logger logger = LoggerFactory.getLogger(this.getClass());
                logger.warn(MessageFormatUtil.format((String)"Could not find implementation for tag {0}", (Object[])new Object[]{tag.name()}));
                return null;
            }
            result = this.rendererMap.get(tag.name()).newInstance();
        }
        catch (ReflectiveOperationException ex) {
            throw new SvgProcessingException("Could not instantiate Renderer for tag {0}", ex).setMessageParams(new Object[]{tag.name()});
        }
        if (parent != null && !(parent instanceof NoDrawOperationSvgNodeRenderer)) {
            result.setParent(parent);
        }
        return result;
    }

    @Override
    public boolean isTagIgnored(IElementNode tag) {
        return this.ignoredTags.contains(tag.name());
    }
}

