/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.util;

import com.itextpdf.io.util.DecimalFormatUtil;
import com.itextpdf.styledxmlparser.css.resolve.CssPropertyMerger;
import com.itextpdf.styledxmlparser.css.resolve.IStyleInheritance;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class StyleUtil {
    private static final List<String> fontSizeDependentPercentage = new ArrayList<String>(2);

    private StyleUtil() {
    }

    public static Map<String, String> mergeParentStyleDeclaration(Map<String, String> styles, String styleProperty, String parentPropValue, String parentFontSizeString, Set<IStyleInheritance> inheritanceRules) {
        String childPropValue = styles.get(styleProperty);
        if (childPropValue == null && StyleUtil.checkInheritance(styleProperty, inheritanceRules) || "inherit".equals(childPropValue)) {
            if (StyleUtil.valueIsOfMeasurement(parentPropValue, "em") || StyleUtil.valueIsOfMeasurement(parentPropValue, "ex") || StyleUtil.valueIsOfMeasurement(parentPropValue, "%") && fontSizeDependentPercentage.contains(styleProperty)) {
                float absoluteParentFontSize = CssDimensionParsingUtils.parseAbsoluteLength(parentFontSizeString);
                styles.put(styleProperty, DecimalFormatUtil.formatNumber((double)CssDimensionParsingUtils.parseRelativeValue(parentPropValue, absoluteParentFontSize), (String)"0.####") + "pt");
            } else {
                styles.put(styleProperty, parentPropValue);
            }
        } else if ("text-decoration-line".equals(styleProperty) && !"inline-block".equals(styles.get("display"))) {
            styles.put(styleProperty, CssPropertyMerger.mergeTextDecoration(childPropValue, parentPropValue));
        }
        return styles;
    }

    private static boolean checkInheritance(String styleProperty, Set<IStyleInheritance> inheritanceRules) {
        for (IStyleInheritance inheritanceRule : inheritanceRules) {
            if (!inheritanceRule.isInheritable(styleProperty)) continue;
            return true;
        }
        return false;
    }

    private static boolean valueIsOfMeasurement(String value, String measurement) {
        if (value == null) {
            return false;
        }
        return value.endsWith(measurement) && CssTypesValidationUtils.isNumber(value.substring(0, value.length() - measurement.length()).trim());
    }

    static {
        fontSizeDependentPercentage.add("font-size");
        fontSizeDependentPercentage.add("line-height");
    }
}

