/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.font;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.layout.font.FontFamilySplitter;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CssFontFace {
    private final String alias;
    private final List<CssFontFaceSrc> sources;

    public static CssFontFace create(List<CssDeclaration> properties) {
        String fontFamily = null;
        String srcs = null;
        for (CssDeclaration descriptor : properties) {
            if ("font-family".equals(descriptor.getProperty())) {
                fontFamily = FontFamilySplitter.removeQuotes((String)descriptor.getExpression());
                continue;
            }
            if (!"src".equals(descriptor.getProperty())) continue;
            srcs = descriptor.getExpression();
        }
        if (fontFamily == null || srcs == null) {
            return null;
        }
        ArrayList<CssFontFaceSrc> sources = new ArrayList<CssFontFaceSrc>();
        for (String src : CssFontFace.splitSourcesSequence(srcs)) {
            CssFontFaceSrc source = CssFontFaceSrc.create(src.trim());
            if (source == null) continue;
            sources.add(source);
        }
        if (sources.size() > 0) {
            return new CssFontFace(fontFamily, sources);
        }
        return null;
    }

    public static String[] splitSourcesSequence(String src) {
        ArrayList<String> list = new ArrayList<String>();
        int indexToStart = 0;
        while (indexToStart < src.length()) {
            int indexToCut;
            int indexUnescapedBracket;
            int indexUnescapedOpeningQuoteMark = Math.min(CssUtils.findNextUnescapedChar(src, '\'', indexToStart) >= 0 ? CssUtils.findNextUnescapedChar(src, '\'', indexToStart) : Integer.MAX_VALUE, CssUtils.findNextUnescapedChar(src, '\"', indexToStart) >= 0 ? CssUtils.findNextUnescapedChar(src, '\"', indexToStart) : Integer.MAX_VALUE);
            if (indexUnescapedOpeningQuoteMark < (indexUnescapedBracket = CssUtils.findNextUnescapedChar(src, ')', indexToStart))) {
                indexToCut = CssUtils.findNextUnescapedChar(src, src.charAt(indexUnescapedOpeningQuoteMark), indexUnescapedOpeningQuoteMark + 1);
                if (indexToCut == -1) {
                    indexToCut = src.length();
                }
            } else {
                indexToCut = indexUnescapedBracket;
            }
            while (indexToCut < src.length() && src.charAt(indexToCut) != ',') {
                ++indexToCut;
            }
            list.add(src.substring(indexToStart, indexToCut).trim());
            indexToStart = ++indexToCut;
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public static boolean isSupportedFontFormat(FontFormat format) {
        switch (format) {
            case None: 
            case TrueType: 
            case OpenType: 
            case WOFF: 
            case WOFF2: {
                return true;
            }
        }
        return false;
    }

    public String getFontFamily() {
        return this.alias;
    }

    public List<CssFontFaceSrc> getSources() {
        return new ArrayList<CssFontFaceSrc>(this.sources);
    }

    private CssFontFace(String alias, List<CssFontFaceSrc> sources) {
        this.alias = alias;
        this.sources = new ArrayList<CssFontFaceSrc>(sources);
    }

    public static class CssFontFaceSrc {
        public static final Pattern UrlPattern = Pattern.compile("^((local)|(url))\\((('[^']*')|(\"[^\"]*\")|([^'\"\\)]*))\\)( format\\((('[^']*')|(\"[^\"]*\")|([^'\"\\)]*))\\))?$");
        public static final int TypeGroup = 1;
        public static final int UrlGroup = 4;
        public static final int FormatGroup = 9;
        final FontFormat format;
        final String src;
        final boolean isLocal;

        public FontFormat getFormat() {
            return this.format;
        }

        public String getSrc() {
            return this.src;
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        public String toString() {
            return MessageFormatUtil.format((String)"{0}({1}){2}", (Object[])new Object[]{this.isLocal ? "local" : "url", this.src, this.format != FontFormat.None ? MessageFormatUtil.format((String)" format({0})", (Object[])new Object[]{this.format}) : ""});
        }

        public static CssFontFaceSrc create(String src) {
            Matcher m = UrlPattern.matcher(src);
            if (!m.matches()) {
                return null;
            }
            return new CssFontFaceSrc(CssFontFaceSrc.unquote(m.group(4)), "local".equals(m.group(1)), CssFontFaceSrc.parseFormat(m.group(9)));
        }

        public static FontFormat parseFormat(String formatStr) {
            if (formatStr != null && formatStr.length() > 0) {
                switch (CssFontFaceSrc.unquote(formatStr).toLowerCase()) {
                    case "truetype": {
                        return FontFormat.TrueType;
                    }
                    case "opentype": {
                        return FontFormat.OpenType;
                    }
                    case "woff": {
                        return FontFormat.WOFF;
                    }
                    case "woff2": {
                        return FontFormat.WOFF2;
                    }
                    case "embedded-opentype": {
                        return FontFormat.EOT;
                    }
                    case "svg": {
                        return FontFormat.SVG;
                    }
                }
            }
            return FontFormat.None;
        }

        public static String unquote(String quotedString) {
            if (quotedString.charAt(0) == '\'' || quotedString.charAt(0) == '\"') {
                return quotedString.substring(1, quotedString.length() - 1);
            }
            return quotedString;
        }

        private CssFontFaceSrc(String src, boolean isLocal, FontFormat format) {
            this.format = format;
            this.src = src;
            this.isLocal = isLocal;
        }
    }

    public static enum FontFormat {
        None,
        TrueType,
        OpenType,
        WOFF,
        WOFF2,
        EOT,
        SVG;

    }
}

