/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.report.xml;

import com.itextpdf.commons.actions.IEvent;
import com.itextpdf.commons.actions.IEventHandler;
import com.itextpdf.signatures.cms.CMSContainer;
import com.itextpdf.signatures.validation.events.IValidationEvent;
import com.itextpdf.signatures.validation.events.ProofOfExistenceFoundEvent;
import com.itextpdf.signatures.validation.events.SignatureValidationFailureEvent;
import com.itextpdf.signatures.validation.events.StartSignatureValidationEvent;
import com.itextpdf.signatures.validation.report.xml.POEValidationReport;
import com.itextpdf.signatures.validation.report.xml.PadesValidationReport;
import com.itextpdf.signatures.validation.report.xml.SignatureValidationReport;
import com.itextpdf.signatures.validation.report.xml.SignatureValidationStatus;
import com.itextpdf.signatures.validation.report.xml.SubValidationReport;
import com.itextpdf.signatures.validation.report.xml.ValidationObjects;
import java.util.Date;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlReportAggregator
implements IEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlReportAggregator.class);
    private final ValidationObjects validationObjects = new ValidationObjects();
    private final PadesValidationReport report = new PadesValidationReport(this.validationObjects);
    private final Stack<SubValidationReport> validationReportStack = new Stack();

    public PadesValidationReport getReport() {
        return this.report;
    }

    public void onEvent(IEvent rawEvent) {
        IValidationEvent event;
        if (rawEvent instanceof IValidationEvent && (event = (IValidationEvent)rawEvent).getEventType() != null) {
            switch (event.getEventType()) {
                case PROOF_OF_EXISTENCE_FOUND: {
                    ProofOfExistenceFoundEvent poe = (ProofOfExistenceFoundEvent)event;
                    this.proofOfExistenceFound(poe.getTimeStampSignature(), poe.isDocumentTimestamp());
                    break;
                }
                case SIGNATURE_VALIDATION_STARTED: {
                    StartSignatureValidationEvent start = (StartSignatureValidationEvent)event;
                    this.startSignatureValidation(start.getPdfSignature().getContents().getValueBytes(), start.getSignatureName(), start.getSigningDate());
                    break;
                }
                case SIGNATURE_VALIDATION_SUCCESS: {
                    this.reportSignatureValidationSuccess();
                    break;
                }
                case SIGNATURE_VALIDATION_FAILURE: {
                    SignatureValidationFailureEvent failure = (SignatureValidationFailureEvent)event;
                    this.reportSignatureValidationFailure(failure.isInconclusive(), failure.getReason());
                    break;
                }
                case CERTIFICATE_CHAIN_SUCCESS: {
                    break;
                }
                case CERTIFICATE_CHAIN_FAILURE: {
                    break;
                }
                case CRL_VALIDATION_SUCCESS: {
                    break;
                }
                case CRL_VALIDATION_FAILURE: {
                    break;
                }
                case OCSP_VALIDATION_SUCCESS: {
                    break;
                }
            }
        }
    }

    private void startSignatureValidation(byte[] signature, String name, Date signingDate) {
        try {
            SignatureValidationReport currentSignatureValidationReport = new SignatureValidationReport(this.validationObjects, new CMSContainer(signature), name, signingDate);
            this.validationReportStack.push(currentSignatureValidationReport);
            this.report.addSignatureValidationReport(currentSignatureValidationReport);
        }
        catch (Exception e) {
            LOGGER.error("Unable to parse signature container.", (Throwable)e);
            throw new IllegalArgumentException("Signature is not parsable", e);
        }
    }

    private void proofOfExistenceFound(byte[] timeStampSignature, boolean document) {
        try {
            POEValidationReport currentValidationReport = new POEValidationReport(this.validationObjects, new CMSContainer(timeStampSignature), document);
            this.validationReportStack.push(currentValidationReport);
            this.validationObjects.addObject(currentValidationReport);
        }
        catch (Exception e) {
            LOGGER.error("Unable to parse timestamp signature container.", (Throwable)e);
            throw new IllegalArgumentException("Timestamp signature is not parsable", e);
        }
    }

    private void reportSignatureValidationSuccess() {
        SignatureValidationStatus status = new SignatureValidationStatus();
        status.setMainIndication(SignatureValidationStatus.MainIndication.TOTAL_PASSED);
        SubValidationReport currentValidationReport = this.validationReportStack.pop();
        currentValidationReport.setSignatureValidationStatus(status);
    }

    private void reportSignatureValidationFailure(boolean isInconclusive, String reason) {
        SignatureValidationStatus status = new SignatureValidationStatus();
        if (isInconclusive) {
            status.setMainIndication(SignatureValidationStatus.MainIndication.INDETERMINATE);
        } else {
            status.setMainIndication(SignatureValidationStatus.MainIndication.TOTAL_FAILED);
        }
        status.addMessage(reason, SignatureValidationStatus.MessageType.ERROR);
        SubValidationReport currentValidationReport = this.validationReportStack.pop();
        currentValidationReport.setSignatureValidationStatus(status);
    }
}

