/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.report.xml;

import com.itextpdf.commons.actions.IEvent;
import com.itextpdf.commons.actions.IEventHandler;
import com.itextpdf.signatures.validation.events.IValidationEvent;
import com.itextpdf.signatures.validation.events.ProofOfExistenceFoundEvent;
import com.itextpdf.signatures.validation.events.SignatureValidationFailureEvent;
import com.itextpdf.signatures.validation.events.StartSignatureValidationEvent;
import com.itextpdf.signatures.validation.report.xml.AdESReportAggregator;

public class EventsToAdESReportAggratorConvertor
implements IEventHandler {
    private final AdESReportAggregator target;

    public EventsToAdESReportAggratorConvertor(AdESReportAggregator target) {
        this.target = target;
    }

    public void onEvent(IEvent rawEvent) {
        IValidationEvent event;
        if (rawEvent instanceof IValidationEvent && (event = (IValidationEvent)rawEvent).getEventType() != null) {
            switch (event.getEventType()) {
                case SIGNATURE_VALIDATION_STARTED: {
                    StartSignatureValidationEvent startEvent = (StartSignatureValidationEvent)event;
                    this.target.startSignatureValidation(startEvent.getPdfSignature().getContents().getValueBytes(), startEvent.getSignatureName(), startEvent.getSigningDate());
                    break;
                }
                case PROOF_OF_EXISTENCE_FOUND: {
                    ProofOfExistenceFoundEvent peoEvent = (ProofOfExistenceFoundEvent)event;
                    this.target.proofOfExistenceFound(peoEvent.getTimeStampSignature(), peoEvent.isDocumentTimestamp());
                    break;
                }
                case SIGNATURE_VALIDATION_SUCCESS: {
                    this.target.reportSignatureValidationSuccess();
                    break;
                }
                case SIGNATURE_VALIDATION_FAILURE: {
                    SignatureValidationFailureEvent failureEvent = (SignatureValidationFailureEvent)event;
                    this.target.reportSignatureValidationFailure(failureEvent.isInconclusive(), failureEvent.getReason());
                }
            }
        }
    }
}

