/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.report.pades;

import com.itextpdf.signatures.validation.report.pades.AbstractPadesLevelRequirements;
import com.itextpdf.signatures.validation.report.pades.PAdESLevel;
import java.util.HashMap;
import java.util.Map;

class SignatureRequirements
extends AbstractPadesLevelRequirements {
    private static final Map<PAdESLevel, AbstractPadesLevelRequirements.LevelChecks> CHECKS = new HashMap<PAdESLevel, AbstractPadesLevelRequirements.LevelChecks>();

    public SignatureRequirements(String name) {
        super(name);
    }

    @Override
    protected Map<PAdESLevel, AbstractPadesLevelRequirements.LevelChecks> getChecks() {
        return CHECKS;
    }

    static {
        AbstractPadesLevelRequirements.LevelChecks bbChecks = new AbstractPadesLevelRequirements.LevelChecks();
        CHECKS.put(PAdESLevel.B_B, bbChecks);
        bbChecks.shalls.add(new AbstractPadesLevelRequirements.CheckAndMessage(r -> r.signatureDictionaryEntrySubFilterValueIsETSICadesDetached, "SubFilter entry value is not ETSI.CAdES.detached"));
        bbChecks.shalls.add(new AbstractPadesLevelRequirements.CheckAndMessage(r -> r.contentTypeValueIsIdData, "CMS content-type entry value is not id-data"));
        bbChecks.shalls.add(new AbstractPadesLevelRequirements.CheckAndMessage(r -> !r.cmsSigningTimeAttributePresent, "Claimed time of signing shall not be included in the CMS"));
        bbChecks.shalls.add(new AbstractPadesLevelRequirements.CheckAndMessage(r -> r.dictionaryEntryMPresent, "Dictionary entry M is missing"));
        bbChecks.shalls.add(new AbstractPadesLevelRequirements.CheckAndMessage(r -> r.dictionaryEntryMHasCorrectFormat, "Dictionary entry M is not in the correct format"));
        AbstractPadesLevelRequirements.LevelChecks btChecks = new AbstractPadesLevelRequirements.LevelChecks();
        CHECKS.put(PAdESLevel.B_T, btChecks);
        btChecks.shalls.add(new AbstractPadesLevelRequirements.CheckAndMessage(r -> r.poeSignaturePresent || r.documentTimestampPresent, "There must be a signature or document timestamp available"));
        AbstractPadesLevelRequirements.LevelChecks bltChecks = new AbstractPadesLevelRequirements.LevelChecks();
        CHECKS.put(PAdESLevel.B_LT, bltChecks);
        bltChecks.shalls.add(new AbstractPadesLevelRequirements.CheckAndMessage(r -> r.isDSSPresent, "A DSS dictionary is missing"));
        bltChecks.shalls.add(SignatureRequirements.createRevocationDssUsageCheck());
        bltChecks.shalls.add(SignatureRequirements.createCertificateExternalRetrievalCheck());
        bltChecks.shoulds.add(SignatureRequirements.createCertificatesDssUsageCheck());
        AbstractPadesLevelRequirements.LevelChecks bltaChecks = new AbstractPadesLevelRequirements.LevelChecks();
        CHECKS.put(PAdESLevel.B_LTA, bltaChecks);
        bltaChecks.shalls.add(new AbstractPadesLevelRequirements.CheckAndMessage(r -> r.documentTimestampPresent, "A document timestamp is missing"));
        bltaChecks.shalls.add(new AbstractPadesLevelRequirements.CheckAndMessage(r -> r.poeDssPresent, "The DSS entry is not covered by a document timestamp"));
        bltaChecks.shalls.add(SignatureRequirements.createRevocationDssPoECoverage());
    }
}

