/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.report.pades;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.actions.IEvent;
import com.itextpdf.commons.actions.IEventHandler;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.kernel.pdf.PdfDate;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.signatures.PdfSignature;
import com.itextpdf.signatures.cms.CMSContainer;
import com.itextpdf.signatures.validation.events.AbstractCertificateChainEvent;
import com.itextpdf.signatures.validation.events.AlgorithmUsageEvent;
import com.itextpdf.signatures.validation.events.IValidationEvent;
import com.itextpdf.signatures.validation.events.ProofOfExistenceFoundEvent;
import com.itextpdf.signatures.validation.events.StartSignatureValidationEvent;
import com.itextpdf.signatures.validation.report.pades.AbstractPadesLevelRequirements;
import com.itextpdf.signatures.validation.report.pades.DocumentPAdESLevelReport;
import com.itextpdf.signatures.validation.report.pades.DocumentTimestampRequirements;
import com.itextpdf.signatures.validation.report.pades.PAdESLevelReport;
import com.itextpdf.signatures.validation.report.pades.SignatureRequirements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PAdESLevelReportGenerator
implements IEventHandler {
    private static final IBouncyCastleFactory BC_FACTORY = BouncyCastleFactoryCreator.getFactory();
    private final List<AbstractPadesLevelRequirements> signatureInfos = new ArrayList<AbstractPadesLevelRequirements>();
    private int timestampCount = 0;
    private boolean poeFound;
    private boolean dssFound;
    private boolean dssHasPoe;
    private AbstractPadesLevelRequirements currentSignature;
    private final List<PAdESLevelReport> timestampReports = new ArrayList<PAdESLevelReport>();

    public DocumentPAdESLevelReport getReport() {
        DocumentPAdESLevelReport result = new DocumentPAdESLevelReport();
        for (AbstractPadesLevelRequirements entry : this.signatureInfos) {
            if (entry instanceof SignatureRequirements) {
                PAdESLevelReport report = new PAdESLevelReport(entry, this.timestampReports);
                result.addPAdESReport(report);
                continue;
            }
            this.timestampReports.add(new PAdESLevelReport(entry, Collections.emptyList()));
        }
        return result;
    }

    public void onEvent(IEvent rawEvent) {
        IValidationEvent event;
        if (rawEvent instanceof IValidationEvent && (event = (IValidationEvent)rawEvent).getEventType() != null) {
            switch (event.getEventType()) {
                case PROOF_OF_EXISTENCE_FOUND: {
                    this.processPoE((ProofOfExistenceFoundEvent)event);
                    break;
                }
                case SIGNATURE_VALIDATION_STARTED: {
                    this.processSignature((StartSignatureValidationEvent)event);
                    break;
                }
                case SIGNATURE_VALIDATION_FAILURE: {
                    if (this.currentSignature == null) break;
                    this.currentSignature.setValidationSucceeded(false);
                    break;
                }
                case SIGNATURE_VALIDATION_SUCCESS: {
                    this.processSignatureSuccess();
                    break;
                }
                case CERTIFICATE_ISSUER_NOT_FROM_DOCUMENT: {
                    this.processIssuerCertMissing((AbstractCertificateChainEvent)event);
                    break;
                }
                case CERTIFICATE_ISSUER_NOT_FROM_DSS: {
                    this.processIssuerNotInDss((AbstractCertificateChainEvent)event);
                    break;
                }
                case REVOCATION_NOT_FROM_DSS: {
                    this.processRevocationNotInDss((AbstractCertificateChainEvent)event);
                    break;
                }
                case DSS_ENTRY_PROCESSED: {
                    this.dssFound = true;
                    this.dssHasPoe = this.poeFound;
                    break;
                }
                case DSS_NOT_TIMESTAMPED: {
                    this.processNotTimestampedRevocation((AbstractCertificateChainEvent)event);
                    break;
                }
                case ALGORITHM_USAGE: {
                    AlgorithmUsageEvent ae = (AlgorithmUsageEvent)rawEvent;
                    if (this.currentSignature == null || ae.isAllowedAccordingToEtsiTs119_312()) break;
                    if (!ae.isAllowedAccordingToAdES()) {
                        this.currentSignature.addForbiddenAlgorithmUsage(ae.toString());
                        break;
                    }
                    if (ae.isAllowedAccordingToEtsiTs119_312()) break;
                    this.currentSignature.addDiscouragedAlgorithmUsage(ae.toString());
                }
            }
        }
    }

    private void processRevocationNotInDss(AbstractCertificateChainEvent event) {
        if (this.currentSignature != null) {
            this.currentSignature.addRevocationDataNotInDSS(event.getCertificate());
        }
    }

    private void processNotTimestampedRevocation(AbstractCertificateChainEvent event) {
        if (this.currentSignature != null) {
            this.currentSignature.addRevocationDataNotTimestamped(event.getCertificate());
        }
    }

    private void processIssuerNotInDss(AbstractCertificateChainEvent event) {
        if (this.currentSignature != null) {
            this.currentSignature.addCertificateIssuerNotInDSS(event.getCertificate());
        }
    }

    private void processIssuerCertMissing(AbstractCertificateChainEvent event) {
        if (this.currentSignature != null) {
            this.currentSignature.addCertificateIssuerMissing(event.getCertificate());
        }
    }

    private void processSignatureSuccess() {
        if (this.currentSignature != null) {
            if (this.currentSignature instanceof DocumentTimestampRequirements) {
                this.poeFound = true;
            }
            this.currentSignature.setValidationSucceeded(true);
        }
        this.currentSignature = null;
    }

    private void processSignature(StartSignatureValidationEvent event) {
        SignatureRequirements sReqs = new SignatureRequirements(event.getSignatureName());
        this.getDictionaryInfo(event.getPdfSignature(), sReqs);
        this.getCmsInfo(event.getPdfSignature(), sReqs);
        this.signatureInfos.add(sReqs);
        this.currentSignature = sReqs;
    }

    private void processPoE(ProofOfExistenceFoundEvent poe) {
        ++this.timestampCount;
        if (poe.isDocumentTimestamp()) {
            DocumentTimestampRequirements tsReqs = new DocumentTimestampRequirements("timestamp" + this.timestampCount, this.dssFound);
            this.getDictionaryInfo(poe.getPdfSignature(), tsReqs);
            this.getCmsInfo(poe.getPdfSignature(), tsReqs);
            this.currentSignature = tsReqs;
            this.signatureInfos.add(tsReqs);
        }
    }

    private void getDictionaryInfo(PdfSignature sig, AbstractPadesLevelRequirements reqs) {
        PdfDictionary sigObj = (PdfDictionary)sig.getPdfObject();
        if (sigObj.containsKey(PdfName.M)) {
            reqs.setDictionaryEntryMPresent(true);
            PdfString dateAsString = sigObj.getAsString(PdfName.M);
            reqs.setDictionaryEntryMHasCorrectFormat(PdfDate.decode((String)dateAsString.getValue()) != null);
        }
        reqs.setDictionaryEntryContentsPresent(sigObj.containsKey(PdfName.Contents));
        reqs.setDictionaryEntryFilterPresent(sigObj.containsKey(PdfName.Filter));
        reqs.setDictionaryEntryByteRangePresent(sigObj.containsKey(PdfName.ByteRange));
        reqs.setDictionaryEntrySubFilterPresent(sigObj.containsKey(PdfName.SubFilter));
        reqs.setSignatureDictionaryEntrySubFilterValueIsETSICadesDetached(sigObj.containsKey(PdfName.SubFilter) && sigObj.getAsName(PdfName.SubFilter).equals((Object)PdfName.ETSI_CAdES_DETACHED));
        reqs.setDictionaryEntryReasonPresent(sigObj.containsKey(PdfName.Reason));
        reqs.setDictionaryEntryCertPresent(sigObj.containsKey(PdfName.Cert));
        reqs.setTimestampDictionaryEntrySubFilterValueEtsiRfc3161(sigObj.containsKey(PdfName.SubFilter) && sigObj.getAsName(PdfName.SubFilter).equals((Object)PdfName.ETSI_RFC3161));
        reqs.setDocumentTimestampPresent(this.poeFound);
    }

    private void getCmsInfo(PdfSignature sig, AbstractPadesLevelRequirements reqs) {
        try {
            CMSContainer cms = new CMSContainer(sig.getContents().getValueBytes());
            reqs.setSignedDataCertificatesPresent(!cms.getCertificates().isEmpty());
            reqs.setSignatureCertificatesContainsSigningCertificate(cms.getCertificates().stream().anyMatch(c -> c.equals(cms.getSignerInfo().getSigningCertificate())));
            reqs.setContentTypeValueIsIdData(cms.getSignerInfo().getSignedAttributes().stream().anyMatch(a -> "1.2.840.113549.1.9.3".equals(a.getType()) && "1.2.840.113549.1.7.1".equals(BC_FACTORY.createASN1Set((IASN1Encodable)a.getValue()).getObjectAt(0).toString())));
            reqs.setMessageDigestPresent(cms.getSignerInfo().getSignedAttributes().stream().anyMatch(a -> "1.2.840.113549.1.9.4".equals(a.getType())));
            reqs.setCommitmentTypeIndicationPresent(cms.getSignerInfo().getSignedAttributes().stream().anyMatch(a -> "1.2.840.113549.1.9.16.2.16".equals(a.getType())));
            reqs.setEssSigningCertificateV1Present(cms.getSignerInfo().getSignedAttributes().stream().anyMatch(a -> "1.2.840.113549.1.9.16.2.12".equals(a.getType())));
            reqs.setEssSigningCertificateV2Present(cms.getSignerInfo().getSignedAttributes().stream().anyMatch(a -> "1.2.840.113549.1.9.16.2.47".equals(a.getType())));
            reqs.setCmsSigningTimeAttributePresent(cms.getSignerInfo().getSignedAttributes().stream().anyMatch(a -> "1.2.840.113549.1.9.5".equals(a.getType())));
            reqs.setPoeSignaturePresent(this.poeFound || cms.getSignerInfo().getUnSignedAttributes().stream().anyMatch(a -> "1.2.840.113549.1.9.16.2.14".equals(a.getType())));
            reqs.setDSSPresent(this.dssFound);
            reqs.setPoeDssPresent(this.dssHasPoe);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

