/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.report.pades;

import com.itextpdf.signatures.validation.report.pades.AbstractPadesLevelRequirements;
import com.itextpdf.signatures.validation.report.pades.PAdESLevel;
import java.util.Collection;
import java.util.Map;

public class PAdESLevelReport {
    private static final PAdESLevel[] PADES_LEVELS = new PAdESLevel[]{PAdESLevel.B_B, PAdESLevel.B_T, PAdESLevel.B_LT, PAdESLevel.B_LTA};
    private final String signatureName;
    private final PAdESLevel highestAchievedLevel;
    private final Map<PAdESLevel, Collection<String>> nonConformaties;
    private final Map<PAdESLevel, Collection<String>> warnings;

    PAdESLevelReport(AbstractPadesLevelRequirements reqs, Iterable<PAdESLevelReport> timestampReports) {
        this.signatureName = reqs.getSignatureName();
        this.highestAchievedLevel = reqs.getHighestAchievedPadesLevel(timestampReports);
        this.nonConformaties = reqs.getNonConformaties();
        this.warnings = reqs.getWarnings();
    }

    public String getSignatureName() {
        return this.signatureName;
    }

    public PAdESLevel getLevel() {
        return this.highestAchievedLevel;
    }

    public Map<PAdESLevel, Collection<String>> getNonConformaties() {
        return this.nonConformaties;
    }

    public Map<PAdESLevel, Collection<String>> getWarnings() {
        return this.warnings;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("Signature: ").append(this.signatureName).append("\n\tHighestAchievedLevel: ").append((Object)this.getLevel()).append('\n');
        for (PAdESLevel l : PADES_LEVELS) {
            if (this.getNonConformaties().containsKey((Object)l) && !this.getNonConformaties().get((Object)l).isEmpty()) {
                sb.append('\t').append((Object)l).append(" nonconformaties: \n");
                for (String message : this.getNonConformaties().get((Object)l)) {
                    sb.append("\t\t").append(message).append('\n');
                }
            }
            if (!this.getWarnings().containsKey((Object)l) || this.getWarnings().get((Object)l).isEmpty()) continue;
            sb.append('\t').append((Object)l).append(" warnings:\n");
            for (String message : this.getWarnings().get((Object)l)) {
                sb.append("\t\t").append(message).append('\n');
            }
        }
        return sb.toString();
    }
}

